/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.logic;

import com.hbm.config.GeneralConfig;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.explosion.ExplosionBalefire;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.main.MainRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import org.apache.logging.log4j.Level;

public class EntityBalefire
extends Entity
implements IChunkLoader {
    public int age = 0;
    public int destructionRange = 0;
    public ExplosionBalefire exp;
    public int speed = 1;
    public boolean did = false;
    public boolean mute = false;
    private ForgeChunkManager.Ticket loaderTicket;
    List<ChunkPos> loadedChunks = new ArrayList<ChunkPos>();

    protected void func_70037_a(NBTTagCompound nbt) {
        this.age = nbt.func_74762_e("age");
        this.destructionRange = nbt.func_74762_e("destructionRange");
        this.speed = nbt.func_74762_e("speed");
        this.did = nbt.func_74767_n("did");
        this.mute = nbt.func_74767_n("mute");
        this.exp = new ExplosionBalefire((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.field_70170_p, this.destructionRange);
        this.exp.readFromNbt(nbt, "exp_");
        this.did = true;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("age", this.age);
        nbt.func_74768_a("destructionRange", this.destructionRange);
        nbt.func_74768_a("speed", this.speed);
        nbt.func_74757_a("did", this.did);
        nbt.func_74757_a("mute", this.mute);
        if (this.exp != null) {
            this.exp.saveToNbt(nbt, "exp_");
        }
    }

    public EntityBalefire(World p_i1582_1_) {
        super(p_i1582_1_);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.did) {
            if (GeneralConfig.enableExtendedLogging && !this.field_70170_p.field_72995_K) {
                MainRegistry.logger.log(Level.INFO, "[NUKE] Initialized BF explosion at " + this.field_70165_t + " / " + this.field_70163_u + " / " + this.field_70161_v + " with strength " + this.destructionRange + "!");
            }
            this.exp = new ExplosionBalefire((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.field_70170_p, this.destructionRange);
            this.did = true;
        }
        ++this.speed;
        boolean flag = false;
        for (int i = 0; i < this.speed; ++i) {
            flag = this.exp.update();
            if (!flag) continue;
            this.func_70106_y();
        }
        if (!this.mute && this.field_70146_Z.nextInt(5) == 0) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.AMBIENT, 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        if (!flag) {
            if (!this.mute) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187754_de, SoundCategory.AMBIENT, 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            }
            ExplosionNukeGeneric.dealDamage(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.destructionRange * 2);
        }
        ++this.age;
    }

    protected void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)new ChunkPos(this.field_70176_ah, this.field_70164_aj));
        }
    }

    @Override
    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ - 1));
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
        }
    }

    public EntityBalefire mute() {
        this.mute = true;
        return this;
    }
}

