/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.grenade;

import com.hbm.config.GeneralConfig;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.main.MainRegistry;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ReportedException;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public abstract class EntityGrenadeBouncyBase
extends Entity
implements IProjectile {
    protected EntityLivingBase thrower;
    protected String throwerName;
    protected int timer = 0;

    public EntityGrenadeBouncyBase(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityGrenadeBouncyBase(World world, EntityLivingBase living, EnumHand hand) {
        super(world);
        this.thrower = living;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v, living.field_70177_z, living.field_70125_A);
        if (hand == EnumHand.MAIN_HAND) {
            this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            this.field_70163_u -= (double)0.1f;
            this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        } else {
            this.field_70165_t += (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            this.field_70163_u -= (double)0.1f;
            this.field_70161_v += (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)((this.field_70125_A + this.func_70183_g()) / 180.0f * (float)Math.PI)) * f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.func_70182_d(), 1.0f);
        this.field_70125_A = 0.0f;
        this.field_70127_C = 0.0f;
    }

    public EntityGrenadeBouncyBase(World world, double posX, double posY, double posZ) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        this.func_70107_b(posX, posY, posZ);
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return p_70112_1_ < (d1 *= 64.0) * d1;
    }

    protected float func_70182_d() {
        return 1.5f;
    }

    protected float func_70183_g() {
        return 0.0f;
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    public void func_70186_c(double motionX, double motionY, double motionZ, float f0, float f1) {
        float f2 = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        motionX /= (double)f2;
        motionY /= (double)f2;
        motionZ /= (double)f2;
        motionX += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f1;
        motionY += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f1;
        motionZ += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f1;
        this.field_70159_w = motionX *= (double)f0;
        this.field_70181_x = motionY *= (double)f0;
        this.field_70179_y = motionZ *= (double)f0;
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double motionX, double motionY, double motionZ) {
        this.field_70159_w = motionX;
        this.field_70181_x = motionY;
        this.field_70179_y = motionZ;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
        }
    }

    public void func_70071_h_() {
        double d5;
        double d4;
        double d3;
        double d6;
        super.func_70071_h_();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70127_C = this.field_70125_A;
        this.field_70125_A = (float)((double)this.field_70125_A - Vec3.createVectorHelper(this.field_70159_w, this.field_70181_x, this.field_70179_y).lengthVector() * 25.0);
        double d0 = this.field_70159_w;
        double d1 = this.field_70181_x;
        double d2 = this.field_70179_y;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.field_70145_X = this.field_70170_p.field_72995_K ? false : this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
        this.moveBounce(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float f = 0.98f;
        if (this.field_70122_E) {
            BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            IBlockState underState = this.field_70170_p.func_180495_p(underPos);
            f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.98f;
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)f;
        this.func_70072_I();
        if (!this.field_70170_p.field_72995_K && (d6 = (d3 = this.field_70159_w - d0) * d3 + (d4 = this.field_70181_x - d1) * d4 + (d5 = this.field_70179_y - d2) * d5) > 0.01) {
            this.field_70160_al = true;
        }
        ++this.timer;
        if (this.timer >= this.getMaxTimer() && !this.field_70170_p.field_72995_K) {
            this.explode();
            String s = "null";
            if (this.thrower != null && this.thrower instanceof EntityPlayer) {
                s = ((EntityPlayer)this.thrower).func_145748_c_().func_150260_c();
            }
            if (GeneralConfig.enableExtendedLogging) {
                MainRegistry.logger.log(Level.INFO, "[GREN] Set off grenade at " + (int)this.field_70165_t + " / " + (int)this.field_70163_u + " / " + (int)this.field_70161_v + " by " + s + "!");
            }
        }
    }

    public void moveBounce(double x, double y, double z) {
        if (this.field_70145_X) {
            this.func_174826_a(this.func_174813_aQ().func_72317_d(x, y, z));
            this.func_174829_m();
        } else {
            boolean collidedZ;
            BlockPos blockpos1;
            IBlockState iblockstate1;
            Block block1;
            this.field_70170_p.field_72984_F.func_76320_a("move");
            if (this.field_70134_J) {
                this.field_70134_J = false;
                x *= 0.25;
                y *= (double)0.05f;
                z *= 0.25;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            double d2 = x;
            double d3 = y;
            double d4 = z;
            List list1 = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72321_a(x, y, z));
            if (y != 0.0) {
                int l = list1.size();
                for (int k = 0; k < l; ++k) {
                    y = ((AxisAlignedBB)list1.get(k)).func_72323_b(this.func_174813_aQ(), y);
                }
                this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, y, 0.0));
            }
            if (x != 0.0) {
                int l5 = list1.size();
                for (int j5 = 0; j5 < l5; ++j5) {
                    x = ((AxisAlignedBB)list1.get(j5)).func_72316_a(this.func_174813_aQ(), x);
                }
                if (x != 0.0) {
                    this.func_174826_a(this.func_174813_aQ().func_72317_d(x, 0.0, 0.0));
                }
            }
            if (z != 0.0) {
                int i6 = list1.size();
                for (int k5 = 0; k5 < i6; ++k5) {
                    z = ((AxisAlignedBB)list1.get(k5)).func_72322_c(this.func_174813_aQ(), z);
                }
                if (z != 0.0) {
                    this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, 0.0, z));
                }
            }
            this.field_70170_p.field_72984_F.func_76319_b();
            this.field_70170_p.field_72984_F.func_76320_a("rest");
            this.func_174829_m();
            this.field_70123_F = d2 != x || d4 != z;
            this.field_70124_G = d3 != y;
            this.field_70122_E = this.field_70124_G && d3 < 0.0;
            this.field_70132_H = this.field_70123_F || this.field_70124_G;
            int j6 = MathHelper.func_76128_c((double)this.field_70165_t);
            int i1 = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
            int k6 = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos blockpos = new BlockPos(j6, i1, k6);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            if (iblockstate.func_185904_a() == Material.field_151579_a && ((block1 = (iblockstate1 = this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_177230_c()) instanceof BlockFence || block1 instanceof BlockWall || block1 instanceof BlockFenceGate)) {
                iblockstate = iblockstate1;
                blockpos = blockpos1;
            }
            this.func_184231_a(y, this.field_70122_E, iblockstate, blockpos);
            if (d2 != x) {
                this.field_70159_w = 0.0;
            }
            if (d4 != z) {
                this.field_70179_y = 0.0;
            }
            boolean bounce = false;
            boolean collidedX = d2 != x;
            boolean collidedY = d3 != y;
            boolean bl = collidedZ = d4 != z;
            if (this.field_70132_H) {
                if (collidedY) {
                    this.field_70181_x *= -1.0;
                }
                if (collidedZ) {
                    this.field_70179_y *= -1.0;
                }
                if (collidedX) {
                    this.field_70159_w *= -1.0;
                }
                bounce = true;
                Vec3d mot = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                if (mot.func_72433_c() > 0.05) {
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, HBMSoundHandler.grenadeBounce, SoundCategory.HOSTILE, 2.0f, 1.0f);
                }
                this.field_70159_w *= this.getBounceMod() * 1.5;
                this.field_70181_x *= this.getBounceMod() * 1.5;
                this.field_70179_y *= this.getBounceMod() * 1.5;
            }
            Block block = iblockstate.func_177230_c();
            if (d3 != y && !bounce) {
                block.func_176216_a(this.field_70170_p, (Entity)this);
            }
            try {
                this.func_145775_I();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Checking entity block collision");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
                this.func_85029_a(crashreportcategory);
                throw new ReportedException(crashreport);
            }
            this.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.timer = nbt.func_74762_e("timer");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("timer", this.timer);
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    public EntityLivingBase getThrower() {
        if (this.thrower == null && this.throwerName != null && this.throwerName.length() > 0) {
            this.thrower = this.field_70170_p.func_72924_a(this.throwerName);
        }
        return this.thrower;
    }

    public abstract void explode();

    protected abstract int getMaxTimer();

    protected abstract double getBounceMod();
}

