/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.effect;

import com.hbm.config.BombConfig;
import com.hbm.config.RadiationConfig;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.interfaces.IConstantRenderer;
import com.hbm.main.MainRegistry;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.saveddata.AuxSavedData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class EntityRainDrop
extends Entity
implements IConstantRenderer,
IChunkLoader {
    private static final DataParameter<Integer> SCALE = EntityDataManager.func_187226_a(EntityRainDrop.class, (DataSerializer)DataSerializers.field_187192_b);
    public int revProgress;
    public int radProgress;
    public boolean done = false;
    private ForgeChunkManager.Ticket loaderTicket;
    private double fallingRadius;
    private boolean firstTick = true;
    private final List<Long> chunksToProcess = new ArrayList<Long>();
    private final List<Long> outerChunksToProcess = new ArrayList<Long>();
    private static int tickDelayStatic = BombConfig.fChunkSpeed;
    private int tickDelay = 0;
    List<ChunkPos> loadedChunks = new ArrayList<ChunkPos>();

    public EntityRainDrop(World p_i1582_1_) {
        super(p_i1582_1_);
        this.func_70105_a(4.0f, 20.0f);
        this.field_70158_ak = false;
        this.field_70178_ae = true;
    }

    public AxisAlignedBB func_184177_bl() {
        return new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public EntityRainDrop(World p_i1582_1_, int maxage) {
        super(p_i1582_1_);
        this.func_70105_a(4.0f, 20.0f);
        this.field_70178_ae = true;
    }

    protected void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
        this.field_70180_af.func_187214_a(SCALE, (Object)0);
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)new ChunkPos(this.field_70176_ah, this.field_70164_aj));
        }
    }

    @Override
    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ - 1));
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
        }
    }

    private void unloadAllChunks() {
        if (this.loaderTicket != null) {
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
        }
    }

    private void gatherChunks() {
        LinkedHashSet<Long> chunks = new LinkedHashSet<Long>();
        LinkedHashSet<Long> outerChunks = new LinkedHashSet<Long>();
        int outerRange = this.getScale();
        int adjustedMaxAngle = 20 * outerRange / 32;
        for (int angle = 0; angle <= adjustedMaxAngle; ++angle) {
            Vec3 vector = Vec3.createVectorHelper(outerRange, 0.0, 0.0);
            vector.rotateAroundY((float)((double)angle * Math.PI / 180.0 / ((double)adjustedMaxAngle / 360.0)));
            outerChunks.add(ChunkPos.func_77272_a((int)((int)(this.field_70165_t + vector.xCoord) >> 4), (int)((int)(this.field_70161_v + vector.zCoord) >> 4)));
        }
        for (int distance = 0; distance <= outerRange; distance += 8) {
            for (int angle = 0; angle <= adjustedMaxAngle; ++angle) {
                Vec3 vector = Vec3.createVectorHelper(distance, 0.0, 0.0);
                vector.rotateAroundY((float)((double)angle * Math.PI / 180.0 / ((double)adjustedMaxAngle / 360.0)));
                long chunkCoord = ChunkPos.func_77272_a((int)((int)(this.field_70165_t + vector.xCoord) >> 4), (int)((int)(this.field_70161_v + vector.zCoord) >> 4));
                if (outerChunks.contains(chunkCoord)) continue;
                chunks.add(chunkCoord);
            }
        }
        this.chunksToProcess.addAll(chunks);
        this.outerChunksToProcess.addAll(outerChunks);
        Collections.reverse(this.chunksToProcess);
        Collections.reverse(this.outerChunksToProcess);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.firstTick) {
                if (this.chunksToProcess.isEmpty() && this.outerChunksToProcess.isEmpty()) {
                    this.gatherChunks();
                }
                this.firstTick = false;
            }
            if (this.tickDelay == 0) {
                this.tickDelay = tickDelayStatic;
                if (!this.chunksToProcess.isEmpty()) {
                    long chunkPos = this.chunksToProcess.remove(this.chunksToProcess.size() - 1);
                    int chunkPosX = (int)(chunkPos & Integer.MAX_VALUE);
                    int chunkPosZ = (int)(chunkPos >> 32 & Integer.MAX_VALUE);
                    for (int x = chunkPosX << 4; x < (chunkPosX << 4) + 16; ++x) {
                        for (int z = chunkPosZ << 4; z < (chunkPosZ << 4) + 16; ++z) {
                            this.stomp(new BlockPos.MutableBlockPos(x, 0, z), Math.hypot((double)x - this.field_70165_t, (double)z - this.field_70161_v) * 100.0 / (double)this.getScale());
                        }
                    }
                } else if (!this.outerChunksToProcess.isEmpty()) {
                    long chunkPos = this.outerChunksToProcess.remove(this.outerChunksToProcess.size() - 1);
                    int chunkPosX = (int)(chunkPos & Integer.MAX_VALUE);
                    int chunkPosZ = (int)(chunkPos >> 32 & Integer.MAX_VALUE);
                    for (int x = chunkPosX << 4; x < (chunkPosX << 4) + 16; ++x) {
                        for (int z = chunkPosZ << 4; z < (chunkPosZ << 4) + 16; ++z) {
                            double distance = Math.hypot((double)x - this.field_70165_t, (double)z - this.field_70161_v);
                            if (!(distance <= (double)this.getScale())) continue;
                            this.stomp(new BlockPos.MutableBlockPos(x, 0, z), distance * 100.0 / (double)this.getScale());
                        }
                    }
                } else {
                    this.func_70106_y();
                }
            }
            --this.tickDelay;
            if (this.field_70128_L) {
                this.unloadAllChunks();
                this.done = true;
                if (RadiationConfig.rain > 0 && this.getScale() > 150) {
                    this.field_70170_p.func_72912_H().func_76084_b(true);
                    this.field_70170_p.func_72912_H().func_76069_a(true);
                    this.field_70170_p.func_72912_H().func_76080_g(RadiationConfig.rain);
                    this.field_70170_p.func_72912_H().func_76090_f(RadiationConfig.rain);
                    AuxSavedData.setThunder(this.field_70170_p, RadiationConfig.rain);
                }
            }
        }
    }

    private void letFall(World world, BlockPos.MutableBlockPos pos, int lastGapHeight, int contactHeight) {
        int chance;
        int fallChance = RadiationConfig.blocksFallCh;
        if (fallChance < 1) {
            return;
        }
        if (fallChance < 100 && (chance = world.field_73012_v.nextInt(100)) < fallChance) {
            return;
        }
        int bottomHeight = lastGapHeight;
        BlockPos.MutableBlockPos gapPos = new BlockPos.MutableBlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        for (int i = lastGapHeight; i <= contactHeight; ++i) {
            pos.func_185336_p(i);
            Block b = world.func_180495_p((BlockPos)pos).func_177230_c();
            if (b.func_176200_f((IBlockAccess)world, (BlockPos)pos)) continue;
            float hardness = b.func_149638_a(null);
            if (hardness > 0.0f && hardness < 10.0f && i != bottomHeight) {
                gapPos.func_185336_p(bottomHeight);
                world.func_175656_a((BlockPos)gapPos, world.func_180495_p((BlockPos)pos));
                world.func_175698_g((BlockPos)pos);
            }
            ++bottomHeight;
        }
    }

    private void stomp(BlockPos.MutableBlockPos pos, double dist) {
        int stoneDepth = 0;
        int maxStoneDepth = 6;
        boolean lastReachedStone = false;
        boolean reachedStone = false;
        int contactHeight = 420;
        int lastGapHeight = 420;
        boolean gapFound = false;
        for (int y = 255; y >= 0; --y) {
            pos.func_185336_p(y);
            IBlockState b = this.field_70170_p.func_180495_p((BlockPos)pos);
            Block bblock = b.func_177230_c();
            Material bmaterial = b.func_185904_a();
            lastReachedStone = reachedStone;
            if (bblock.func_149703_v() && contactHeight == 420) {
                contactHeight = Math.min(y + 1, 255);
            }
            if (reachedStone && bmaterial != Material.field_151579_a) {
                ++stoneDepth;
            } else {
                boolean bl = reachedStone = b.func_185904_a() == Material.field_151576_e;
            }
            if (reachedStone && stoneDepth > maxStoneDepth) break;
            if (bmaterial != Material.field_151579_a && !bmaterial.func_76224_d() || y >= contactHeight) continue;
            gapFound = true;
            lastGapHeight = y;
        }
        if (gapFound) {
            this.letFall(this.field_70170_p, pos, lastGapHeight, contactHeight);
        }
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
        this.setScale(p_70037_1_.func_74762_e("scale"));
        this.revProgress = p_70037_1_.func_74762_e("revProgress");
        this.radProgress = p_70037_1_.func_74762_e("radProgress");
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
        p_70014_1_.func_74768_a("scale", this.getScale());
        p_70014_1_.func_74768_a("revProgress", this.revProgress);
        p_70014_1_.func_74768_a("radProgress", this.radProgress);
    }

    public void setScale(int i) {
        this.field_70180_af.func_187227_b(SCALE, (Object)(i + 16));
    }

    public int getScale() {
        int scale = (Integer)this.field_70180_af.func_187225_a(SCALE);
        return scale == 0 ? 1 : scale;
    }
}

