/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.effect;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.WasteLog;
import com.hbm.config.BombConfig;
import com.hbm.config.VersatileConfig;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.interfaces.IConstantRenderer;
import com.hbm.main.MainRegistry;
import com.hbm.util.ContaminationUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class EntityFalloutUnderGround
extends Entity
implements IConstantRenderer,
IChunkLoader {
    private static final DataParameter<Integer> SCALE = EntityDataManager.func_187226_a(EntityFalloutUnderGround.class, (DataSerializer)DataSerializers.field_187192_b);
    public boolean done;
    private int maxSamples;
    private int currentSample;
    private int radius;
    private ForgeChunkManager.Ticket loaderTicket;
    private double s0;
    private double s1;
    private double s2;
    private double s3;
    private double s4;
    private double s5;
    private double s6;
    private double phi;
    List<ChunkPos> loadedChunks = new ArrayList<ChunkPos>();

    public EntityFalloutUnderGround(World p_i1582_1_) {
        super(p_i1582_1_);
        this.func_70105_a(4.0f, 20.0f);
        this.field_70158_ak = false;
        this.field_70178_ae = true;
        this.phi = Math.PI * (3.0 - Math.sqrt(5.0));
        this.done = false;
        this.currentSample = 0;
    }

    public AxisAlignedBB func_184177_bl() {
        return new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public EntityFalloutUnderGround(World p_i1582_1_, int maxage) {
        super(p_i1582_1_);
        this.func_70105_a(4.0f, 20.0f);
        this.field_70178_ae = true;
        this.phi = (float)(Math.PI * (3.0 - Math.sqrt(5.0)));
        this.done = false;
        this.currentSample = 0;
    }

    protected void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
        this.field_70180_af.func_187214_a(SCALE, (Object)0);
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)new ChunkPos(this.field_70176_ah, this.field_70164_aj));
        }
    }

    @Override
    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ - 1));
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            ContaminationUtil.radiate(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.radius, (float)Math.pow(this.radius, 2.0), 0.0f);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int rayCounter = 0;
            for (int sample = this.currentSample; sample < this.maxSamples; ++sample) {
                this.currentSample = sample;
                if (rayCounter > BombConfig.mk4) break;
                double fy = 2.0 * (double)sample / ((double)this.maxSamples - 1.0) - 1.0;
                double fr = Math.sqrt(1.0 - fy * fy);
                double theta = this.phi * (double)sample;
                this.stompRadRay(pos, Math.cos(theta) * fr, fy, Math.sin(theta) * fr);
                ++rayCounter;
            }
            if (this.currentSample >= this.maxSamples - 1) {
                this.done = true;
                this.func_70106_y();
            }
        }
    }

    private void stompRadRay(BlockPos.MutableBlockPos pos, double directionX, double directionY, double directionZ) {
        for (int l = 0; l < this.radius; ++l) {
            pos.func_189532_c(this.field_70165_t + directionX * (double)l, this.field_70163_u + directionY * (double)l, this.field_70161_v + directionZ * (double)l);
            if (this.field_70170_p.func_175623_d((BlockPos)pos)) continue;
            IBlockState b = this.field_70170_p.func_180495_p((BlockPos)pos);
            Block bblock = b.func_177230_c();
            if (bblock == Blocks.field_150348_b) {
                if ((double)l > this.s1) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_slaked.func_176223_P());
                } else if ((double)l > this.s2) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_0.func_176223_P());
                } else if ((double)l > this.s3) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_1.func_176223_P());
                } else if ((double)l > this.s4) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_2.func_176223_P());
                } else if ((double)l > this.s5) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_3.func_176223_P());
                } else if ((double)l > this.s6) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_4.func_176223_P());
                } else if ((double)l <= this.s6) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_core.func_176223_P());
                }
                return;
            }
            if (bblock == Blocks.field_150357_h || bblock == ModBlocks.ore_bedrock_oil || bblock == ModBlocks.ore_bedrock_block) {
                this.field_70170_p.func_175656_a(pos.func_177982_a(0, 1, 0), ModBlocks.toxic_block.func_176223_P());
                return;
            }
            if (bblock instanceof BlockLeaves) {
                if ((double)l > this.s1) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.waste_leaves.func_176223_P());
                    continue;
                }
                this.field_70170_p.func_175698_g((BlockPos)pos);
                this.field_70170_p.func_180497_b((BlockPos)pos, this.field_70170_p.func_180495_p((BlockPos)pos).func_177230_c(), 0, 2);
                continue;
            }
            if (bblock instanceof BlockBush && this.field_70170_p.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177230_c() == Blocks.field_150349_c) {
                this.field_70170_p.func_175656_a(pos.func_177982_a(0, -1, 0), ModBlocks.waste_earth.func_176223_P());
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.waste_grass_tall.func_176223_P());
                continue;
            }
            if (bblock == Blocks.field_150349_c) {
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.waste_earth.func_176223_P());
                return;
            }
            if (bblock == Blocks.field_150346_d) {
                BlockDirt.DirtType meta = (BlockDirt.DirtType)b.func_177229_b((IProperty)BlockDirt.field_176386_a);
                if (meta == BlockDirt.DirtType.DIRT) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.waste_dirt.func_176223_P());
                } else if (meta == BlockDirt.DirtType.COARSE_DIRT) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.waste_gravel.func_176223_P());
                } else if (meta == BlockDirt.DirtType.PODZOL) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.waste_mycelium.func_176223_P());
                }
                return;
            }
            if (bblock == Blocks.field_150431_aC) {
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.fallout.func_176223_P());
                continue;
            }
            if (bblock == Blocks.field_150433_aE) {
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.block_fallout.func_176223_P());
                continue;
            }
            if (bblock == Blocks.field_150391_bh) {
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.waste_mycelium.func_176223_P());
                return;
            }
            if (bblock == Blocks.field_150351_n) {
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.waste_gravel.func_176223_P());
                return;
            }
            if (bblock == Blocks.field_150354_m) {
                BlockSand.EnumType meta = (BlockSand.EnumType)b.func_177229_b((IProperty)BlockSand.field_176504_a);
                if (this.field_70146_Z.nextInt(60) == 0) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, meta == BlockSand.EnumType.SAND ? ModBlocks.waste_trinitite.func_176223_P() : ModBlocks.waste_trinitite_red.func_176223_P());
                } else {
                    this.field_70170_p.func_175656_a((BlockPos)pos, meta == BlockSand.EnumType.SAND ? ModBlocks.waste_sand.func_176223_P() : ModBlocks.waste_sand_red.func_176223_P());
                }
                return;
            }
            if (bblock == Blocks.field_150435_aG) {
                this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150405_ch.func_176223_P());
                return;
            }
            if (bblock == Blocks.field_150341_Y) {
                this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150365_q.func_176223_P());
                return;
            }
            if (bblock == Blocks.field_150365_q) {
                if ((double)l < this.s6) {
                    int ra = this.field_70146_Z.nextInt(150);
                    if (ra < 7) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150482_ag.func_176223_P());
                    } else if (ra < 10) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150412_bA.func_176223_P());
                    }
                }
                return;
            }
            if (bblock == Blocks.field_150420_aW || bblock == Blocks.field_150419_aX) {
                if ((double)l < this.s0) {
                    BlockHugeMushroom.EnumType meta = (BlockHugeMushroom.EnumType)b.func_177229_b((IProperty)BlockHugeMushroom.field_176380_a);
                    if (meta == BlockHugeMushroom.EnumType.STEM) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.mush_block_stem.func_176223_P());
                    } else {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.mush_block.func_176223_P());
                    }
                }
                return;
            }
            if (bblock instanceof BlockLog) {
                if ((double)l < this.s0) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ((WasteLog)ModBlocks.waste_log).getSameRotationState(b));
                }
                return;
            }
            if (b.func_185904_a() == Material.field_151575_d && bblock != ModBlocks.waste_log) {
                if ((double)l < this.s0) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.waste_planks.func_176223_P());
                }
                return;
            }
            if (bblock == ModBlocks.ore_uranium) {
                if ((double)l <= this.s6) {
                    if (this.field_70146_Z.nextInt(1 + VersatileConfig.getSchrabOreChance()) == 0) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_schrabidium.func_176223_P());
                    } else {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_uranium_scorched.func_176223_P());
                    }
                }
                return;
            }
            if (bblock == ModBlocks.ore_nether_uranium) {
                if ((double)l <= this.s5) {
                    if (this.field_70146_Z.nextInt(1 + VersatileConfig.getSchrabOreChance()) == 0) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_nether_schrabidium.func_176223_P());
                    } else {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_nether_uranium_scorched.func_176223_P());
                    }
                }
                return;
            }
            if (bblock == ModBlocks.ore_gneiss_uranium) {
                if ((double)l <= this.s4) {
                    if (this.field_70146_Z.nextInt(1 + VersatileConfig.getSchrabOreChance() / 2) == 0) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_gneiss_schrabidium.func_176223_P());
                    } else {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_gneiss_uranium_scorched.func_176223_P());
                    }
                }
                return;
            }
            if (bblock == ModBlocks.brick_concrete) {
                if (this.field_70146_Z.nextInt(60) == 0) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.brick_concrete_broken.func_176223_P());
                }
                return;
            }
            if (b.func_185904_a() != Material.field_151576_e && b.func_185904_a() != Material.field_151573_f) continue;
            return;
        }
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
        this.setScale(p_70037_1_.func_74762_e("scale"));
        this.currentSample = p_70037_1_.func_74762_e("currentSample");
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
        p_70014_1_.func_74768_a("scale", this.getScale());
        p_70014_1_.func_74768_a("currentSample", this.currentSample);
    }

    public void setScale(int i) {
        this.field_70180_af.func_187227_b(SCALE, (Object)i);
        this.s0 = 0.9 * (double)i;
        this.s1 = 0.75 * (double)i;
        this.s2 = 0.6 * (double)i;
        this.s3 = 0.4 * (double)i;
        this.s4 = 0.3 * (double)i;
        this.s5 = 0.2 * (double)i;
        this.s6 = 0.1 * (double)i;
        this.radius = i;
        this.maxSamples = (int)(Math.PI * Math.pow(i, 2.0));
    }

    public int getScale() {
        int scale = (Integer)this.field_70180_af.func_187225_a(SCALE);
        return scale == 0 ? 1 : scale;
    }
}

