/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.effect;

import com.hbm.config.BombConfig;
import com.hbm.config.CompatibilityConfig;
import com.hbm.config.RadiationConfig;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.interfaces.IConstantRenderer;
import com.hbm.main.MainRegistry;
import com.hbm.saveddata.AuxSavedData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class EntityDrying
extends Entity
implements IConstantRenderer,
IChunkLoader {
    private static final DataParameter<Integer> SCALE = EntityDataManager.func_187226_a(EntityDrying.class, (DataSerializer)DataSerializers.field_187192_b);
    public int revProgress;
    public int radProgress;
    public boolean done = false;
    public boolean dryingmode = true;
    private ForgeChunkManager.Ticket loaderTicket;
    private int maxArea = 1;
    private int areaProcessed = 0;
    private int speed = (int)((float)BombConfig.mk4 / 2.0f);
    private int xlast;
    private int waterLevel;
    List<ChunkPos> loadedChunks = new ArrayList<ChunkPos>();

    public EntityDrying(World p_i1582_1_) {
        super(p_i1582_1_);
        this.func_70105_a(4.0f, 20.0f);
        this.field_70158_ak = false;
        this.field_70178_ae = true;
        this.waterLevel = EntityDrying.getInt(CompatibilityConfig.fillCraterWithWater.get(this.field_70170_p.field_73011_w.getDimension()));
        if (this.waterLevel == 0) {
            this.waterLevel = this.field_70170_p.func_181545_F();
        } else if (this.waterLevel < 0 && this.waterLevel > -this.field_70170_p.func_181545_F()) {
            this.waterLevel = this.field_70170_p.func_181545_F() - this.waterLevel;
        }
    }

    public AxisAlignedBB func_184177_bl() {
        return new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public EntityDrying(World p_i1582_1_, int maxage) {
        super(p_i1582_1_);
        this.func_70105_a(4.0f, 20.0f);
        this.field_70178_ae = true;
    }

    protected void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
        this.field_70180_af.func_187214_a(SCALE, (Object)0);
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)new ChunkPos(this.field_70176_ah, this.field_70164_aj));
        }
    }

    @Override
    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ - 1));
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            int radius = this.getScale();
            int counter = 0;
            if (this.areaProcessed < this.maxArea && this.xlast < radius) {
                int x = (int)(this.field_70165_t + (double)this.xlast);
                while ((double)x <= this.field_70165_t + (double)radius) {
                    int z = (int)(this.field_70161_v - (double)radius);
                    while ((double)z <= this.field_70161_v + (double)radius) {
                        if (counter <= this.speed) {
                            this.dry(new BlockPos.MutableBlockPos(x, 0, z));
                            ++this.areaProcessed;
                            ++counter;
                        } else {
                            return;
                        }
                        ++z;
                    }
                    ++this.xlast;
                    ++x;
                }
            } else {
                this.done = true;
                this.func_70106_y();
                if (RadiationConfig.rain > 0 && this.getScale() > 150) {
                    this.field_70170_p.func_72912_H().func_76084_b(true);
                    this.field_70170_p.func_72912_H().func_76069_a(true);
                    this.field_70170_p.func_72912_H().func_76080_g(RadiationConfig.rain);
                    this.field_70170_p.func_72912_H().func_76090_f(RadiationConfig.rain);
                    AuxSavedData.setThunder(this.field_70170_p, RadiationConfig.rain);
                }
            }
        }
    }

    private static int getInt(Object e) {
        if (e == null) {
            return 0;
        }
        return (Integer)e;
    }

    private void dry(BlockPos.MutableBlockPos pos) {
        block4: {
            block3: {
                if (!this.dryingmode) break block3;
                for (int y = 255; y > 1; --y) {
                    Block b;
                    pos.func_185336_p(y);
                    if (this.field_70170_p.func_175623_d((BlockPos)pos) || (b = this.field_70170_p.func_180495_p((BlockPos)pos).func_177230_c()) != Blocks.field_150355_j && b != Blocks.field_150358_i) continue;
                    this.field_70170_p.func_175698_g((BlockPos)pos);
                }
                break block4;
            }
            if (!CompatibilityConfig.doFillCraterWithWater || this.waterLevel <= 1) break block4;
            for (int y = this.waterLevel - 1; y > 1; --y) {
                pos.func_185336_p(y);
                if (this.field_70170_p.func_175623_d((BlockPos)pos)) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150355_j.func_176223_P());
                    continue;
                }
                if (this.field_70170_p.func_180495_p((BlockPos)pos).func_177230_c() != Blocks.field_150358_i) continue;
                this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150355_j.func_176223_P());
            }
        }
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
        this.setScale(p_70037_1_.func_74762_e("scale"));
        this.revProgress = p_70037_1_.func_74762_e("revProgress");
        this.radProgress = p_70037_1_.func_74762_e("radProgress");
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
        p_70014_1_.func_74768_a("scale", this.getScale());
        p_70014_1_.func_74768_a("revProgress", this.revProgress);
        p_70014_1_.func_74768_a("radProgress", this.radProgress);
    }

    public void setScale(int i) {
        this.field_70180_af.func_187227_b(SCALE, (Object)i);
        this.maxArea = i * i * 8;
        this.xlast = -i;
        if (i > 150) {
            this.speed = BombConfig.mk4;
        }
    }

    public int getScale() {
        int scale = (Integer)this.field_70180_af.func_187225_a(SCALE);
        return scale == 0 ? 1 : scale;
    }
}

