/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.config;

import com.hbm.config.CommonConfig;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class RadiationConfig {
    public static int rain = 0;
    public static int cont = 0;
    public static int fogRad = 100;
    public static int fogCh = 50;
    public static int worldRad = 10;
    public static int worldRadThreshold = 20;
    public static boolean worldRadEffects = true;
    public static int blocksFallCh = 100;
    public static int railgunDamage = 100;
    public static int railgunBuffer = 500000000;
    public static int railgunUse = 250000000;
    public static int fireDuration = 80;
    public static boolean neutronActivation = true;
    public static int geigerX = 16;
    public static int geigerY = 2;
    public static int digammaX = 16;
    public static int digammaY = 18;

    public static void loadFromConfig(Configuration config) {
        String CATEGORY_NUKE = "06_explosions";
        String CATEGORY_RAD = "07_radiation";
        Property radRain = config.get("06_explosions", "6.06_falloutRainDuration", 2000);
        radRain.setComment("Duration of the thunderstorm after fallout in ticks (only large explosions)");
        rain = radRain.getInt();
        Property rainCont = config.get("06_explosions", "6.07_falloutRainRadiation", 1000);
        rainCont.setComment("Radiation in 100th RADs created by fallout rain");
        cont = rainCont.getInt();
        Property fogThresh = config.get("06_explosions", "6.08_fogThreshold", 100);
        fogThresh.setComment("Radiation in RADs required for fog to spawn");
        fogRad = fogThresh.getInt();
        Property fogChance = config.get("06_explosions", "6.09_fogChance", 50);
        fogChance.setComment("1:n chance of fog spawning every second - default 1/50");
        fogCh = fogChance.getInt();
        worldRad = CommonConfig.createConfigInt(config, "06_explosions", "6.10_worldRadCount", "How many block operations radiation can perform per tick", 10);
        worldRadThreshold = CommonConfig.createConfigInt(config, "06_explosions", "6.11_worldRadThreshold", "The least amount of RADs required for block modification to happen", 40);
        worldRadEffects = CommonConfig.createConfigBool(config, "06_explosions", "6.12_worldRadEffects", "Whether high radiation levels should perform changes in the world", true);
        blocksFallCh = CommonConfig.createConfigInt(config, "06_explosions", "6.13_blocksFallingChance", "The chance (in percentage form) that a block with low blast resistance will fall down. -1 Disables falling", 100);
        Property railDamage = config.get("06_explosions", "6.11_railgunDamage", 1000);
        railDamage.setComment("How much damage a railgun death blast does per tick");
        railgunDamage = railDamage.getInt();
        Property railBuffer = config.get("06_explosions", "6.12_railgunBuffer", 500000000);
        railBuffer.setComment("How much RF the railgun can store");
        railgunDamage = railBuffer.getInt();
        Property railUse = config.get("06_explosions", "6.13_railgunConsumption", 250000000);
        railUse.setComment("How much RF the railgun requires per shot");
        railgunDamage = railUse.getInt();
        Property fireDurationP = config.get("06_explosions", "6.14_fireDuration", 300);
        fireDurationP.setComment("How long the fire blast will last in ticks");
        fireDuration = fireDurationP.getInt();
        fogCh = CommonConfig.setDef(fogCh, 20);
        neutronActivation = CommonConfig.createConfigBool(config, "07_radiation", "7.01_itemContamination", "Whether high radiation levels should radiate items in inventory", true);
        geigerX = CommonConfig.createConfigInt(config, "07_radiation", "7.02_geigerX", "X Coordinate of the geiger counter gui (x=0 is on the right)", 16);
        geigerY = CommonConfig.createConfigInt(config, "07_radiation", "7.03_geigerY", "Y Coordinate of the geiger counter gui (y=0 is on the bottom)", 2);
        digammaX = CommonConfig.createConfigInt(config, "07_radiation", "7.04_digammaX", "X Coordinate of the digamma diagnostic gui (x=0 is on the right)", 16);
        digammaY = CommonConfig.createConfigInt(config, "07_radiation", "7.05_digammaY", "Y Coordinate of the digamma diagnostic counter gui (y=0 is on the bottom)", 18);
    }
}

