/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.capability;

import com.hbm.capability.HbmLivingProps;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class HbmLivingCapability {

    public static class EntityHbmPropsProvider
    implements ICapabilitySerializable<NBTBase> {
        public static final IEntityHbmProps DUMMY = new IEntityHbmProps(){

            @Override
            public float getRads() {
                return 0.0f;
            }

            @Override
            public void setRads(float rads) {
            }

            @Override
            public float getNeutrons() {
                return 0.0f;
            }

            @Override
            public void setNeutrons(float neutrons) {
            }

            @Override
            public void increaseRads(float rads) {
            }

            @Override
            public void decreaseRads(float rads) {
            }

            @Override
            public float getRadsEnv() {
                return 0.0f;
            }

            @Override
            public void setRadsEnv(float rads) {
            }

            @Override
            public float getRadBuf() {
                return 0.0f;
            }

            @Override
            public void setRadBuf(float buf) {
            }

            @Override
            public float getDigamma() {
                return 0.0f;
            }

            @Override
            public void setDigamma(float dig) {
            }

            @Override
            public void increaseDigamma(float dig) {
            }

            @Override
            public void decreaseDigamma(float dig) {
            }

            @Override
            public int getAsbestos() {
                return 0;
            }

            @Override
            public void setAsbestos(int asbestos) {
            }

            @Override
            public void saveNBTData(NBTTagCompound tag) {
            }

            @Override
            public void loadNBTData(NBTTagCompound tag) {
            }

            @Override
            public List<HbmLivingProps.ContaminationEffect> getContaminationEffectList() {
                return new ArrayList<HbmLivingProps.ContaminationEffect>(0);
            }

            @Override
            public int getBlacklung() {
                return 0;
            }

            @Override
            public void setBlacklung(int blacklung) {
            }

            @Override
            public int getBombTimer() {
                return 0;
            }

            @Override
            public void setBombTimer(int bombTimer) {
            }

            @Override
            public int getContagion() {
                return 0;
            }

            @Override
            public void setContagion(int cont) {
            }
        };
        @CapabilityInject(value=IEntityHbmProps.class)
        public static final Capability<IEntityHbmProps> ENT_HBM_PROPS_CAP = null;
        private IEntityHbmProps instance = (IEntityHbmProps)ENT_HBM_PROPS_CAP.getDefaultInstance();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == ENT_HBM_PROPS_CAP;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == ENT_HBM_PROPS_CAP ? ENT_HBM_PROPS_CAP.cast((Object)this.instance) : null);
        }

        public NBTBase serializeNBT() {
            return ENT_HBM_PROPS_CAP.getStorage().writeNBT(ENT_HBM_PROPS_CAP, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            ENT_HBM_PROPS_CAP.getStorage().readNBT(ENT_HBM_PROPS_CAP, (Object)this.instance, null, nbt);
        }
    }

    public static class EntityHbmPropsStorage
    implements Capability.IStorage<IEntityHbmProps> {
        public NBTBase writeNBT(Capability<IEntityHbmProps> capability, IEntityHbmProps instance, EnumFacing side) {
            NBTTagCompound tag = new NBTTagCompound();
            instance.saveNBTData(tag);
            return tag;
        }

        public void readNBT(Capability<IEntityHbmProps> capability, IEntityHbmProps instance, EnumFacing side, NBTBase nbt) {
            if (nbt instanceof NBTTagCompound) {
                NBTTagCompound tag = (NBTTagCompound)nbt;
                instance.loadNBTData(tag);
            }
        }
    }

    public static class EntityHbmProps
    implements IEntityHbmProps {
        public static final Callable<IEntityHbmProps> FACTORY = () -> new EntityHbmProps();
        private float rads = 0.0f;
        private float neutrons = 0.0f;
        private float envRads = 0.0f;
        private float radBuf = 0.0f;
        private float digamma = 0.0f;
        private int asbestos = 0;
        public static final int maxAsbestos = 72000;
        private int blacklung;
        public static final int maxBlacklung = 72000;
        private int bombTimer;
        private int contagion;
        private List<HbmLivingProps.ContaminationEffect> contamination = new ArrayList<HbmLivingProps.ContaminationEffect>();

        @Override
        public float getRads() {
            return this.rads;
        }

        @Override
        public void setRads(float rads) {
            this.rads = MathHelper.func_76131_a((float)rads, (float)0.0f, (float)2500.0f);
        }

        @Override
        public float getNeutrons() {
            return this.neutrons;
        }

        @Override
        public void setNeutrons(float neutrons) {
            this.neutrons = MathHelper.func_76131_a((float)neutrons, (float)0.0f, (float)2500.0f);
        }

        @Override
        public void increaseRads(float rads) {
            this.rads = MathHelper.func_76131_a((float)(this.rads + rads), (float)0.0f, (float)2500.0f);
        }

        @Override
        public void decreaseRads(float rads) {
            this.rads = MathHelper.func_76131_a((float)(this.rads - rads), (float)0.0f, (float)2500.0f);
        }

        @Override
        public float getRadsEnv() {
            return this.envRads;
        }

        @Override
        public void setRadsEnv(float rads) {
            this.envRads = rads;
        }

        @Override
        public float getRadBuf() {
            return this.radBuf;
        }

        @Override
        public void setRadBuf(float buf) {
            this.radBuf = buf;
        }

        @Override
        public float getDigamma() {
            return this.digamma;
        }

        @Override
        public void setDigamma(float dig) {
            this.digamma = dig;
        }

        @Override
        public void increaseDigamma(float dig) {
            this.digamma = MathHelper.func_76131_a((float)(this.digamma + dig), (float)0.0f, (float)1000.0f);
        }

        @Override
        public void decreaseDigamma(float dig) {
            this.digamma = MathHelper.func_76131_a((float)(this.digamma - dig), (float)0.0f, (float)1000.0f);
        }

        @Override
        public int getAsbestos() {
            return this.asbestos;
        }

        @Override
        public void setAsbestos(int asbestos) {
            this.asbestos = asbestos;
        }

        @Override
        public int getBlacklung() {
            return this.blacklung;
        }

        @Override
        public void setBlacklung(int blacklung) {
            this.blacklung = blacklung;
        }

        @Override
        public int getBombTimer() {
            return this.bombTimer;
        }

        @Override
        public void setBombTimer(int bombTimer) {
            this.bombTimer = bombTimer;
        }

        @Override
        public int getContagion() {
            return this.contagion;
        }

        @Override
        public void setContagion(int cont) {
            this.contagion = cont;
        }

        @Override
        public List<HbmLivingProps.ContaminationEffect> getContaminationEffectList() {
            return this.contamination;
        }

        @Override
        public void saveNBTData(NBTTagCompound tag) {
            tag.func_74776_a("rads", this.getRads());
            tag.func_74776_a("neutrons", this.getNeutrons());
            tag.func_74776_a("envRads", this.getRadsEnv());
            tag.func_74776_a("radBuf", this.getRadBuf());
            tag.func_74776_a("digamma", this.getDigamma());
            tag.func_74768_a("asbestos", this.getAsbestos());
            tag.func_74768_a("blacklung", this.blacklung);
            tag.func_74768_a("bombtimer", this.bombTimer);
            tag.func_74768_a("contagion", this.contagion);
            tag.func_74768_a("conteffectsize", this.contamination.size());
            for (int i = 0; i < this.contamination.size(); ++i) {
                this.contamination.get(i).save(tag, i);
            }
        }

        @Override
        public void loadNBTData(NBTTagCompound tag) {
            this.setRads(tag.func_74760_g("rads"));
            this.setNeutrons(tag.func_74760_g("neutrons"));
            this.setRadsEnv(tag.func_74760_g("envRads"));
            this.setRadBuf(tag.func_74760_g("radBuf"));
            this.setDigamma(tag.func_74760_g("digamma"));
            this.setAsbestos(tag.func_74762_e("asbestos"));
            this.setBlacklung(tag.func_74762_e("blacklung"));
            this.setBombTimer(tag.func_74762_e("bombtimer"));
            this.setContagion(tag.func_74762_e("contagion"));
            this.contamination.clear();
            for (int i = 0; i < tag.func_74762_e("conteffectsize"); ++i) {
                this.contamination.add(HbmLivingProps.ContaminationEffect.load(tag, i));
            }
        }
    }

    public static interface IEntityHbmProps {
        public float getRads();

        public void setRads(float var1);

        public void increaseRads(float var1);

        public void decreaseRads(float var1);

        public float getNeutrons();

        public void setNeutrons(float var1);

        public float getRadsEnv();

        public void setRadsEnv(float var1);

        public float getRadBuf();

        public void setRadBuf(float var1);

        public float getDigamma();

        public void setDigamma(float var1);

        public void increaseDigamma(float var1);

        public void decreaseDigamma(float var1);

        public int getAsbestos();

        public void setAsbestos(int var1);

        public int getBlacklung();

        public void setBlacklung(int var1);

        public int getBombTimer();

        public void setBombTimer(int var1);

        public int getContagion();

        public void setContagion(int var1);

        public List<HbmLivingProps.ContaminationEffect> getContaminationEffectList();

        public void saveNBTData(NBTTagCompound var1);

        public void loadNBTData(NBTTagCompound var1);
    }
}

