/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.inventory.RefineryRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemForgeFluidIdentifier;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.oil.TileEntityMachineFractionTower;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MachineFractionTower
extends BlockDummyable
implements ILookOverlay {
    public MachineFractionTower(Material mat, String s) {
        super(mat, s);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityMachineFractionTower();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo(false, false, true);
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{2, 0, 1, 1, 1, 1};
    }

    @Override
    public int getOffset() {
        return 1;
    }

    public boolean func_180639_a(World world, BlockPos pos1, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            if (player.func_184586_b(hand).func_190926_b() || player.func_184586_b(hand).func_77973_b() == ModItems.forge_fluid_identifier) {
                int[] pos = this.findCore((IBlockAccess)world, pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p());
                if (pos == null) {
                    return false;
                }
                TileEntity te = world.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
                if (!(te instanceof TileEntityMachineFractionTower)) {
                    return false;
                }
                TileEntityMachineFractionTower frac = (TileEntityMachineFractionTower)te;
                if (player.func_184586_b(hand).func_190926_b()) {
                    if (world.field_72995_K) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "=== FRACTIONING TOWER Y:" + pos[1] + " ==="));
                        for (int i = 0; i < frac.tanks.length; ++i) {
                            player.func_145747_a(new TextComponentTranslation(frac.types[i].getUnlocalizedName(), new Object[0]).func_150257_a((ITextComponent)new TextComponentString(": " + frac.tanks[i].getFluidAmount() + "/" + frac.tanks[i].getCapacity() + "mB")));
                        }
                    }
                } else if (world.func_175625_s(new BlockPos(pos[0], pos[1] - 3, pos[2])) instanceof TileEntityMachineFractionTower) {
                    if (world.field_72995_K) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You can only change the type in the bottom segment!"));
                    }
                } else {
                    Fluid type = ItemForgeFluidIdentifier.getType(player.func_184586_b(hand));
                    if (RefineryRecipes.getFractions(type) == null) {
                        if (world.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentString("\u00a7cNo recipe found for \u00a7e" + type.getLocalizedName(new FluidStack(type, 1))));
                        }
                        return false;
                    }
                    frac.setTankType(0, type);
                    frac.func_70296_d();
                    if (world.field_72995_K) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Changed type to \u00a7a" + I18n.func_135052_a((String)type.getUnlocalizedName(), (Object[])new Object[0])));
                    }
                }
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        this.makeExtra(world, (x += dir.offsetX * o) + 1, y, z += dir.offsetZ * o);
        this.makeExtra(world, x - 1, y, z);
        this.makeExtra(world, x, y, z + 1);
        this.makeExtra(world, x, y, z - 1);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore((IBlockAccess)world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
        if (!(te instanceof TileEntityMachineFractionTower)) {
            return;
        }
        TileEntityMachineFractionTower frac = (TileEntityMachineFractionTower)te;
        ArrayList<String> text = new ArrayList<String>();
        for (int i = 0; i < frac.types.length; ++i) {
            if (frac.types[i] == null) continue;
            text.add((i < 1 ? "\u00a7a-> " : "\u00a7c<- ") + "\u00a7r" + frac.types[i].getLocalizedName(new FluidStack(frac.types[i], 1)) + ": " + frac.tanks[i].getFluidAmount() + "/" + frac.tanks[i].getCapacity() + "mB");
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }
}

