/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.lib.Library;
import com.hbm.tileentity.machine.TileEntityCharger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MachineCharger
extends BlockContainer
implements ITooltipProvider,
ILookOverlay {
    public final long maxThroughput;
    public final boolean pointingUp;

    public MachineCharger(Material mat, String s, long max, boolean pointingUp) {
        super(mat);
        this.maxThroughput = max / 20L;
        this.pointingUp = pointingUp;
        this.func_149663_c(s);
        this.setRegistryName(s);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCharger();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add("\u00a7aMax Chargerate: " + Library.getShortNumber(20L * this.maxThroughput) + "HE/s");
        this.addStandardInfo(tooltip);
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (!(te instanceof TileEntityCharger)) {
            return;
        }
        TileEntityCharger charger = (TileEntityCharger)te;
        ArrayList<String> text = new ArrayList<String>();
        if (charger.totalCapacity > 0L) {
            text.add(Library.getShortNumber(charger.totalEnergy) + "/" + Library.getShortNumber(charger.totalCapacity) + " HE");
            text.add("\u00a7a-> \u00a7r" + Library.getShortNumber(20L * charger.actualCharge) + "/" + Library.getShortNumber(20L * charger.charge) + "HE/s");
            text.add("&[" + Library.getColorProgress((double)charger.totalEnergy / (double)charger.totalCapacity) + "&]    " + Library.getPercentage((double)charger.totalEnergy / (double)charger.totalCapacity) + "%");
        } else {
            text.add("Nothing to charge");
        }
        ILookOverlay.printGeneric(event, this.func_149732_F(), 0xFFFF00, 0x404000, text);
    }
}

