/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ModBlocks;
import com.hbm.lib.InventoryHelper;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.TileEntityMachineBattery;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class MachineBattery
extends BlockContainer
implements ILookOverlay {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private long maxPower;

    public MachineBattery(Material materialIn, long power, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_149647_a(MainRegistry.machineTab);
        this.maxPower = power;
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMachineBattery(this.getMaxPower());
    }

    public long getMaxPower() {
        return this.maxPower;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && willHarvest) {
            ItemStack drop = new ItemStack((Block)this);
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityMachineBattery) {
                TileEntityMachineBattery battery = (TileEntityMachineBattery)te;
                NBTTagCompound nbt = new NBTTagCompound();
                battery.writeNBT(nbt);
                if (!nbt.func_82582_d()) {
                    drop.func_77982_d(nbt);
                }
            }
            InventoryHelper.spawnItemStack(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
        }
        return world.func_175698_g(pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        TileEntity te = worldIn.func_175625_s(pos);
        if (stack.func_77942_o() && te instanceof TileEntityMachineBattery) {
            TileEntityMachineBattery battery = (TileEntityMachineBattery)te;
            if (stack.func_82837_s()) {
                battery.setCustomName(stack.func_82833_r());
            }
            try {
                NBTTagCompound stackNBT = stack.func_77978_p();
                if (stackNBT.func_74764_b("NBT_PERSISTENT_KEY")) {
                    battery.readNBT(stackNBT);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            TileEntityMachineBattery entity = (TileEntityMachineBattery)world.func_175625_s(pos);
            if (entity != null) {
                player.openGui((Object)MainRegistry.instance, 21, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityMachineBattery) {
            InventoryHelper.dropInventoryItems(worldIn, pos, (ICapabilityProvider)((TileEntityMachineBattery)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileEntityMachineBattery)) {
            return 0;
        }
        TileEntityMachineBattery battery = (TileEntityMachineBattery)te;
        return (int)battery.getPowerRemainingScaled(15L);
    }

    public void func_190948_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        NBTTagCompound nbt;
        super.func_190948_a(stack, worldIn, list, flagIn);
        long charge = 0L;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("NBT_PERSISTENT_KEY")) {
            charge = nbt.func_74775_l("NBT_PERSISTENT_KEY").func_74763_f("power");
        }
        if (charge == 0L) {
            list.add("\u00a7c0\u00a74/" + Library.getShortNumber(this.maxPower) + "HE \u00a7c(0.0%)\u00a7r");
        } else {
            double percent = (double)Math.round(charge * 1000L / this.maxPower) * 0.1;
            String color = "\u00a7e";
            String color2 = "\u00a76";
            if (percent < 25.0) {
                color = "\u00a7c";
                color2 = "\u00a74";
            } else if (percent >= 75.0) {
                color = "\u00a7a";
                color2 = "\u00a72";
            }
            list.add(color + Library.getShortNumber(charge) + color2 + "/" + Library.getShortNumber(this.maxPower) + "HE " + color + "(" + percent + "%)\u00a7r");
        }
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (!(te instanceof TileEntityMachineBattery)) {
            return;
        }
        TileEntityMachineBattery battery = (TileEntityMachineBattery)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(Library.getShortNumber(battery.power) + "/" + Library.getShortNumber(this.getMaxPower()) + " HE");
        if (battery.powerDelta == 0L) {
            text.add("\u00a7e-- \u00a7r0HE/s");
        } else if (battery.powerDelta > 0L) {
            text.add("\u00a7a-> \u00a7r" + Library.getShortNumber(battery.powerDelta) + "HE/s");
        } else {
            text.add("\u00a7c<- \u00a7r" + Library.getShortNumber(-battery.powerDelta) + "HE/s");
        }
        text.add("&[" + Library.getColorProgress((double)battery.power / (double)this.getMaxPower()) + "&]    " + Library.getPercentage((double)battery.power / (double)this.getMaxPower()) + "%");
        ILookOverlay.printGeneric(event, this.func_149732_F(), 0xFFFF00, 0x404000, text);
    }
}

