/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.tileentity.deco.TileEntitySpinnyLight;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockSpinnyLight
extends BlockContainer {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static AxisAlignedBB[] boxes = new AxisAlignedBB[EnumFacing.field_82609_l.length];

    public BlockSpinnyLight(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySpinnyLight();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!playerIn.func_184586_b(hand).func_190926_b() && !worldIn.field_72995_K) {
            int[] ores;
            for (int ore : ores = OreDictionary.getOreIDs((ItemStack)playerIn.func_184586_b(hand))) {
                String name = OreDictionary.getOreName((int)ore);
                if (name.equals("dyeLightBlue")) {
                    name = "dyeLight_Blue";
                }
                if (name.equals("dyeLightGray")) {
                    name = "dyeSilver";
                }
                if (name.length() <= 3 || !name.startsWith("dye")) continue;
                try {
                    EnumDyeColor color = EnumDyeColor.valueOf((String)name.substring(3, name.length()).toUpperCase());
                    TileEntitySpinnyLight ent = (TileEntitySpinnyLight)worldIn.func_175625_s(pos);
                    ent.color = color;
                    ent.func_70296_d();
                    worldIn.func_184138_a(pos, state, state, 6);
                    if (!playerIn.func_184812_l_()) {
                        playerIn.func_184586_b(hand).func_190918_g(1);
                    }
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        tooltip.add("Change color by right clicking with dye");
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return boxes[((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal()];
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return BlockSpinnyLight.canPlaceBlock(worldIn, pos, side);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!BlockSpinnyLight.canPlaceBlock(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canPlaceBlock(World worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        boolean flag = iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, direction) == BlockFaceShape.SOLID;
        Block block = iblockstate.func_177230_c();
        if (direction == EnumFacing.UP) {
            return iblockstate.func_185896_q() || !BlockSpinnyLight.func_193384_b((Block)block) && flag;
        }
        return !BlockSpinnyLight.func_193382_c((Block)block) && flag;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return BlockSpinnyLight.canPlaceBlock(worldIn, pos, facing) ? this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)POWERED, (Comparable)Boolean.FALSE) : this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)POWERED, (Comparable)Boolean.FALSE);
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (this.func_176196_c(worldIn, pos)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.checkForDrop(world, pos, state) && !BlockSpinnyLight.canPlaceBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            return;
        }
        if (world.func_175687_A(pos) > 0) {
            if (!((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                TileEntity te = world.func_175625_s(pos);
                world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
                te.func_145829_t();
                world.func_175690_a(pos, te);
            }
        } else if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            TileEntity te = world.func_175625_s(pos);
            world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            te.func_145829_t();
            world.func_175690_a(pos, te);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 5 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    public int func_176201_c(IBlockState state) {
        int powered = (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
        int facing = ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
        return facing | powered << 3;
    }

    public IBlockState func_176203_a(int meta) {
        boolean powered = (meta >>> 3 & 1) > 0;
        EnumFacing facing = EnumFacing.field_82609_l[meta & 7];
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    static {
        BlockSpinnyLight.boxes[EnumFacing.UP.ordinal()] = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, (double)0.4f, 0.7);
        BlockSpinnyLight.boxes[EnumFacing.DOWN.ordinal()] = new AxisAlignedBB(0.3, 0.6, 0.3, 0.7, 1.0, 0.7);
        BlockSpinnyLight.boxes[EnumFacing.NORTH.ordinal()] = new AxisAlignedBB(0.3, 0.3, 0.6, 0.7, 0.7, 1.0);
        BlockSpinnyLight.boxes[EnumFacing.SOUTH.ordinal()] = new AxisAlignedBB(0.3, 0.3, 0.0, 0.7, 0.7, 0.4);
        BlockSpinnyLight.boxes[EnumFacing.EAST.ordinal()] = new AxisAlignedBB(0.0, 0.3, 0.3, 0.4, 0.7, 0.7);
        BlockSpinnyLight.boxes[EnumFacing.WEST.ordinal()] = new AxisAlignedBB(0.6, 0.3, 0.3, 1.0, 0.7, 0.7);
    }
}

