/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.RadiationSystemNT;
import com.hbm.interfaces.IDoor;
import com.hbm.interfaces.IKeypadHandler;
import com.hbm.interfaces.IRadResistantBlock;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.TileEntitySlidingBlastDoorKeypad;
import com.hbm.tileentity.machine.TileEntitySlidingBlastDoor;
import com.hbm.util.KeypadClient;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSlidingBlastDoor
extends BlockDummyable
implements IRadResistantBlock {
    public BlockSlidingBlastDoor(Material materialIn, String s) {
        super(materialIn, s);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (this == ModBlocks.sliding_blast_door_keypad) {
            return new TileEntitySlidingBlastDoorKeypad();
        }
        if (meta >= 12) {
            return new TileEntitySlidingBlastDoor();
        }
        return null;
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        float hardness = this.func_149638_a(null);
        tooltip.add("\u00a72[Radiation Shielding]\u00a7r");
        if (hardness > 50.0f) {
            tooltip.add("\u00a76Blast Resistance: " + hardness + "\u00a7r");
        }
        if (this == ModBlocks.sliding_blast_door) {
            tooltip.add("Variant: Window");
        } else if (this == ModBlocks.sliding_blast_door_2) {
            tooltip.add("Variant: Keypad");
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (world.field_72995_K && te instanceof IKeypadHandler) {
            return this.handleClickClient(te, pos);
        }
        if (!world.field_72995_K && !playerIn.func_70093_af()) {
            if (world.func_180495_p(pos).func_177230_c() == ModBlocks.sliding_blast_door_keypad) {
                return super.func_180639_a(world, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
            }
            int[] pos1 = this.findCore((IBlockAccess)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (pos1 == null) {
                return false;
            }
            TileEntitySlidingBlastDoor door = (TileEntitySlidingBlastDoor)world.func_175625_s(new BlockPos(pos1[0], pos1[1], pos1[2]));
            if (door != null) {
                return door.tryToggle(playerIn);
            }
        }
        return super.func_180639_a(world, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean handleClickClient(TileEntity te, BlockPos pos) {
        KeypadClient pad = ((IKeypadHandler)te).getKeypad().client();
        if (pad.isPlayerMouseingOver(pos)) {
            return pad.client().playerClick(pos);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        KeypadClient pad;
        AxisAlignedBB key;
        TileEntity te = world.func_175625_s(pos);
        if (world.field_72995_K && te instanceof IKeypadHandler && (key = (pad = ((IKeypadHandler)te).getKeypad().client()).rayTrace(pos)) != null) {
            return key;
        }
        return super.func_180640_a(state, world, pos);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        AxisAlignedBB box = state.func_185890_d((IBlockAccess)worldIn, pos);
        if (box.field_72338_b == 0.0 && box.field_72337_e == 0.0) {
            return;
        }
        super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int meta = (Integer)state.func_177229_b((IProperty)META);
        if (this == ModBlocks.sliding_blast_door_keypad) {
            return field_185505_j;
        }
        if (this.hasExtra(meta)) {
            if (source.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            }
            return new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
        }
        TileEntity te = source.func_175625_s(pos);
        if (te instanceof TileEntitySlidingBlastDoor && !((TileEntitySlidingBlastDoor)te).shouldUseBB) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        return field_185505_j;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{3, 0, 0, 0, 3, 3};
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    protected void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        if (world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == ModBlocks.sliding_blast_door_2) {
            BlockPos pos = new BlockPos(x, y + 1, z).func_177967_a(dir.toEnumFacing().func_176746_e(), 3);
            BlockPos pos2 = new BlockPos(x, y + 1, z).func_177967_a(dir.toEnumFacing().func_176735_f(), 3);
            int meta = (Integer)world.func_180495_p(pos).func_177229_b((IProperty)META);
            int meta2 = (Integer)world.func_180495_p(pos2).func_177229_b((IProperty)META);
            BlockDummyable.safeRem = true;
            world.func_175656_a(pos, ModBlocks.sliding_blast_door_keypad.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(meta)));
            world.func_175656_a(pos2, ModBlocks.sliding_blast_door_keypad.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(meta2 + 6)));
            BlockDummyable.safeRem = false;
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        RadiationSystemNT.markChunkForRebuild(worldIn, pos);
        super.func_176213_c(worldIn, pos, state);
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        RadiationSystemNT.markChunkForRebuild(worldIn, pos);
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public boolean isRadResistant(World worldIn, BlockPos blockPos) {
        TileEntity entity;
        if (worldIn != null && (entity = worldIn.func_175625_s(blockPos)) != null && IDoor.class.isAssignableFrom(entity.getClass())) {
            return ((IDoor)entity).getState() == IDoor.DoorState.CLOSED;
        }
        return true;
    }
}

