/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IBomb;
import com.hbm.tileentity.machine.TileEntityHatch;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockSeal
extends Block
implements IBomb {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool ACTIVATED = PropertyBool.func_177716_a((String)"activated");

    public BlockSeal(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        ModBlocks.ALL_BLOCKS.add(this);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            int i = BlockSeal.getFrameSize(world, pos);
            if (i != 0) {
                if (BlockSeal.isSealClosed(world, pos, i)) {
                    BlockSeal.openSeal(world, pos, i);
                } else {
                    BlockSeal.closeSeal(world, pos, i);
                }
            }
            return true;
        }
        return false;
    }

    public static int getFrameSize(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != ModBlocks.seal_controller) {
            return 0;
        }
        int max = 7;
        for (int size = 1; size < max; ++size) {
            int Z;
            int X;
            boolean valid = true;
            int xOff = 0;
            int zOff = 0;
            if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
                zOff -= size;
            }
            if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.NORTH) {
                zOff += size;
            }
            if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
                xOff -= size;
            }
            if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
                xOff += size;
            }
            for (X = pos.func_177958_n() - size; X <= pos.func_177958_n() + size; ++X) {
                if (world.func_180495_p(new BlockPos(X + xOff, pos.func_177956_o(), pos.func_177952_p() + size + zOff)).func_177230_c() == ModBlocks.seal_frame || world.func_180495_p(new BlockPos(X + xOff, pos.func_177956_o(), pos.func_177952_p() + size + zOff)).func_177230_c() == ModBlocks.seal_controller) continue;
                valid = false;
            }
            for (X = pos.func_177958_n() - size; X <= pos.func_177958_n() + size; ++X) {
                if (world.func_180495_p(new BlockPos(X + xOff, pos.func_177956_o(), pos.func_177952_p() - size + zOff)).func_177230_c() == ModBlocks.seal_frame || world.func_180495_p(new BlockPos(X + xOff, pos.func_177956_o(), pos.func_177952_p() - size + zOff)).func_177230_c() == ModBlocks.seal_controller) continue;
                valid = false;
            }
            for (Z = pos.func_177952_p() - size; Z <= pos.func_177952_p() + size; ++Z) {
                if (world.func_180495_p(new BlockPos(pos.func_177958_n() - size + xOff, pos.func_177956_o(), Z + zOff)).func_177230_c() == ModBlocks.seal_frame || world.func_180495_p(new BlockPos(pos.func_177958_n() - size + xOff, pos.func_177956_o(), Z + zOff)).func_177230_c() == ModBlocks.seal_controller) continue;
                valid = false;
            }
            for (Z = pos.func_177952_p() - size; Z <= pos.func_177952_p() + size; ++Z) {
                if (world.func_180495_p(new BlockPos(pos.func_177958_n() + size + xOff, pos.func_177956_o(), Z + zOff)).func_177230_c() == ModBlocks.seal_frame || world.func_180495_p(new BlockPos(pos.func_177958_n() + size + xOff, pos.func_177956_o(), Z + zOff)).func_177230_c() == ModBlocks.seal_controller) continue;
                valid = false;
            }
            if (!valid) continue;
            return size;
        }
        return 0;
    }

    public static void closeSeal(World world, BlockPos pos, int size) {
        int xOff = 0;
        int zOff = 0;
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            zOff -= size;
        }
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.NORTH) {
            zOff += size;
        }
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
            xOff -= size;
        }
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
            xOff += size;
        }
        for (int X = pos.func_177958_n() - size + 1; X <= pos.func_177958_n() + size - 1; ++X) {
            for (int Z = pos.func_177952_p() - size + 1; Z <= pos.func_177952_p() + size - 1; ++Z) {
                if (world.func_180495_p(new BlockPos(X + xOff, pos.func_177956_o(), Z + zOff)).func_177230_c() != Blocks.field_150350_a || world.field_72995_K) continue;
                world.func_175656_a(new BlockPos(X + xOff, pos.func_177956_o(), Z + zOff), ModBlocks.seal_hatch.func_176223_P());
                TileEntity te = world.func_175625_s(new BlockPos(X + xOff, pos.func_177956_o(), Z + zOff));
                if (te == null || !(te instanceof TileEntityHatch)) continue;
                ((TileEntityHatch)te).setControllerPos(pos);
            }
        }
    }

    public static void openSeal(World world, BlockPos pos, int size) {
        int xOff = 0;
        int zOff = 0;
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            zOff -= size;
        }
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.NORTH) {
            zOff += size;
        }
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
            xOff -= size;
        }
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
            xOff += size;
        }
        for (int X = pos.func_177958_n() - size + 1; X <= pos.func_177958_n() + size - 1; ++X) {
            for (int Z = pos.func_177952_p() - size + 1; Z <= pos.func_177952_p() + size - 1; ++Z) {
                if (world.func_180495_p(new BlockPos(X + xOff, pos.func_177956_o(), Z + zOff)).func_177230_c() != ModBlocks.seal_hatch || world.field_72995_K) continue;
                world.func_175656_a(new BlockPos(X + xOff, pos.func_177956_o(), Z + zOff), Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    public static boolean isSealClosed(World world, BlockPos pos, int size) {
        int xOff = 0;
        int zOff = 0;
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            zOff -= size;
        }
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.NORTH) {
            zOff += size;
        }
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
            xOff -= size;
        }
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
            xOff += size;
        }
        for (int X = pos.func_177958_n() - size + 1; X <= pos.func_177958_n() + size - 1; ++X) {
            for (int Z = pos.func_177952_p() - size + 1; Z <= pos.func_177952_p() + size - 1; ++Z) {
                if (world.func_180495_p(new BlockPos(X + xOff, pos.func_177956_o(), Z + zOff)).func_177230_c() != ModBlocks.seal_hatch) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void explode(World world, BlockPos pos) {
        int i = BlockSeal.getFrameSize(world, pos);
        if (i != 0) {
            if (BlockSeal.isSealClosed(world, pos, i)) {
                BlockSeal.openSeal(world, pos, i);
            } else {
                BlockSeal.closeSeal(world, pos, i);
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.func_175687_A(pos) > 0) {
            if (!((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ACTIVATED)).booleanValue()) {
                world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(true)), 2);
                int i = BlockSeal.getFrameSize(world, pos);
                if (i != 0) {
                    if (BlockSeal.isSealClosed(world, pos, i)) {
                        BlockSeal.openSeal(world, pos, i);
                    } else {
                        BlockSeal.closeSeal(world, pos, i);
                    }
                }
            }
        } else if (((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ACTIVATED)).booleanValue()) {
            world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVATED});
    }

    public int func_176201_c(IBlockState state) {
        return (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() << 1) + ((Boolean)state.func_177229_b((IProperty)ACTIVATED) == true ? 1 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        boolean activated = (meta & 1) == 1;
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)(meta >>= 1));
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(activated));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }
}

