/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.BlockDummyable;
import com.hbm.handler.RadiationSystemNT;
import com.hbm.interfaces.IDoor;
import com.hbm.interfaces.IRadResistantBlock;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.DoorDecl;
import com.hbm.tileentity.TileEntityDoorGeneric;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDoorGeneric
extends BlockDummyable
implements IRadResistantBlock {
    public DoorDecl type;
    private boolean isRadResistant;

    public BlockDoorGeneric(Material materialIn, DoorDecl type, boolean isRadResistant, String s) {
        super(materialIn, s);
        this.type = type;
        this.isRadResistant = isRadResistant;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (meta >= 12) {
            return new TileEntityDoorGeneric();
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return this.type.getDimensions();
    }

    @Override
    public int getOffset() {
        return 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && !playerIn.func_70093_af()) {
            int[] pos1 = this.findCore((IBlockAccess)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (pos1 == null) {
                return false;
            }
            TileEntityDoorGeneric door = (TileEntityDoorGeneric)world.func_175625_s(new BlockPos(pos1[0], pos1[1], pos1[2]));
            if (door != null) {
                return door.tryToggle(playerIn);
            }
        }
        return !playerIn.func_70093_af();
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        TileEntity te = world.func_175625_s(pos);
        int meta = (Integer)state.func_177229_b((IProperty)META);
        boolean open = this.hasExtra(meta) || te instanceof TileEntityDoorGeneric && ((TileEntityDoorGeneric)te).shouldUseBB;
        return this.type.isLadder(open);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        AxisAlignedBB box = state.func_185890_d((IBlockAccess)worldIn, pos);
        if (box != null && box.field_72338_b == 0.0 && box.field_72337_e == 0.0) {
            return;
        }
        super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity core;
        int[] corePos;
        if (!world.field_72995_K && (corePos = this.findCore((IBlockAccess)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) != null && (core = world.func_175625_s(new BlockPos(corePos[0], corePos[1], corePos[2]))) instanceof TileEntityDoorGeneric) {
            TileEntityDoorGeneric door = (TileEntityDoorGeneric)core;
            door.updateRedstonePower(pos);
        }
        super.func_189540_a(state, world, pos, blockIn, fromPos);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        boolean open;
        int meta = (Integer)state.func_177229_b((IProperty)META);
        TileEntity te = source.func_175625_s(pos);
        int[] core = this.findCore(source, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        boolean bl = open = this.hasExtra(meta) || te instanceof TileEntityDoorGeneric && ((TileEntityDoorGeneric)te).shouldUseBB;
        if (core == null) {
            return field_185505_j;
        }
        TileEntity te2 = source.func_175625_s(new BlockPos(core[0], core[1], core[2]));
        ForgeDirection dir = ForgeDirection.getOrientation(te2.func_145832_p() - 10);
        AxisAlignedBB box = this.type.getBlockBound(pos.func_177982_a(-core[0], -core[1], -core[2]).func_190942_a(dir.getBlockRotation().func_185830_a(Rotation.COUNTERCLOCKWISE_90)), open);
        switch (te2.func_145832_p() - 10) {
            case 2: {
                return new AxisAlignedBB(1.0 - box.field_72340_a, box.field_72338_b, 1.0 - box.field_72339_c, 1.0 - box.field_72336_d, box.field_72337_e, 1.0 - box.field_72334_f);
            }
            case 4: {
                return new AxisAlignedBB(1.0 - box.field_72339_c, box.field_72338_b, box.field_72340_a, 1.0 - box.field_72334_f, box.field_72337_e, box.field_72336_d);
            }
            case 3: {
                return new AxisAlignedBB(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f);
            }
            case 5: {
                return new AxisAlignedBB(box.field_72339_c, box.field_72338_b, 1.0 - box.field_72340_a, box.field_72334_f, box.field_72337_e, 1.0 - box.field_72336_d);
            }
        }
        return field_185505_j;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (this.isRadResistant) {
            RadiationSystemNT.markChunkForRebuild(worldIn, pos);
        }
        super.func_176213_c(worldIn, pos, state);
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (this.isRadResistant) {
            RadiationSystemNT.markChunkForRebuild(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public boolean isRadResistant(World worldIn, BlockPos blockPos) {
        TileEntity entity;
        if (!this.isRadResistant) {
            return false;
        }
        if (worldIn != null && (entity = worldIn.func_175625_s(blockPos)) != null && IDoor.class.isAssignableFrom(entity.getClass())) {
            return ((IDoor)entity).getState() == IDoor.DoorState.CLOSED;
        }
        return true;
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        float hardness = this.func_149638_a(null);
        if (this.isRadResistant) {
            tooltip.add("\u00a72[Radiation Shielding]\u00a7r");
        }
        if (hardness > 50.0f) {
            tooltip.add("\u00a76Blast Resistance: " + hardness + "\u00a7r");
        }
    }
}

