/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.gas;

import com.hbm.blocks.ModBlocks;
import com.hbm.handler.ArmorUtil;
import com.hbm.items.ModItems;
import com.hbm.lib.ForgeDirection;
import com.hbm.main.MainRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockGasBase
extends Block {
    float red;
    float green;
    float blue;

    public BlockGasBase(float r, float g, float b, String s) {
        super(ModBlocks.materialGas);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_149711_c(0.0f);
        this.func_149752_b(0.0f);
        this.func_149675_a(true);
        this.field_149786_r = 0;
        this.red = r;
        this.green = g;
        this.blue = b;
        ModBlocks.ALL_BLOCKS.add(this);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return false;
    }

    public boolean func_149703_v() {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && world.field_73012_v.nextInt(2) == 0 && !this.tryMove(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.getFirstDirection(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()))) {
            this.tryMove(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.getSecondDirection(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        }
    }

    public abstract ForgeDirection getFirstDirection(World var1, int var2, int var3, int var4);

    public ForgeDirection getSecondDirection(World world, int x, int y, int z) {
        return this.getFirstDirection(world, x, y, z);
    }

    public boolean tryMove(World world, int x, int y, int z, ForgeDirection dir) {
        BlockPos newPos = new BlockPos(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        if (!world.func_175667_e(newPos)) {
            return false;
        }
        if (world.func_175623_d(newPos)) {
            world.func_175698_g(new BlockPos(x, y, z));
            world.func_175656_a(newPos, this.func_176223_P());
            return true;
        }
        return false;
    }

    public int getDelay(World world) {
        return 20;
    }

    public ForgeDirection randomHorizontal(World world) {
        return ForgeDirection.getOrientation(world.field_73012_v.nextInt(4) + 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        EntityPlayer p = MainRegistry.proxy.me();
        if (ArmorUtil.checkArmorPiece(p, ModItems.ashglasses, 3)) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "vanillaExt");
            data.func_74778_a("mode", "cloud");
            data.func_74780_a("posX", (double)pos.func_177958_n() + 0.5);
            data.func_74780_a("posY", (double)pos.func_177956_o() + 0.5);
            data.func_74780_a("posZ", (double)pos.func_177952_p() + 0.5);
            data.func_74776_a("r", this.red);
            data.func_74776_a("g", this.green);
            data.func_74776_a("b", this.blue);
            MainRegistry.proxy.effectNT(data);
        }
    }
}

