/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.fluid;

import com.hbm.blocks.ModBlocks;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.ModDamageSource;
import com.hbm.util.ContaminationUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VolcanicBlock
extends BlockFluidClassic {
    public VolcanicBlock(Fluid fluid, Material material, String s) {
        super(fluid, material);
        this.func_149675_a(true);
        this.setQuantaPerBlock(4);
        this.func_149663_c(s);
        this.setRegistryName(s);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighbourPos) {
        super.func_189540_a(state, world, pos, neighborBlock, neighbourPos);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Block b = this.getReaction(world, pos.func_177958_n() + dir.offsetX, pos.func_177956_o() + dir.offsetY, pos.func_177952_p() + dir.offsetZ);
            if (b == null) continue;
            world.func_175656_a(new BlockPos(pos.func_177958_n() + dir.offsetX, pos.func_177956_o() + dir.offsetY, pos.func_177952_p() + dir.offsetZ), b.func_176223_P());
        }
    }

    public Block getReaction(World world, int x, int y, int z) {
        IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
        Block b = state.func_177230_c();
        if (state.func_185904_a() == Material.field_151586_h) {
            return Blocks.field_150348_b;
        }
        if (b instanceof BlockLog) {
            return ModBlocks.waste_log;
        }
        if (b == Blocks.field_150344_f) {
            return ModBlocks.waste_planks;
        }
        if (b instanceof BlockLeaves) {
            return Blocks.field_150480_ab;
        }
        return null;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        entity.func_70110_aj();
        entity.func_70015_d(3);
        entity.func_70097_a(ModDamageSource.radiation, 2.0f);
        if (entity instanceof EntityLivingBase) {
            ContaminationUtil.contaminate((EntityLivingBase)entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 0.05f);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        int lavaCount = 0;
        int basaltCount = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Block b = world.func_180495_p(new BlockPos(pos.func_177958_n() + dir.offsetX, pos.func_177956_o() + dir.offsetY, pos.func_177952_p() + dir.offsetZ)).func_177230_c();
            if (b == this) {
                ++lavaCount;
            }
            if (b != ModBlocks.basalt) continue;
            ++basaltCount;
        }
        if (!world.field_72995_K && (!this.isSourceBlock((IBlockAccess)world, pos) && lavaCount < 2 || rand.nextInt(5) == 0 && lavaCount < 5) && world.func_180495_p(pos.func_177977_b()).func_177230_c() != this) {
            boolean canMakeGem;
            int r = rand.nextInt(200);
            Block above = world.func_180495_p(pos.func_177981_b(10)).func_177230_c();
            boolean bl = canMakeGem = lavaCount + basaltCount == 6 && lavaCount < 3 && (above == ModBlocks.basalt || above == ModBlocks.volcanic_lava_block);
            if (r < 2) {
                world.func_175656_a(pos, ModBlocks.basalt_sulfur.func_176223_P());
            } else if (r == 2) {
                world.func_175656_a(pos, ModBlocks.basalt_asbestos.func_176223_P());
            } else if (r == 3) {
                world.func_175656_a(pos, ModBlocks.basalt_fluorite.func_176223_P());
            } else if (r < 14 && canMakeGem) {
                world.func_175656_a(pos, ModBlocks.basalt_gem.func_176223_P());
            } else {
                world.func_175656_a(pos, ModBlocks.basalt.func_176223_P());
            }
        }
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        Block b = world.func_180495_p(pos).func_177230_c();
        if (b.getFlammability(world, pos, null) > 0) {
            return true;
        }
        if (b.func_176200_f(world, pos)) {
            return true;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        return super.displaceIfPossible(world, pos) || this.canDisplace((IBlockAccess)world, pos);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        double dz;
        double dy;
        double dx;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && !world.func_180495_p(pos.func_177984_a()).func_185914_p()) {
            if (rand.nextInt(100) == 0) {
                dx = (float)x + rand.nextFloat();
                dy = (double)y + (double)this.getBlockLiquidHeight(world, pos, state, this.field_149764_J);
                dz = (float)z + rand.nextFloat();
                world.func_175688_a(EnumParticleTypes.LAVA, dx, dy, dz, 0.0, 0.0, 0.0, new int[0]);
                world.func_184148_a(null, dx, dy, dz, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f);
            }
            if (rand.nextInt(200) == 0) {
                world.func_184148_a(null, (double)x, (double)y, (double)z, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f);
            }
        }
        if (rand.nextInt(10) == 0 && world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && !world.func_180495_p(pos.func_177979_c(2)).func_185904_a().func_76230_c()) {
            dx = (float)x + rand.nextFloat();
            dy = (double)y - 1.05;
            dz = (float)z + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.DRIP_LAVA, dx, dy, dz, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

