/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.BombConfig;
import com.hbm.entity.effect.EntityNukeCloudSmall;
import com.hbm.entity.logic.EntityNukeExplosionMK4;
import com.hbm.interfaces.IBomb;
import com.hbm.lib.InventoryHelper;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.bomb.TileEntityNukeTsar;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class NukeTsar
extends BlockContainer
implements IBomb {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public NukeTsar(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityNukeTsar();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        InventoryHelper.dropInventoryItems(worldIn, pos, (ICapabilityProvider)worldIn.func_175625_s(pos));
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            TileEntityNukeTsar entity = (TileEntityNukeTsar)world.func_175625_s(pos);
            if (entity != null) {
                player.openGui((Object)MainRegistry.instance, 12, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityNukeTsar entity = (TileEntityNukeTsar)worldIn.func_175625_s(pos);
        if (worldIn.func_175687_A(pos) > 0 && !worldIn.field_72995_K) {
            boolean isReady = entity.isReady();
            boolean isStage1Filled = entity.isStage1Filled();
            boolean isStage2Filled = entity.isStage2Filled();
            boolean isStage3Filled = entity.isStage3Filled();
            if (isStage3Filled) {
                this.func_176206_d(worldIn, pos, worldIn.func_180495_p(pos));
                entity.clearSlots();
                worldIn.func_175698_g(pos);
                this.igniteTestBomb(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), BombConfig.tsarRadius);
            } else if (isStage1Filled) {
                this.func_176206_d(worldIn, pos, worldIn.func_180495_p(pos));
                entity.clearSlots();
                worldIn.func_175698_g(pos);
                this.igniteTestBomb(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), BombConfig.tsarRadius / 2);
            } else if (isStage2Filled) {
                this.func_176206_d(worldIn, pos, worldIn.func_180495_p(pos));
                entity.clearSlots();
                worldIn.func_175698_g(pos);
                this.igniteTestBomb(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), BombConfig.tsarRadius / 3);
            } else if (isReady) {
                this.func_176206_d(worldIn, pos, worldIn.func_180495_p(pos));
                entity.clearSlots();
                worldIn.func_175698_g(pos);
                this.igniteTestBomb(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), BombConfig.tsarRadius / 5);
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()));
    }

    public boolean igniteTestBomb(World world, int x, int y, int z, int r) {
        if (!world.field_72995_K) {
            world.func_184148_a(null, (double)x, (double)y, (double)z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            world.func_72838_d((Entity)EntityNukeExplosionMK4.statFac(world, r, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
            EntityNukeCloudSmall entity2 = new EntityNukeCloudSmall(world, r);
            entity2.field_70165_t = x;
            entity2.field_70163_u = y;
            entity2.field_70161_v = z;
            world.func_72838_d((Entity)entity2);
        }
        return false;
    }

    @Override
    public void explode(World world, BlockPos pos) {
        TileEntityNukeTsar entity = (TileEntityNukeTsar)world.func_175625_s(pos);
        boolean isReady = entity.isReady();
        boolean isStage1Filled = entity.isStage1Filled();
        boolean isStage2Filled = entity.isStage2Filled();
        if (isStage2Filled) {
            this.func_176206_d(world, pos, world.func_180495_p(pos));
            entity.clearSlots();
            world.func_175698_g(pos);
            this.igniteTestBomb(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), BombConfig.tsarRadius);
        } else if (isStage1Filled) {
            this.func_176206_d(world, pos, world.func_180495_p(pos));
            entity.clearSlots();
            world.func_175698_g(pos);
            this.igniteTestBomb(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), BombConfig.mikeRadius);
        } else if (isReady) {
            this.func_176206_d(world, pos, world.func_180495_p(pos));
            entity.clearSlots();
            world.func_175698_g(pos);
            this.igniteTestBomb(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), BombConfig.manRadius);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add("\u00a76[Thermonuclear Bomb]\u00a7r");
        tooltip.add(" \u00a7eRadius: " + BombConfig.tsarRadius + "m\u00a7r");
        if (!BombConfig.disableNuclear) {
            tooltip.add("\u00a72[Fallout]\u00a7r");
            tooltip.add(" \u00a7aRadius: " + BombConfig.tsarRadius * (1 + BombConfig.falloutRange / 100) + "m\u00a7r");
        }
    }
}

