/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.BombConfig;
import com.hbm.config.GeneralConfig;
import com.hbm.entity.effect.EntityNukeCloudNoShroom;
import com.hbm.entity.effect.EntityNukeCloudSmall;
import com.hbm.entity.logic.EntityNukeExplosionMK4;
import com.hbm.interfaces.IBomb;
import com.hbm.lib.InventoryHelper;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.bomb.TileEntityNukeMan;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class NukeMan
extends BlockContainer
implements IBomb {
    public static final PropertyInteger FACING = PropertyInteger.func_177719_a((String)"facing", (int)2, (int)5);
    private static boolean keepInventory = false;

    public NukeMan(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_149647_a(MainRegistry.nukeTab);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityNukeMan();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.nuke_man);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        if (!keepInventory && (tileentity = world.func_175625_s(pos)) instanceof TileEntityNukeMan) {
            InventoryHelper.dropInventoryItems(world, pos, (ICapabilityProvider)((TileEntityNukeMan)tileentity));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            TileEntityNukeMan entity = (TileEntityNukeMan)world.func_175625_s(pos);
            if (entity != null) {
                player.openGui((Object)MainRegistry.instance, 6, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityNukeMan entity = (TileEntityNukeMan)world.func_175625_s(pos);
        if (world.func_175687_A(pos) > 0 && !world.field_72995_K && entity.isReady()) {
            this.func_176206_d(world, pos, state);
            entity.clearSlots();
            world.func_175698_g(pos);
            this.igniteTestBomb(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean igniteTestBomb(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            if (world.func_175625_s(new BlockPos(x, y, z)) instanceof TileEntityNukeMan) {
                ((TileEntityNukeMan)world.func_175625_s(new BlockPos(x, y, z))).clearSlots();
            }
            world.func_184148_a(null, (double)x, (double)y, (double)z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            world.func_72838_d((Entity)EntityNukeExplosionMK4.statFac(world, BombConfig.manRadius, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
            if (GeneralConfig.enableNukeClouds) {
                EntityNukeCloudSmall entity2 = new EntityNukeCloudSmall(world, BombConfig.manRadius);
                entity2.field_70165_t = x;
                entity2.field_70163_u = y;
                entity2.field_70161_v = z;
                world.func_72838_d((Entity)entity2);
            } else {
                EntityNukeCloudNoShroom entity2 = new EntityNukeCloudNoShroom(world, BombConfig.manRadius);
                entity2.field_70165_t = x;
                entity2.field_70163_u = y - 17;
                entity2.field_70161_v = z;
                world.func_72838_d((Entity)entity2);
            }
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (i == 0) {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)Integer.valueOf(5)), 2);
        }
        if (i == 1) {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)Integer.valueOf(3)), 2);
        }
        if (i == 2) {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)Integer.valueOf(4)), 2);
        }
        if (i == 3) {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)Integer.valueOf(2)), 2);
        }
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)FACING);
    }

    public IBlockState func_176203_a(int meta) {
        if (meta >= 2 && meta <= 5) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)Integer.valueOf(meta));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)Integer.valueOf(2));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    public void explode(World world, BlockPos pos) {
        if (!(world.func_175625_s(pos) instanceof TileEntityNukeMan)) {
            return;
        }
        TileEntityNukeMan entity = (TileEntityNukeMan)world.func_175625_s(pos);
        if (entity.isReady()) {
            this.func_176206_d(world, pos, world.func_180495_p(pos));
            entity.clearSlots();
            world.func_175698_g(pos);
            this.igniteTestBomb(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add("\u00a72[Nuclear Bomb]\u00a7r");
        tooltip.add(" \u00a7eRadius: " + BombConfig.manRadius + "m\u00a7r");
        if (!BombConfig.disableNuclear) {
            tooltip.add("\u00a72[Fallout]\u00a7r");
            tooltip.add(" \u00a7aRadius: " + BombConfig.manRadius * (1 + BombConfig.falloutRange / 100) + "m\u00a7r");
        }
    }
}

