/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.BombConfig;
import com.hbm.entity.effect.EntityCloudFleija;
import com.hbm.entity.effect.EntityCloudSolinium;
import com.hbm.entity.effect.EntityNukeCloudSmall;
import com.hbm.entity.grenade.EntityGrenadeZOMG;
import com.hbm.entity.logic.EntityBalefire;
import com.hbm.entity.logic.EntityNukeExplosionMK3;
import com.hbm.entity.logic.EntityNukeExplosionMK4;
import com.hbm.entity.projectile.EntityFallingNuke;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.interfaces.IBomb;
import com.hbm.lib.InventoryHelper;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.bomb.TileEntityNukeCustom;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class NukeCustom
extends BlockContainer
implements IBomb {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public NukeCustom(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityNukeCustom();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        InventoryHelper.dropInventoryItems(worldIn, pos, (ICapabilityProvider)worldIn.func_175625_s(pos));
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            TileEntityNukeCustom entity = (TileEntityNukeCustom)world.func_175625_s(pos);
            if (entity != null) {
                player.openGui((Object)MainRegistry.instance, 37, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (world.func_175687_A(pos) > 0 && !world.field_72995_K) {
            this.explode(world, pos);
        }
    }

    public static void explodeCustom(World world, double xCoord, double yCoord, double zCoord, float tnt, float nuke, float hydro, float bale, float dirty, float schrab, float sol, float euph) {
        dirty = Math.min(dirty, (float)BombConfig.maxCustomDirtyRadius);
        if (euph > 0.0f) {
            euph = Math.min(euph, (float)BombConfig.maxCustomEuphLvl);
            EntityGrenadeZOMG zomg = new EntityGrenadeZOMG(world, xCoord, yCoord, zCoord);
            ExplosionChaos.zomg(world, xCoord, yCoord, zCoord, (int)(100.0f * euph), null, zomg);
        } else if (sol > 0.0f) {
            sol += schrab / 2.0f + bale / 4.0f + hydro / 8.0f + nuke / 16.0f + tnt / 32.0f;
            sol = Math.min(sol, (float)BombConfig.maxCustomSolRadius);
            EntityNukeExplosionMK3 entity = new EntityNukeExplosionMK3(world);
            entity.func_70107_b(xCoord + 0.5, yCoord + 0.5, zCoord + 0.5);
            entity.destructionRange = (int)sol;
            entity.speed = BombConfig.blastSpeed;
            entity.coefficient = 1.0f;
            entity.waste = false;
            entity.extType = 1;
            world.func_72838_d((Entity)entity);
            EntityCloudSolinium cloud = new EntityCloudSolinium(world, (int)sol);
            cloud.func_70107_b(xCoord + 0.5, yCoord + 0.5, zCoord + 0.5);
            world.func_72838_d((Entity)cloud);
        } else if (schrab > 0.0f) {
            schrab += bale / 2.0f + hydro / 4.0f + nuke / 8.0f + tnt / 16.0f;
            schrab = Math.min(schrab, (float)BombConfig.maxCustomSchrabRadius);
            EntityNukeExplosionMK3 entity = new EntityNukeExplosionMK3(world);
            entity.func_70107_b(xCoord + 0.5, yCoord + 0.5, zCoord + 0.5);
            entity.destructionRange = (int)schrab;
            entity.speed = BombConfig.blastSpeed;
            entity.coefficient = 1.0f;
            entity.waste = false;
            world.func_72838_d((Entity)entity);
            EntityCloudFleija cloud = new EntityCloudFleija(world, (int)schrab);
            cloud.func_70107_b(xCoord + 0.5, yCoord + 0.5, zCoord + 0.5);
            world.func_72838_d((Entity)cloud);
        } else if (bale > 0.0f) {
            bale += hydro / 2.0f + nuke / 4.0f + tnt / 8.0f;
            bale = Math.min(bale, (float)BombConfig.maxCustomBaleRadius);
            EntityBalefire bf = new EntityBalefire(world);
            bf.func_70107_b(xCoord + 0.5, yCoord + 0.5, zCoord + 0.5);
            bf.destructionRange = (int)bale;
            world.func_72838_d((Entity)bf);
            world.func_72838_d((Entity)EntityNukeCloudSmall.statFacBale(world, xCoord + 0.5, yCoord + 5.0, zCoord + 0.5, bale));
        } else if (hydro > 0.0f) {
            hydro += nuke / 2.0f + tnt / 4.0f;
            hydro = Math.min(hydro, (float)BombConfig.maxCustomHydroRadius);
            world.func_72838_d((Entity)EntityNukeExplosionMK4.statFac(world, (int)hydro, xCoord + 0.5, yCoord + 0.5, zCoord + 0.5).moreFallout((int)(dirty *= 0.25f)));
            world.func_72838_d((Entity)EntityNukeCloudSmall.statFac(world, xCoord + 0.5, yCoord + 5.0, zCoord + 0.5, hydro));
        } else if (nuke > 0.0f) {
            nuke += tnt / 2.0f;
            nuke = Math.min(nuke, (float)BombConfig.maxCustomNukeRadius);
            world.func_72838_d((Entity)EntityNukeExplosionMK4.statFac(world, (int)nuke, xCoord + 0.5, yCoord + 5.0, zCoord + 0.5).moreFallout((int)dirty));
            world.func_72838_d((Entity)EntityNukeCloudSmall.statFac(world, xCoord + 0.5, yCoord + 5.0, zCoord + 0.5, nuke));
        } else if (tnt >= 75.0f) {
            tnt = Math.min(tnt, (float)BombConfig.maxCustomTNTRadius);
            world.func_72838_d((Entity)EntityNukeExplosionMK4.statFacNoRad(world, (int)tnt, xCoord + 0.5, yCoord + 0.5, zCoord + 0.5));
            world.func_72838_d((Entity)EntityNukeCloudSmall.statFac(world, xCoord + 0.5, yCoord + 5.0, zCoord + 0.5, tnt));
        } else if (tnt > 0.0f) {
            ExplosionLarge.explode(world, xCoord + 0.5, yCoord + 0.5, zCoord + 0.5, tnt, true, true, true);
        }
    }

    @Override
    public void explode(World world, BlockPos pos) {
        TileEntityNukeCustom entity = (TileEntityNukeCustom)world.func_175625_s(pos);
        if (!entity.isFalling()) {
            entity.clearSlots();
            world.func_175655_b(pos, false);
            NukeCustom.explodeCustom(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, entity.tnt, entity.nuke, entity.hydro, entity.bale, entity.dirty, entity.schrab, entity.sol, entity.euph);
        } else {
            EntityFallingNuke bomb = new EntityFallingNuke(world, entity.tnt, entity.nuke, entity.hydro, entity.bale, entity.dirty, entity.schrab, entity.sol, entity.euph);
            bomb.func_184212_Q().func_187227_b(EntityFallingNuke.FACING, (Object)world.func_180495_p(pos).func_177229_b((IProperty)FACING));
            bomb.func_70080_a((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            entity.clearSlots();
            world.func_175698_g(pos);
            world.func_72838_d((Entity)bomb);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add("\u00a7d[Modular Bomb]\u00a7r");
    }
}

