/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import com.hbm.blocks.ModBlocks;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.interfaces.IBomb;
import com.hbm.lib.InventoryHelper;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.bomb.TileEntityBombMulti;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class BombMulti
extends BlockContainer
implements IBomb {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final AxisAlignedBB MULTI_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    public final float explosionBaseValue = 8.0f;
    public float explosionValue = 0.0f;
    public int clusterCount = 0;
    public int fireRadius = 0;
    public int poisonRadius = 0;
    public int gasCloud = 0;

    public BombMulti(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBombMulti();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            TileEntityBombMulti entity = (TileEntityBombMulti)world.func_175625_s(pos);
            if (entity != null) {
                player.openGui((Object)MainRegistry.instance, 10, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityBombMulti entity = (TileEntityBombMulti)worldIn.func_175625_s(pos);
        if (worldIn.func_175687_A(pos) > 0 && entity.isLoaded()) {
            this.func_176206_d(worldIn, pos, state);
            this.igniteTestBomb(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        InventoryHelper.dropInventoryItems(worldIn, pos, (ICapabilityProvider)worldIn.func_175625_s(pos));
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()));
    }

    public boolean igniteTestBomb(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntityBombMulti entity = (TileEntityBombMulti)world.func_175625_s(pos);
        if (!world.field_72995_K && entity.isLoaded()) {
            this.explosionValue = this.explosionBaseValue;
            switch (entity.return2type()) {
                case 1: {
                    this.explosionValue += 1.0f;
                    break;
                }
                case 2: {
                    this.explosionValue += 4.0f;
                    break;
                }
                case 3: {
                    this.clusterCount += 50;
                    break;
                }
                case 4: {
                    this.fireRadius += 10;
                    break;
                }
                case 5: {
                    this.poisonRadius += 15;
                    break;
                }
                case 6: {
                    this.gasCloud += 50;
                }
            }
            switch (entity.return5type()) {
                case 1: {
                    this.explosionValue += 1.0f;
                    break;
                }
                case 2: {
                    this.explosionValue += 4.0f;
                    break;
                }
                case 3: {
                    this.clusterCount += 50;
                    break;
                }
                case 4: {
                    this.fireRadius += 10;
                    break;
                }
                case 5: {
                    this.poisonRadius += 15;
                    break;
                }
                case 6: {
                    this.gasCloud += 50;
                }
            }
            entity.clearSlots();
            world.func_175698_g(pos);
            ExplosionLarge.explode(world, x, y, z, this.explosionValue, true, true, true);
            this.explosionValue = 0.0f;
            if (this.clusterCount > 0) {
                ExplosionChaos.cluster(world, x, y, z, this.clusterCount, 1);
            }
            if (this.fireRadius > 0) {
                ExplosionChaos.burn(world, pos, this.fireRadius);
            }
            if (this.poisonRadius > 0) {
                ExplosionNukeGeneric.wasteNoSchrab(world, pos, this.poisonRadius);
            }
            if (this.gasCloud > 0) {
                ExplosionChaos.spawnChlorine(world, x, y, z, this.gasCloud, this.gasCloud / 50, 0);
            }
            this.clusterCount = 0;
            this.fireRadius = 0;
            this.poisonRadius = 0;
            this.gasCloud = 0;
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return MULTI_BB;
    }

    @Override
    public void explode(World world, BlockPos pos) {
        TileEntityBombMulti entity = (TileEntityBombMulti)world.func_175625_s(pos);
        if (entity.isLoaded()) {
            this.func_176206_d(world, pos, world.func_180495_p(pos));
            this.igniteTestBomb(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }
}

