/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.energy;

import api.hbm.energy.IEnergyConductor;
import api.hbm.energy.IEnergyConnector;
import api.hbm.energy.IPowerNet;
import com.hbm.config.GeneralConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.tileentity.TileEntity;

public class PowerNet
implements IPowerNet {
    private boolean valid = true;
    private HashMap<Integer, IEnergyConductor> links = new HashMap();
    private HashMap<Integer, Integer> proxies = new HashMap();
    private List<IEnergyConnector> subscribers = new ArrayList<IEnergyConnector>();
    public long lastCleanup = System.currentTimeMillis();

    @Override
    public void joinNetworks(IPowerNet network) {
        if (network == this) {
            return;
        }
        for (IEnergyConductor conductor : network.getLinks()) {
            this.joinLink(conductor);
        }
        network.getLinks().clear();
        for (IEnergyConnector connector : network.getSubscribers()) {
            this.subscribe(connector);
        }
        network.destroy();
    }

    @Override
    public IPowerNet joinLink(IEnergyConductor conductor) {
        if (conductor.getPowerNet() != null) {
            conductor.getPowerNet().leaveLink(conductor);
        }
        conductor.setPowerNet(this);
        int identity = conductor.getIdentity();
        this.links.put(identity, conductor);
        if (conductor.hasProxies()) {
            for (Integer i : conductor.getProxies()) {
                this.proxies.put(i, identity);
            }
        }
        return this;
    }

    @Override
    public void leaveLink(IEnergyConductor conductor) {
        conductor.setPowerNet(null);
        int identity = conductor.getIdentity();
        this.links.remove(identity);
        if (conductor.hasProxies()) {
            for (Integer i : conductor.getProxies()) {
                this.proxies.remove(i);
            }
        }
    }

    @Override
    public void subscribe(IEnergyConnector connector) {
        this.subscribers.add(connector);
    }

    @Override
    public void unsubscribe(IEnergyConnector connector) {
        this.subscribers.remove(connector);
    }

    @Override
    public boolean isSubscribed(IEnergyConnector connector) {
        return this.subscribers.contains(connector);
    }

    @Override
    public List<IEnergyConductor> getLinks() {
        ArrayList<IEnergyConductor> linkList = new ArrayList<IEnergyConductor>();
        linkList.addAll(this.links.values());
        return linkList;
    }

    public HashMap<Integer, Integer> getProxies() {
        HashMap<Integer, Integer> proxyCopy = new HashMap<Integer, Integer>(this.proxies);
        return proxyCopy;
    }

    @Override
    public List<IEnergyConnector> getSubscribers() {
        return this.subscribers;
    }

    @Override
    public void destroy() {
        this.valid = false;
        this.subscribers.clear();
        for (IEnergyConductor link : this.links.values()) {
            link.setPowerNet(null);
        }
        this.links.clear();
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public long transferPower(long power) {
        return PowerNet.fairTransfer(this.subscribers, power);
    }

    public static void cleanup(List<IEnergyConnector> subscribers) {
        subscribers.removeIf(x -> x == null || !(x instanceof TileEntity) || ((TileEntity)x).func_145837_r() || !x.isLoaded());
    }

    public static long fairTransfer(List<IEnergyConnector> subscribers, long power) {
        IEnergyConnector.ConnectionPriority[] priorities;
        if (subscribers.isEmpty()) {
            return power;
        }
        PowerNet.cleanup(subscribers);
        for (IEnergyConnector.ConnectionPriority p : priorities = new IEnergyConnector.ConnectionPriority[]{IEnergyConnector.ConnectionPriority.HIGH, IEnergyConnector.ConnectionPriority.NORMAL, IEnergyConnector.ConnectionPriority.LOW}) {
            ArrayList subList = new ArrayList();
            subscribers.forEach(x -> {
                if (x.getPriority() == p) {
                    subList.add(x);
                }
            });
            if (subList.isEmpty()) continue;
            ArrayList<Long> weight = new ArrayList<Long>();
            long totalReq = 0L;
            for (IEnergyConnector con : subList) {
                long req = con.getTransferWeight();
                weight.add(req);
                totalReq += req;
            }
            if (totalReq == 0L) continue;
            long totalGiven = 0L;
            for (int i = 0; i < subList.size(); ++i) {
                IEnergyConnector con = (IEnergyConnector)subList.get(i);
                long req = (Long)weight.get(i);
                double fraction = (double)req / (double)totalReq;
                long given = (long)Math.floor(fraction * (double)power);
                totalGiven += given - con.transferPower(given);
            }
            power -= totalGiven;
        }
        return power;
    }

    @Override
    public void reevaluate() {
        if (!GeneralConfig.enableReEval) {
            this.destroy();
            return;
        }
        HashMap<Integer, IEnergyConductor> copy = new HashMap<Integer, IEnergyConductor>(this.links);
        HashMap<Integer, Integer> proxyCopy = new HashMap<Integer, Integer>(this.proxies);
        for (IEnergyConductor link : copy.values()) {
            this.leaveLink(link);
        }
        for (IEnergyConductor link : copy.values()) {
            link.setPowerNet(null);
            link.reevaluate(copy, proxyCopy);
            if (link.getPowerNet() != null) continue;
            link.setPowerNet(new PowerNet().joinLink(link));
        }
    }
}

