/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.energy;

import api.hbm.energy.IEnergyConductor;
import api.hbm.energy.IEnergyConnector;
import com.hbm.lib.ForgeDirection;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IEnergyUser
extends IEnergyConnector {
    public void setPower(long var1);

    @Override
    default public long transferPower(long power) {
        long ownPower;
        long ownMaxPower = this.getMaxPower();
        if (power > ownMaxPower - (ownPower = this.getPower())) {
            long overshoot = power - (ownMaxPower - ownPower);
            this.setPower(ownMaxPower);
            return overshoot;
        }
        this.setPower(ownPower + power);
        return 0L;
    }

    default public void sendPower(World world, BlockPos pos, ForgeDirection dir) {
        IEnergyConnector con;
        TileEntity te = world.func_175625_s(pos);
        boolean wasSubscribed = false;
        boolean red = false;
        if (te instanceof IEnergyConductor && (con = (IEnergyConductor)te).canConnect(dir.getOpposite()) && con.getPowerNet() != null && con.getPowerNet().isSubscribed(this)) {
            con.getPowerNet().unsubscribe(this);
            wasSubscribed = true;
        }
        if (te instanceof IEnergyConnector && (con = (IEnergyConnector)te).canConnect(dir.getOpposite())) {
            long oldPower = this.getPower();
            long transfer = oldPower - con.transferPower(oldPower);
            this.setPower(oldPower - transfer);
            red = true;
        }
        if (wasSubscribed && te instanceof IEnergyConductor && (con = (IEnergyConductor)te).getPowerNet() != null && !con.getPowerNet().isSubscribed(this)) {
            con.getPowerNet().subscribe(this);
        }
    }
}

