/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.energy;

import api.hbm.energy.IEnergyConductor;
import api.hbm.energy.ILoadedTile;
import com.hbm.lib.ForgeDirection;
import com.hbm.render.amlfrom1710.Vec3;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IEnergyConnector
extends ILoadedTile {
    public static final boolean particleDebug = true;

    public long transferPower(long var1);

    default public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN;
    }

    public long getPower();

    public long getMaxPower();

    default public long getTransferWeight() {
        return Math.max(this.getMaxPower() - this.getPower(), 0L);
    }

    default public void trySubscribe(World world, BlockPos pos, ForgeDirection dir) {
        TileEntity te = world.func_175625_s(pos);
        boolean red = false;
        if (te instanceof IEnergyConductor) {
            IEnergyConductor con = (IEnergyConductor)te;
            if (!con.canConnect(dir.getOpposite())) {
                return;
            }
            if (con.getPowerNet() != null && !con.getPowerNet().isSubscribed(this)) {
                con.getPowerNet().subscribe(this);
            }
            if (con.getPowerNet() != null) {
                red = true;
            }
        }
    }

    default public void tryUnsubscribe(World world, BlockPos pos) {
        IEnergyConductor con;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEnergyConductor && (con = (IEnergyConductor)te).getPowerNet() != null && con.getPowerNet().isSubscribed(this)) {
            con.getPowerNet().unsubscribe(this);
        }
    }

    default public Vec3 getDebugParticlePos() {
        BlockPos pos = ((TileEntity)this).func_174877_v();
        Vec3 vec = Vec3.createVectorHelper((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
        return vec;
    }

    default public ConnectionPriority getPriority() {
        return ConnectionPriority.NORMAL;
    }

    default public void updateStandardConnections(World world, TileEntity te) {
        this.updateStandardConnections(world, te.func_174877_v());
    }

    default public void updateStandardConnections(World world, BlockPos pos) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.trySubscribe(world, pos.func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ), dir);
        }
    }

    default public void updateConnectionsExcept(World world, BlockPos pos, ForgeDirection nogo) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (dir == nogo) continue;
            this.trySubscribe(world, pos.func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ), dir);
        }
    }

    public static enum ConnectionPriority {
        LOW,
        NORMAL,
        HIGH;

    }
}

