/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.util.text_components;

import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftblib.lib.util.StringJoiner;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class Notification
extends TextComponentString {
    public static final ResourceLocation VANILLA_STATUS = new ResourceLocation("minecraft", "status");
    private final ResourceLocation id;
    private Ticks timer;
    private boolean important;

    public static Notification of(ResourceLocation id, String text, ITextComponent ... lines) {
        Notification n = new Notification(id, text);
        for (ITextComponent line : lines) {
            n.addLine(line);
        }
        return n;
    }

    public static Notification of(ResourceLocation id, ITextComponent ... lines) {
        return Notification.of(id, "", lines);
    }

    private Notification(ResourceLocation i, String text) {
        super(text);
        this.id = i;
        this.timer = Ticks.SECOND.x(3L);
        this.important = false;
    }

    public Notification(Notification n) {
        this(n.getId(), n.func_150261_e());
        this.func_150255_a(n.func_150256_b().func_150232_l());
        for (ITextComponent line : n.func_150253_a()) {
            this.func_150253_a().add(line.func_150259_f());
        }
        this.setTimer(n.getTimer());
        this.setImportant(n.isImportant());
    }

    public Notification addLine(ITextComponent line) {
        if (!this.func_150253_a().isEmpty()) {
            this.appendText("\n");
        }
        this.appendSibling(line);
        return this;
    }

    public Notification setError() {
        this.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
        this.important = true;
        return this;
    }

    public Notification appendText(String text) {
        return this.appendSibling((ITextComponent)new TextComponentString(text));
    }

    public Notification appendSibling(ITextComponent component) {
        super.func_150257_a(component);
        return this;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Notification && ((Notification)((Object)o)).getId().equals((Object)this.getId());
    }

    public String toString() {
        return "Notification{" + StringJoiner.with(", ").joinObjects("id=" + this.id, "siblings=" + this.field_150264_a, "style=" + this.func_150256_b(), "timer=" + this.timer, "important=" + this.important) + '}';
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Ticks getTimer() {
        return this.timer;
    }

    public Notification setTimer(Ticks t) {
        this.timer = t;
        return this;
    }

    public boolean isImportant() {
        return this.important;
    }

    public Notification setImportant(boolean v) {
        this.important = v;
        return this;
    }

    public Notification createCopy() {
        return new Notification(this);
    }

    public void send(MinecraftServer server, @Nullable EntityPlayer player) {
        ServerUtils.notify(server, player, (ITextComponent)this);
    }

    public void send(MinecraftServer server, @Nullable ICommandSender sender) {
        if (sender == null) {
            ServerUtils.notify(server, null, (ITextComponent)this);
        } else if (sender instanceof EntityPlayer) {
            ServerUtils.notify(server, (EntityPlayer)sender, (ITextComponent)this);
        } else {
            sender.func_145747_a((ITextComponent)this);
        }
    }
}

