/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.client.teamsgui;

import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.PlayerHeadIcon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftblib.net.MessageMyTeamPlayerList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;

public class GuiManagePlayersBase
extends GuiButtonListBase {
    private final List<MessageMyTeamPlayerList.Entry> entries;
    private final BiFunction<Panel, MessageMyTeamPlayerList.Entry, ButtonPlayerBase> buttonFunction;

    public GuiManagePlayersBase(String title, Collection<MessageMyTeamPlayerList.Entry> m, BiFunction<Panel, MessageMyTeamPlayerList.Entry, ButtonPlayerBase> b) {
        this.setTitle(title);
        this.setHasSearchBox(true);
        this.entries = new ArrayList<MessageMyTeamPlayerList.Entry>(m);
        this.buttonFunction = b;
    }

    @Override
    public void addButtons(Panel panel) {
        this.entries.sort(null);
        for (MessageMyTeamPlayerList.Entry m : this.entries) {
            panel.add(this.buttonFunction.apply(panel, m));
        }
    }

    static class ButtonPlayerBase
    extends SimpleTextButton {
        final MessageMyTeamPlayerList.Entry entry;

        ButtonPlayerBase(Panel panel, MessageMyTeamPlayerList.Entry m) {
            super(panel, "", Icon.EMPTY);
            this.entry = m;
            this.updateIcon();
            this.setTitle(this.entry.name);
        }

        Color4I getPlayerColor() {
            return this.getDefaultPlayerColor();
        }

        Color4I getDefaultPlayerColor() {
            return Color4I.GRAY;
        }

        final void updateIcon() {
            this.setIcon(new PlayerHeadIcon(this.entry.uuid).withBorder(this.getPlayerColor(), false).withBorder(Color4I.DARK_GRAY, true).withPadding(2));
        }

        @Override
        public void addMouseOverText(List<String> list) {
        }

        @Override
        public void onClicked(MouseButton button) {
        }
    }
}

