/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render;

import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BaseBakedPerspectiveModel
implements IBakedModel {
    private static final Matrix4f ground;
    private static final Matrix4f gui;
    private static final Matrix4f fixed;
    private static final Matrix4f firstPerson_righthand;
    private static final Matrix4f firstPerson_lefthand;
    private static final Matrix4f thirdPerson_righthand;
    private static final Matrix4f thirdPerson_lefthand;

    private static Matrix4f getMatrix(float transX, float transY, float transZ, float rotX, float rotY, float rotZ, float scaleXYZ) {
        Vector3f translation = new Vector3f(transX, transY, transZ);
        Vector3f scale = new Vector3f(scaleXYZ, scaleXYZ, scaleXYZ);
        Quat4f rotation = TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(rotX, rotY, rotZ));
        TRSRTransformation transform = new TRSRTransformation(translation, rotation, scale, null);
        return transform.getMatrix();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        switch (cameraTransformType) {
            case FIRST_PERSON_LEFT_HAND: {
                return new ImmutablePair((Object)this, (Object)firstPerson_lefthand);
            }
            case FIRST_PERSON_RIGHT_HAND: {
                return new ImmutablePair((Object)this, (Object)firstPerson_righthand);
            }
            case THIRD_PERSON_LEFT_HAND: {
                return new ImmutablePair((Object)this, (Object)thirdPerson_lefthand);
            }
            case THIRD_PERSON_RIGHT_HAND: {
                return new ImmutablePair((Object)this, (Object)thirdPerson_righthand);
            }
            case FIXED: {
                return new ImmutablePair((Object)this, (Object)fixed);
            }
            case GROUND: {
                return new ImmutablePair((Object)this, (Object)ground);
            }
            case GUI: {
                return new ImmutablePair((Object)this, (Object)gui);
            }
        }
        return new ImmutablePair((Object)this, (Object)fixed);
    }

    static {
        gui = BaseBakedPerspectiveModel.getMatrix(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f);
        ground = BaseBakedPerspectiveModel.getMatrix(0.0f, 0.1875f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f);
        fixed = BaseBakedPerspectiveModel.getMatrix(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f);
        thirdPerson_lefthand = thirdPerson_righthand = BaseBakedPerspectiveModel.getMatrix(0.0f, 0.15625f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        firstPerson_righthand = firstPerson_lefthand = BaseBakedPerspectiveModel.getMatrix(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f);
    }
}

