/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client;

import java.util.List;
import mod.chiselsandbits.core.ChiselsAndBits;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.LightUtil;
import org.lwjgl.opengl.GL11;

public class RenderHelper {
    public static void drawSelectionBoundingBoxIfExists(AxisAlignedBB bb, BlockPos blockPos, EntityPlayer player, float partialTicks, boolean NormalBoundingBox) {
        RenderHelper.drawSelectionBoundingBoxIfExistsWithColor(bb, blockPos, player, partialTicks, NormalBoundingBox, 0, 0, 0, 102, 32);
    }

    public static void drawSelectionBoundingBoxIfExistsWithColor(AxisAlignedBB bb, BlockPos blockPos, EntityPlayer player, float partialTicks, boolean NormalBoundingBox, int red, int green, int blue, int alpha, int seeThruAlpha) {
        if (bb != null) {
            double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GL11.glLineWidth((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            if (!NormalBoundingBox) {
                RenderHelper.renderBoundingBox(bb.func_72314_b(0.002, 0.002, 0.002).func_72317_d(-x + (double)blockPos.func_177958_n(), -y + (double)blockPos.func_177956_o(), -z + (double)blockPos.func_177952_p()), red, green, blue, alpha);
            }
            GlStateManager.func_179097_i();
            RenderHelper.renderBoundingBox(bb.func_72314_b(0.002, 0.002, 0.002).func_72317_d(-x + (double)blockPos.func_177958_n(), -y + (double)blockPos.func_177956_o(), -z + (double)blockPos.func_177952_p()), red, green, blue, seeThruAlpha);
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }

    public static void drawLineWithColor(Vec3d a, Vec3d b, BlockPos blockPos, EntityPlayer player, float partialTicks, boolean NormalBoundingBox, int red, int green, int blue, int alpha, int seeThruAlpha) {
        if (a != null && b != null) {
            double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GL11.glLineWidth((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179103_j((int)7424);
            Vec3d a2 = a.func_72441_c(-x + (double)blockPos.func_177958_n(), -y + (double)blockPos.func_177956_o(), -z + (double)blockPos.func_177952_p());
            Vec3d b2 = b.func_72441_c(-x + (double)blockPos.func_177958_n(), -y + (double)blockPos.func_177956_o(), -z + (double)blockPos.func_177952_p());
            if (!NormalBoundingBox) {
                RenderHelper.renderLine(a2, b2, red, green, blue, alpha);
            }
            GlStateManager.func_179097_i();
            RenderHelper.renderLine(a2, b2, red, green, blue, seeThruAlpha);
            GlStateManager.func_179103_j((int)(Minecraft.func_71379_u() ? 7425 : 7424));
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }

    public static void renderQuads(int alpha, BufferBuilder renderer, List<BakedQuad> quads, World worldObj, BlockPos blockPos) {
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int color = bakedquad.func_178211_c() == -1 ? alpha | 0xFFFFFF : RenderHelper.getTint(alpha, bakedquad.func_178211_c(), worldObj, blockPos);
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)color);
        }
    }

    public static void renderBoundingBox(AxisAlignedBB boundingBox, int red, int green, int blue, int alpha) {
        GlStateManager.func_179123_a();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        GlStateManager.func_179103_j((int)7424);
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        double minX = boundingBox.field_72340_a;
        double minY = boundingBox.field_72338_b;
        double minZ = boundingBox.field_72339_c;
        double maxX = boundingBox.field_72336_d;
        double maxY = boundingBox.field_72337_e;
        double maxZ = boundingBox.field_72334_f;
        buffer.func_181662_b(minX, minY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181669_b(red, green, blue, 0).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181669_b(red, green, blue, 0).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181669_b(red, green, blue, 0).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179099_b();
    }

    public static void renderLine(Vec3d a, Vec3d b, int red, int green, int blue, int alpha) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(a.field_72450_a, a.field_72448_b, a.field_72449_c).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(b.field_72450_a, b.field_72448_b, b.field_72449_c).func_181669_b(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
    }

    public static int getTint(int alpha, int tintIndex, World worldObj, BlockPos blockPos) {
        return alpha | Minecraft.func_71410_x().func_184125_al().func_186724_a(ChiselsAndBits.getBlocks().getChiseledDefaultState(), (IBlockAccess)worldObj, blockPos, tintIndex);
    }

    public static void renderModel(IBakedModel model, World worldObj, BlockPos blockPos, int alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            RenderHelper.renderQuads(alpha, buffer, model.func_188616_a(null, enumfacing, 0L), worldObj, blockPos);
        }
        RenderHelper.renderQuads(alpha, buffer, model.func_188616_a(null, null, 0L), worldObj, blockPos);
        tessellator.func_78381_a();
    }

    public static void renderGhostModel(IBakedModel baked, World worldObj, BlockPos blockPos, boolean isUnplaceable) {
        int alpha = isUnplaceable ? 0x22000000 : -1442840576;
        GlStateManager.func_179144_i((int)Minecraft.func_71410_x().func_147117_R().func_110552_b());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderHelper.renderModel(baked, worldObj, blockPos, alpha);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179143_c((int)515);
        RenderHelper.renderModel(baked, worldObj, blockPos, alpha);
        GlStateManager.func_179084_k();
    }
}

