/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bitbag;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import mod.chiselsandbits.bitbag.BagContainer;
import mod.chiselsandbits.bitbag.GuiBagFontRenderer;
import mod.chiselsandbits.bitbag.GuiIconButton;
import mod.chiselsandbits.bitbag.SlotBit;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.network.packets.PacketBagGui;
import mod.chiselsandbits.network.packets.PacketClearBagGui;
import mod.chiselsandbits.network.packets.PacketSortBagGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class BagGui
extends GuiContainer {
    private static final ResourceLocation BAG_GUI_TEXTURE = new ResourceLocation("chiselsandbits", "textures/gui/container/bitbag.png");
    private static int INNER_SLOT_SIZE = 16;
    private static GuiBagFontRenderer specialFontRenderer = null;
    private GuiIconButton trashBtn;
    private GuiIconButton sortBtn;
    boolean requireConfirm = true;
    boolean dontThrow = false;

    public BagGui(EntityPlayer player, World world, int x, int y, int z) {
        super((Container)new BagContainer(player, world, x, y, z));
        this.field_146291_p = false;
        this.field_147000_g = 239;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.trashBtn = new GuiIconButton(1, this.field_147003_i - 18, this.field_147009_r + 0, "help.trash", ClientSide.trashIcon);
        this.field_146292_n.add(this.trashBtn);
        this.sortBtn = new GuiIconButton(1, this.field_147003_i - 18, this.field_147009_r + 18, "help.sort", ClientSide.sortIcon);
        this.field_146292_n.add(this.sortBtn);
    }

    BagContainer getBagContainer() {
        return (BagContainer)this.field_147002_h;
    }

    protected boolean func_146983_a(int keyCode) {
        Slot s;
        if (this.field_147006_u instanceof SlotBit && (s = this.field_147002_h.func_75147_a((IInventory)this.getBagContainer().thePlayer.field_71071_by, 0)) != null) {
            this.field_147006_u = s;
        }
        return super.func_146983_a(keyCode);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int xOffset = (this.field_146294_l - this.field_146999_f) / 2;
        int yOffset = (this.field_146295_m - this.field_147000_g) / 2;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BAG_GUI_TEXTURE);
        this.func_73729_b(xOffset, yOffset, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    private Slot getSlotAtPosition(int x, int y) {
        for (int slotIdx = 0; slotIdx < this.getBagContainer().customSlots.size(); ++slotIdx) {
            Slot slot = this.getBagContainer().customSlots.get(slotIdx);
            if (!this.func_146981_a(slot, x, y)) continue;
            return slot;
        }
        return null;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        boolean duplicateButton = mouseButton == this.field_146297_k.field_71474_y.field_74322_I.func_151463_i() + 100;
        Slot slot = this.getSlotAtPosition(mouseX, mouseY);
        if (slot != null) {
            PacketBagGui bagGuiPacket = new PacketBagGui();
            bagGuiPacket.slotNumber = slot.field_75222_d;
            bagGuiPacket.mouseButton = mouseButton;
            bagGuiPacket.duplicateButton = duplicateButton;
            bagGuiPacket.holdingShift = ClientSide.instance.holdingShift();
            bagGuiPacket.doAction(ClientSide.instance.getPlayer());
            NetworkRouter.instance.sendToServer(bagGuiPacket);
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(ChiselsAndBits.getItems().itemBitBag.func_77653_i(ModUtil.getEmptyStack()), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 93, 0x404040);
        RenderHelper.func_74520_c();
        if (specialFontRenderer == null) {
            specialFontRenderer = new GuiBagFontRenderer(this.field_146289_q, ChiselsAndBits.getConfig().bagStackSize);
        }
        for (int slotIdx = 0; slotIdx < this.getBagContainer().customSlots.size(); ++slotIdx) {
            Slot slot = this.getBagContainer().customSlots.get(slotIdx);
            FontRenderer defaultFontRenderer = this.field_146289_q;
            try {
                this.field_146289_q = specialFontRenderer;
                this.func_146977_a(slot);
            }
            finally {
                this.field_146289_q = defaultFontRenderer;
            }
            if (!this.func_146981_a(slot, mouseX, mouseY) || !slot.func_111238_b()) continue;
            int xDisplayPos = slot.field_75223_e;
            int yDisplayPos = slot.field_75221_f;
            this.field_147006_u = slot;
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.func_73733_a(xDisplayPos, yDisplayPos, xDisplayPos + INNER_SLOT_SIZE, yDisplayPos + INNER_SLOT_SIZE, -2130706433, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        if (this.sortBtn.func_146115_a()) {
            List<String> text = Arrays.asList(LocalStrings.Sort.getLocal());
            this.drawHoveringText(text, mouseX - this.field_147003_i, mouseY - this.field_147009_r, this.field_146289_q);
        }
        if (this.trashBtn.func_146115_a()) {
            if (this.isValidBitItem()) {
                String msgNotConfirm = ModUtil.notEmpty(this.getInHandItem()) ? LocalStrings.TrashItem.getLocal(this.getInHandItem().func_82833_r()) : LocalStrings.Trash.getLocal();
                String msgConfirm = ModUtil.notEmpty(this.getInHandItem()) ? LocalStrings.ReallyTrashItem.getLocal(this.getInHandItem().func_82833_r()) : LocalStrings.ReallyTrash.getLocal();
                List<String> text = Arrays.asList(this.requireConfirm ? msgNotConfirm : msgConfirm);
                this.drawHoveringText(text, mouseX - this.field_147003_i, mouseY - this.field_147009_r, this.field_146289_q);
            } else {
                List<String> text = Arrays.asList(LocalStrings.TrashInvalidItem.getLocal(this.getInHandItem().func_82833_r()));
                this.drawHoveringText(text, mouseX - this.field_147003_i, mouseY - this.field_147009_r, this.field_146289_q);
            }
        } else {
            this.requireConfirm = true;
        }
    }

    private ItemStack getInHandItem() {
        return this.getBagContainer().thePlayer.field_71071_by.func_70445_o();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.sortBtn) {
            NetworkRouter.instance.sendToServer(new PacketSortBagGui());
        }
        if (button == this.trashBtn) {
            if (this.requireConfirm) {
                this.dontThrow = true;
                if (this.isValidBitItem()) {
                    this.requireConfirm = false;
                }
            } else {
                this.requireConfirm = true;
                NetworkRouter.instance.sendToServer(new PacketClearBagGui(this.getInHandItem()));
                this.dontThrow = false;
            }
        }
    }

    private boolean isValidBitItem() {
        return ModUtil.isEmpty(this.getInHandItem()) || this.getInHandItem().func_77973_b() == ChiselsAndBits.getItems().itemBlockBit;
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if ((type == ClickType.PICKUP || type == ClickType.THROW) && this.dontThrow) {
            this.dontThrow = false;
            return;
        }
        super.func_184098_a(slotIn, slotId, mouseButton, type);
    }
}

