/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.integration.vanilla;

import com.google.common.collect.Lists;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import sonar.logistics.api.asm.ASMInfoRegistry;
import sonar.logistics.api.core.tiles.displays.info.register.IInfoRegistry;
import sonar.logistics.api.core.tiles.displays.info.register.IMasterInfoRegistry;
import sonar.logistics.api.core.tiles.displays.info.register.RegistryType;

@ASMInfoRegistry(modid="practicallogistics2")
public class VanillaInfoRegistry
implements IInfoRegistry {
    @Override
    public void registerBaseReturns(IMasterInfoRegistry registry) {
        registry.registerValidReturn(WorldInfo.class);
        registry.registerValidReturn(WorldProvider.class);
        registry.registerValidReturn(DimensionType.class);
        registry.registerValidReturn(Fluid.class);
        registry.registerValidReturn(FoodStats.class);
        registry.registerValidReturn(Team.class);
        registry.registerValidReturn(NBTTagCompound.class);
        registry.registerValidReturn(BlockPos.class);
    }

    @Override
    public void registerBaseMethods(IMasterInfoRegistry registry) {
        registry.registerMethods(Block.class, RegistryType.BLOCK, Lists.newArrayList((Object[])new String[]{"getUnlocalizedName", "getMetaFromState", "getHarvestLevel", "isFoliage", "isWood", "canSustainLeaves"}));
        registry.registerMethods(Block.class, RegistryType.BLOCK, Lists.newArrayList((Object[])new String[]{"getWeakPower", "getStrongPower", "isSideSolid", "getBlockHardness"}));
        registry.registerMethods(BlockFluidBase.class, RegistryType.BLOCK, Lists.newArrayList((Object[])new String[]{"getFluid"}));
        registry.registerMethods(BlockCrops.class, RegistryType.BLOCK, Lists.newArrayList((Object[])new String[]{"isMaxAge"}));
        registry.registerMethods(Fluid.class, RegistryType.BLOCK, Lists.newArrayList((Object[])new String[]{"getLuminosity", "getDensity", "getTemperature", "getViscosity"}));
        registry.registerMethods(BlockPos.class, RegistryType.POS, Lists.newArrayList((Object[])new String[]{"getX", "getY", "getZ"}));
        registry.registerMethods(EnumFacing.class, RegistryType.FACE, Lists.newArrayList((Object[])new String[]{"toString"}));
        registry.registerMethods(World.class, RegistryType.WORLD, Lists.newArrayList((Object[])new String[]{"isBlockIndirectlyGettingPowered", "getWorldInfo"}));
        registry.registerMethods(WorldInfo.class, RegistryType.WORLD, Lists.newArrayList((Object[])new String[]{"isRaining", "isThundering", "getWorldName"}));
        registry.registerMethods(WorldProvider.class, RegistryType.WORLD, Lists.newArrayList((Object[])new String[]{"getDimension", "getDimensionType"}));
        registry.registerMethods(DimensionType.class, RegistryType.WORLD, Lists.newArrayList((Object[])new String[]{"getName"}));
        registry.registerMethods(Entity.class, RegistryType.ENTITY, Lists.newArrayList((Object[])new String[]{"getPosition", "getName"}));
        registry.registerMethods(EntityLivingBase.class, RegistryType.ENTITY, Lists.newArrayList((Object[])new String[]{"getHealth", "getMaxHealth", "getAge", "getTotalArmorValue"}));
        registry.registerMethods(EntityAgeable.class, RegistryType.ENTITY, Lists.newArrayList((Object[])new String[]{"getGrowingAge"}));
        registry.registerMethods(EntityPlayer.class, RegistryType.ENTITY, Lists.newArrayList((Object[])new String[]{"isCreative", "isSpectator", "getFoodStats", "getAbsorptionAmount", "getTeam", "getExperiencePoints"}));
        registry.registerMethods(FoodStats.class, RegistryType.ENTITY, Lists.newArrayList((Object[])new String[]{"getFoodLevel", "needFood", "getSaturationLevel"}));
        registry.registerMethods(Team.class, RegistryType.ENTITY, Lists.newArrayList((Object[])new String[]{"getRegisteredName"}));
        registry.registerMethods(ItemStack.class, RegistryType.ITEMSTACK, Lists.newArrayList((Object[])new String[]{"getItem", "getMaxStackSize", "getTagCompound"}));
    }

    @Override
    public void registerAllFields(IMasterInfoRegistry registry) {
        HashMap<String, Integer> furnaceFields = new HashMap<String, Integer>();
        furnaceFields.put("furnaceBurnTime", 0);
        furnaceFields.put("currentItemBurnTime", 1);
        furnaceFields.put("cookTime", 2);
        furnaceFields.put("totalCookTime", 3);
        registry.registerInvFields(TileEntityFurnace.class, furnaceFields);
        registry.registerFields(TileEntityNote.class, RegistryType.TILE, Lists.newArrayList((Object[])new String[]{"note"}));
        registry.registerFields(ItemStack.class, RegistryType.ITEMSTACK, Lists.newArrayList((Object[])new String[]{"stackSize"}));
    }

    @Override
    public void registerAdjustments(IMasterInfoRegistry registry) {
        registry.registerInfoAdjustments(Lists.newArrayList((Object[])new String[]{"EntityLivingBase.getHealth", "EntityLivingBase.getMaxHealth"}), "", "HP");
        registry.registerInfoAdjustments(Lists.newArrayList((Object[])new String[]{"TileEntityFurnace.furnaceBurnTime", "TileEntityFurnace.currentItemBurnTime", "TileEntityFurnace.cookTime", "TileEntityFurnace.totalCookTime"}), "", "ticks");
    }
}

