/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.nodes.node;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.utils.BlockCoords;
import sonar.core.handlers.inventories.containers.ContainerMultipartSync;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.core.tiles.connections.EnumCableRenderSize;
import sonar.logistics.api.core.tiles.nodes.INode;
import sonar.logistics.base.channels.BlockConnection;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.events.LogisticsEventHandler;
import sonar.logistics.base.events.NetworkChanges;
import sonar.logistics.base.guidance.errors.ErrorMessage;
import sonar.logistics.core.tiles.base.TileSidedLogistics;
import sonar.logistics.core.tiles.nodes.node.GuiNode;

public class TileNode
extends TileSidedLogistics
implements INode,
IByteBufTile,
IFlexibleGui {
    public static final ErrorMessage[] validStates = new ErrorMessage[]{ErrorMessage.NO_NETWORK};
    public SyncTagType.INT priority = new SyncTagType.INT(1);

    public TileNode() {
        this.syncList.addPart((IDirtyPart)this.priority);
    }

    @Override
    public void addConnections(List<NodeConnection> connections) {
        BlockCoords tileCoords = new BlockCoords(this.func_174877_v().func_177972_a(this.getCableFace()), this.func_145831_w().field_73011_w.getDimension());
        connections.add(new BlockConnection(this, tileCoords, this.getCableFace()));
    }

    @Override
    public int getPriority() {
        return (Integer)this.priority.getObject();
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 1: {
                this.priority.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 1: {
                this.priority.readFromBuf(buf);
                LogisticsEventHandler.instance().queueNetworkChange(this.network, NetworkChanges.LOCAL_CHANNELS);
            }
        }
    }

    public boolean hasStandardGui() {
        return true;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new ContainerMultipartSync((TileSonarMultipart)this) : null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new GuiNode(this) : null;
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                SonarMultipartHelper.sendMultipartSyncToPlayer((TileSonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
            }
        }
    }

    @Override
    public EnumCableRenderSize getCableRenderSize(EnumFacing dir) {
        return EnumCableRenderSize.INTERNAL;
    }

    @Override
    public PL2Multiparts getMultipart() {
        return PL2Multiparts.NODE;
    }
}

