/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.tiles.holographic;

import com.google.common.collect.Lists;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.api.utils.BlockInteractionType;
import sonar.logistics.api.core.tiles.displays.tiles.IDisplay;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.base.events.PL2Events;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenLook;
import sonar.logistics.core.tiles.displays.gsi.render.GSIOverlays;
import sonar.logistics.core.tiles.displays.tiles.DisplayVectorHelper;
import sonar.logistics.core.tiles.displays.tiles.holographic.TileAbstractHolographicDisplay;

public class EntityHolographicDisplay
extends Entity {
    public TileAbstractHolographicDisplay display;
    public float rotationRoll;
    public int GSI_IDENTITY;

    public EntityHolographicDisplay(World world) {
        super(world);
    }

    public EntityHolographicDisplay(World world, TileAbstractHolographicDisplay display) {
        this(world);
        this.display = display;
        this.GSI_IDENTITY = display.getInfoContainerID();
        this.setSizingFromDisplay(display);
    }

    public void setSizingFromDisplay(TileAbstractHolographicDisplay display) {
        this.display = display;
        Vec3d screenPosition = display.getScreenOrigin();
        this.func_70107_b(screenPosition.field_72450_a, screenPosition.field_72448_b, screenPosition.field_72449_c);
        this.field_70177_z = (float)display.getYaw();
        this.field_70125_A = (float)display.getPitch();
        this.rotationRoll = (float)display.getRoll();
        this.func_70105_a((float)display.getWidth(), (float)display.getHeight());
        this.createEffectiveBoundingBox();
    }

    public void createEffectiveBoundingBox() {
        double xMin = this.field_70165_t;
        double xMax = this.field_70165_t;
        double yMin = this.field_70163_u;
        double yMax = this.field_70163_u;
        double zMin = this.field_70161_v;
        double zMax = this.field_70161_v;
        Vec3d screenV = this.func_70040_Z();
        Vec3d origin = this.func_174791_d();
        Vec3d[] vectors = DisplayVectorHelper.getScreenVectors(this.getHolographicDisplay(), screenV);
        Vec3d topLeft = DisplayVectorHelper.getTopLeft(origin, vectors[0], vectors[1], this.field_70130_N, this.field_70131_O);
        Vec3d topRight = DisplayVectorHelper.getTopRight(origin, vectors[0], vectors[1], this.field_70130_N, this.field_70131_O);
        Vec3d bottomLeft = DisplayVectorHelper.getBottomLeft(origin, vectors[0], vectors[1], this.field_70130_N, this.field_70131_O);
        Vec3d bottomRight = DisplayVectorHelper.getBottomRight(origin, vectors[0], vectors[1], this.field_70130_N, this.field_70131_O);
        for (Vec3d vec : Lists.newArrayList((Object[])new Vec3d[]{topLeft, topRight, bottomLeft, bottomRight})) {
            xMin = vec.field_72450_a < xMin ? vec.field_72450_a : xMin;
            yMin = vec.field_72448_b < yMin ? vec.field_72448_b : yMin;
            zMin = vec.field_72449_c < zMin ? vec.field_72449_c : zMin;
            xMax = vec.field_72450_a > xMax ? vec.field_72450_a : xMax;
            yMax = vec.field_72448_b > yMax ? vec.field_72448_b : yMax;
            zMax = vec.field_72449_c > zMax ? vec.field_72449_c : zMax;
        }
        this.func_174826_a(new AxisAlignedBB(xMin, yMin, zMin, xMax, yMax, zMax));
    }

    protected void func_70088_a() {
        this.field_70178_ae = true;
        this.func_189654_d(true);
    }

    protected void func_70105_a(float width, float height) {
        super.func_70105_a(width, height);
        if (this.getHolographicDisplay() != null && this.getHolographicDisplay().getGSI() != null) {
            this.getHolographicDisplay().getGSI().updateScaling();
        }
    }

    public void func_174812_G() {
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        return this.doGSIInteraction(player, player.func_70093_af() ? BlockInteractionType.SHIFT_RIGHT : BlockInteractionType.RIGHT, hand) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    public boolean doGSIInteraction(EntityPlayer player, BlockInteractionType type, EnumHand hand) {
        DisplayScreenLook look = GSIOverlays.getCurrentLook(this.GSI_IDENTITY);
        if (look != null) {
            TileAbstractHolographicDisplay display = this.getHolographicDisplay();
            if (display != null && display.getGSI() != null && PL2Events.coolDownClick == 0) {
                if (!display.isValid()) {
                    this.func_70106_y();
                } else {
                    PL2Events.coolDownClick = 3;
                    display.getGSI().onClicked(display, type, this.func_130014_f_(), display.func_174877_v(), display.func_145831_w().func_180495_p(display.func_174877_v()), player, hand, EnumFacing.NORTH, (float)look.lookX, (float)look.lookY, 0.0f);
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70067_L() {
        if (this.field_70170_p.field_72995_K) {
            double[] look = DisplayVectorHelper.getDisplayLook((Entity)FMLClientHandler.instance().getClientPlayerEntity(), this.getHolographicDisplay(), 8.0);
            if (look != null) {
                GSIOverlays.currentLook = new DisplayScreenLook(look, this.GSI_IDENTITY);
                return true;
            }
            if (GSIOverlays.getCurrentLook(this.GSI_IDENTITY) != null) {
                GSIOverlays.currentLook = null;
            }
        }
        return false;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.GSI_IDENTITY = compound.func_74762_e("gsi_identity");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("gsi_identity", this.GSI_IDENTITY);
    }

    public TileAbstractHolographicDisplay getHolographicDisplay() {
        if ((this.display == null || !this.display.isValid()) && this.func_130014_f_().field_72995_K) {
            IDisplay display = ClientInfoHandler.instance().displays_tile.get(this.GSI_IDENTITY);
            if (display instanceof TileAbstractHolographicDisplay) {
                this.display = (TileAbstractHolographicDisplay)display;
                this.setSizingFromDisplay(this.display);
            } else {
                this.func_70106_y();
            }
        }
        return this.display;
    }
}

