/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.tiles.connected;

import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.connections.EnumCableConnection;
import sonar.logistics.api.core.tiles.connections.EnumCableConnectionType;
import sonar.logistics.api.core.tiles.displays.tiles.ILargeDisplay;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;
import sonar.logistics.core.tiles.displays.tiles.connected.ConnectedDisplay;

public class TileLargeDisplayScreen
extends TileAbstractDisplay
implements ILargeDisplay {
    public ConnectedDisplay overrideDisplay = null;
    public SyncTagType.BOOLEAN shouldRender = new SyncTagType.BOOLEAN(3);
    public SyncTagType.INT connected_display_ID = (SyncTagType.INT)new SyncTagType.INT(4).setDefault((Object)-1);

    public TileLargeDisplayScreen() {
        this.syncList.addParts(new IDirtyPart[]{this.shouldRender, this.connected_display_ID});
    }

    @Override
    public int getInfoContainerID() {
        Optional<ConnectedDisplay> display = this.getConnectedDisplay();
        return display.isPresent() ? display.get().getInfoContainerID() : -1;
    }

    @Override
    public DisplayGSI getGSI() {
        Optional<ConnectedDisplay> display = this.getConnectedDisplay();
        return display.isPresent() ? display.get().getGSI() : null;
    }

    @Override
    public void setGSI(DisplayGSI gsi) {
        this.getConnectedDisplay().ifPresent(d -> d.setGSI(gsi));
    }

    @Override
    public EnumCableConnectionType getConnectableType() {
        return EnumCableConnectionType.SCREEN;
    }

    @Override
    public int getRegistryID() {
        return (Integer)this.connected_display_ID.getObject();
    }

    @Override
    public void setRegistryID(int id) {
        if ((Integer)this.connected_display_ID.getObject() != id) {
            this.connected_display_ID.setObject((Object)id);
        }
    }

    @Override
    public Optional<ConnectedDisplay> getConnectedDisplay() {
        if (this.isClient() && this.overrideDisplay != null) {
            return Optional.of(this.overrideDisplay);
        }
        if (this.getRegistryID() != -1) {
            return Optional.ofNullable(PL2.proxy.getInfoManager(this.isClient()).getConnectedDisplays().get(this.getRegistryID()));
        }
        return Optional.empty();
    }

    @Override
    public void setConnectedDisplay(ConnectedDisplay connectedDisplay) {
        this.overrideDisplay = connectedDisplay;
    }

    @Override
    public boolean shouldRender() {
        return (Boolean)this.shouldRender.getObject() != false && this.getRegistryID() != -1 && this.getConnectedDisplay().isPresent();
    }

    @Override
    public void setShouldRender(boolean shouldRender) {
        if (shouldRender != (Boolean)this.shouldRender.getObject()) {
            this.shouldRender.setObject((Object)shouldRender);
        }
    }

    @Override
    public EnumCableConnection canConnect(int registryID, EnumCableConnectionType type, EnumFacing dir, boolean internal) {
        boolean cableConnection;
        boolean cableFace = dir == this.getCableFace() || dir == this.getCableFace().func_176734_d();
        boolean bl = cableConnection = internal && cableFace && type == EnumCableConnectionType.CONNECTABLE;
        if (cableConnection || !cableFace && type == this.getConnectableType()) {
            return EnumCableConnection.NETWORK;
        }
        return EnumCableConnection.NONE;
    }

    @Override
    public void addInfo(List<String> info) {
        super.addInfo(info);
        info.add("Large Display ID: " + this.connected_display_ID);
        info.add("Should Render " + this.shouldRender.getObject());
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound tag, NBTHelper.SyncType type) {
        super.writeData(tag, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL})) {
            this.getGSI().writeData(tag, NBTHelper.SyncType.SAVE);
        }
        return tag;
    }

    @Override
    public void readData(NBTTagCompound tag, NBTHelper.SyncType type) {
        super.readData(tag, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL})) {
            this.getGSI().readData(tag, NBTHelper.SyncType.SAVE);
        }
    }

    @Override
    public boolean isBlocked(EnumFacing dir) {
        return false;
    }
}

