/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.tiles.connected;

import java.util.List;
import sonar.logistics.core.tiles.displays.DisplayHandler;
import sonar.logistics.core.tiles.displays.tiles.connected.ConnectedDisplay;

public enum ConnectedDisplayChange {
    SUB_DISPLAY_CHANGED(DisplayHandler::updateLargeDisplays),
    SUB_NETWORK_CHANGED(DisplayHandler::updateConnectedNetworks),
    WATCHERS_CHANGED(DisplayHandler::updateWatchers);

    public ChangeLogic changeLogic;

    private ConnectedDisplayChange(ChangeLogic changeLogic) {
        this.changeLogic = changeLogic;
    }

    public boolean shouldRunChange(List<ConnectedDisplayChange> changes) {
        if (changes.contains((Object)this)) {
            return true;
        }
        switch (this) {
            case SUB_DISPLAY_CHANGED: {
                break;
            }
            case SUB_NETWORK_CHANGED: {
                break;
            }
            case WATCHERS_CHANGED: {
                break;
            }
        }
        return false;
    }

    public boolean doChange(List<ConnectedDisplayChange> changes, ConnectedDisplay change) {
        return this.changeLogic.doChange(changes, change);
    }

    public static interface ChangeLogic {
        public boolean doChange(List<ConnectedDisplayChange> var1, ConnectedDisplay var2);
    }
}

