/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.fluids;

import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import sonar.core.api.StorageSize;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.core.tiles.displays.info.types.fluids.FluidCount;
import sonar.logistics.core.tiles.displays.info.types.fluids.InfoNetworkFluid;

public class FluidChangeableList
extends AbstractChangeableList<InfoNetworkFluid> {
    public StorageSize sizing = new StorageSize(0L, 0L);

    public static FluidChangeableList newChangeableList() {
        return new FluidChangeableList();
    }

    public FluidCount createMonitoredValue(InfoNetworkFluid obj) {
        return new FluidCount(obj);
    }

    @Override
    public void saveStates() {
        super.saveStates();
        this.sizing = new StorageSize(0L, 0L);
    }

    @Override
    public void add(StoredFluidStack stack) {
        FluidCount found = this.find(stack.fluid);
        if (found == null) {
            this.values.add(this.createMonitoredValue(new InfoNetworkFluid(stack)));
        } else {
            found.combine(stack.stored, stack.capacity);
        }
    }

    @Nullable
    public FluidCount find(FluidStack obj) {
        for (IMonitoredValue value : this.values) {
            FluidCount count = (FluidCount)value;
            if (!count.canCombine(obj)) continue;
            return count;
        }
        return null;
    }

    public long getItemCount(FluidStack stack) {
        for (IMonitoredValue value : this.getList()) {
            if (!(value instanceof FluidCount)) continue;
            FluidCount count = (FluidCount)value;
            if (!count.fluid.getStoredStack().equalStack(stack)) continue;
            return count.fluid.getStored();
        }
        return 0L;
    }
}

