/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types;

import java.util.List;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.api.asm.ASMInfo;
import sonar.logistics.api.core.tiles.displays.info.IComparableInfo;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.INameableInfo;
import sonar.logistics.api.core.tiles.displays.info.comparators.ComparableObject;
import sonar.logistics.core.tiles.displays.info.types.BaseInfo;

@ASMInfo(id="clock", modid="practicallogistics2")
public class ClockInfo
extends BaseInfo<ClockInfo>
implements IInfo<ClockInfo>,
INBTSyncable,
INameableInfo<ClockInfo>,
IComparableInfo<ClockInfo> {
    public static final String id = "clock";
    public int compare;
    public SyncTagType.DOUBLE firstNum = new SyncTagType.DOUBLE(1);
    public SyncTagType.DOUBLE secondNum = new SyncTagType.DOUBLE(2);
    public SyncTagType.STRING clockString = new SyncTagType.STRING(3);

    public ClockInfo() {
        this.syncList.addParts(new IDirtyPart[]{this.firstNum, this.secondNum, this.clockString});
    }

    public ClockInfo(double firstNum, double secondNum, String clockString) {
        this.syncList.addParts(new IDirtyPart[]{this.firstNum, this.secondNum, this.clockString});
        this.firstNum.setObject((Object)firstNum);
        this.secondNum.setObject((Object)secondNum);
        this.clockString.setObject((Object)clockString);
    }

    @Override
    public String getClientIdentifier() {
        return "Time";
    }

    @Override
    public String getClientObject() {
        if (!this.isValid()) {
            return "ERROR";
        }
        return (String)this.clockString.getObject();
    }

    @Override
    public String getClientType() {
        return "time";
    }

    @Override
    public boolean isIdenticalInfo(ClockInfo info) {
        return ((Double)info.firstNum.getObject()).equals(this.firstNum.getObject()) && ((Double)info.secondNum.getObject()).equals(this.secondNum.getObject());
    }

    @Override
    public boolean isMatchingInfo(ClockInfo info) {
        return true;
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof ClockInfo;
    }

    @Override
    public boolean isValid() {
        return this.firstNum.getObject() != null && this.firstNum.getObject() != null && this.clockString.getObject() != null;
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public ClockInfo copy() {
        return new ClockInfo((Double)this.firstNum.getObject(), (Double)this.secondNum.getObject(), (String)this.clockString.getObject());
    }

    @Override
    public List<ComparableObject> getComparableObjects(List<ComparableObject> objects) {
        objects.add(new ComparableObject(this, "isEmitting", ((Double)this.firstNum.getObject()).equals(this.secondNum.getObject())));
        return objects;
    }
}

