/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.gsi.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import sonar.core.helpers.ListHelper;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.asm.ASMDisplayElement;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.core.tiles.displays.gsi.interaction.GSIInteractionHelper;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayElementContainer;
import sonar.logistics.core.tiles.displays.gsi.storage.ElementStorage;
import sonar.logistics.core.tiles.displays.info.elements.AbstractDisplayElement;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IElementStorageHolder;
import sonar.logistics.core.tiles.displays.info.elements.base.IInfoReferenceElement;

@ASMDisplayElement(id="element_list", modid="practicallogistics2")
public class DisplayElementList
extends AbstractDisplayElement
implements IElementStorageHolder,
IInfoReferenceElement {
    public boolean updateScaling = true;
    public boolean uniformScaling = true;
    public double minScale = 1.0;
    public ElementStorage elements = new ElementStorage(this);
    public List<InfoUUID> references = new ArrayList<InfoUUID>();
    public static final String REGISTRY_NAME = "element_list";

    public DisplayElementList() {
    }

    public DisplayElementList(IElementStorageHolder holder) {
        this.setHolder(holder);
    }

    @Override
    public ElementStorage getElements() {
        return this.elements;
    }

    @Override
    public DisplayElementContainer getContainer() {
        return this.holder.getContainer();
    }

    @Override
    public void onElementAdded(IDisplayElement element) {
        element.setHolder(this);
        this.updateScaling = true;
        this.getGSI().onElementAdded(this, element);
    }

    @Override
    public void onElementRemoved(IDisplayElement element) {
        element.setHolder(this);
        this.updateScaling = true;
        this.getGSI().onElementRemoved(this, element);
    }

    @Override
    public void onElementChanged() {
        this.elements.forEach(IDisplayElement::onElementChanged);
        this.updateActualScaling();
    }

    @Override
    public void updateRender() {
        this.elements.forEach(IDisplayElement::updateRender);
        if (this.updateScaling) {
            this.updateActualScaling();
            this.updateScaling = !this.updateScaling;
        }
    }

    @Override
    public void render() {
        DisplayElementHelper.renderElementStorageHolder(this);
    }

    @Override
    public void startElementRender(IDisplayElement e) {
    }

    @Override
    public void endElementRender(IDisplayElement e) {
        GlStateManager.func_179137_b((double)0.0, (double)e.getActualScaling()[1], (double)0.0);
    }

    @Override
    public Tuple<IDisplayElement, double[]> getClickBoxes(double x, double y) {
        double[] align = this.holder.getAlignmentTranslation(this);
        HashMap boxes = new HashMap();
        double heightOffset = 0.0;
        for (IDisplayElement e : this.elements) {
            if (e instanceof IElementStorageHolder) {
                Tuple<IDisplayElement, double[]> clicked = ((IElementStorageHolder)((Object)e)).getClickBoxes(x, y);
                if (clicked != null) {
                    return clicked;
                }
            } else {
                double[] alignArray = this.getAlignmentTranslation(e);
                double startX = align[0] + alignArray[0];
                double startY = align[1] + alignArray[1] + heightOffset;
                double endX = align[0] + alignArray[0] + e.getActualScaling()[0];
                double endY = align[1] + alignArray[1] + e.getActualScaling()[1] + heightOffset;
                double[] eBox = new double[]{startX, startY, endX, endY};
                if (GSIInteractionHelper.checkClick(x, y, eBox)) {
                    double subClickX = x - startX;
                    double subClickY = y - startY;
                    return new Tuple((Object)e, (Object)new double[]{subClickX, subClickY});
                }
            }
            heightOffset += e.getActualScaling()[1];
        }
        return null;
    }

    @Override
    public void updateActualScaling() {
        double[] listScaling = new double[3];
        double minScale = 1.0;
        listScaling[2] = 1.0;
        for (IDisplayElement e : this.elements) {
            e.setMaxScaling(this.createMaxScaling(e));
            double[] scaling = e.getMaxScaling();
            block11: for (int i = 0; i < 3; ++i) {
                double lValue = listScaling[i];
                double eValue = scaling[i];
                switch (i) {
                    case 0: {
                        if (!(lValue < eValue)) continue block11;
                        listScaling[i] = eValue;
                        continue block11;
                    }
                    case 1: {
                        int n = i;
                        listScaling[n] = listScaling[n] + eValue;
                        listScaling[i] = Math.min(listScaling[i], this.getContainer().getContainerMaxScaling()[i]);
                        continue block11;
                    }
                    case 2: {
                        if (!(minScale > eValue)) continue block11;
                        minScale = eValue;
                    }
                }
            }
        }
        this.minScale = minScale;
        if (!this.uniformScaling) {
            this.setActualScaling(listScaling);
        } else {
            double[] uniformScaling = new double[3];
            uniformScaling[2] = 1.0;
            for (IDisplayElement e : this.elements) {
                e.setActualScaling(this.createActualScaling(e));
                double[] scaling = e.getActualScaling();
                block13: for (int i = 0; i < 3; ++i) {
                    double lValue = uniformScaling[i];
                    double eValue = scaling[i];
                    switch (i) {
                        case 0: {
                            if (!(lValue < eValue)) continue block13;
                            uniformScaling[i] = eValue;
                            continue block13;
                        }
                        case 1: {
                            int n = i;
                            uniformScaling[n] = uniformScaling[n] + eValue;
                            uniformScaling[i] = Math.min(uniformScaling[i], this.getContainer().getContainerMaxScaling()[i]);
                            continue block13;
                        }
                        case 2: {
                            if (minScale > eValue) {
                                minScale = eValue;
                            }
                            uniformScaling[i] = Math.min(uniformScaling[i], this.getContainer().getContainerMaxScaling()[i]);
                        }
                    }
                }
            }
            this.setActualScaling(uniformScaling);
        }
    }

    @Override
    public double[] getMaxScaling() {
        double[] maxScale = this.getHolder().getMaxScaling();
        maxScale[2] = 1.0;
        return maxScale;
    }

    @Override
    public double[] createMaxScaling(IDisplayElement element) {
        double fill = element.getPercentageFill() == 0.0 ? this.percentageFill : element.getPercentageFill();
        double maxIndividualHeight = this.getMaxScaling()[1] / (double)this.elements.getElementCount();
        return DisplayElementHelper.getScaling(element.getUnscaledWidthHeight(), new double[]{this.getMaxScaling()[0], maxIndividualHeight, this.getMaxScaling()[2]}, fill);
    }

    @Override
    public double[] createActualScaling(IDisplayElement element) {
        if (this.uniformScaling) {
            double actualElementScale = this.minScale;
            double actualElementWidth = (double)element.getUnscaledWidthHeight()[0] * actualElementScale * this.percentageFill;
            double actualElementHeight = (double)element.getUnscaledWidthHeight()[1] * actualElementScale * this.percentageFill;
            return new double[]{actualElementWidth, actualElementHeight, actualElementScale};
        }
        double maxIndividualHeight = this.holder.getActualScaling()[1] / (double)this.elements.getElementCount();
        return DisplayElementHelper.getScaling(element.getUnscaledWidthHeight(), new double[]{this.getActualScaling()[0], maxIndividualHeight, this.getActualScaling()[2]}, 1.0);
    }

    @Override
    public List<InfoUUID> getInfoReferences() {
        ArrayList<InfoUUID> uuids = new ArrayList<InfoUUID>();
        for (IDisplayElement s : this.elements) {
            if (!(s instanceof IInfoReferenceElement)) continue;
            ListHelper.addWithCheck(uuids, ((IInfoReferenceElement)s).getInfoReferences());
        }
        return uuids;
    }

    @Override
    public String getRepresentiveString() {
        return REGISTRY_NAME;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.elements.readData(nbt, type);
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        this.elements.writeData(nbt, type);
        return nbt;
    }

    @Override
    public int[] createUnscaledWidthHeight() {
        return new int[]{0, 0};
    }

    @Override
    public String getRegisteredName() {
        return REGISTRY_NAME;
    }

    @Override
    public double[] getAlignmentTranslation() {
        return DisplayElementHelper.alignArray(this.holder.getMaxScaling(), this.getActualScaling(), this.width_align, this.height_align);
    }

    @Override
    public double[] getAlignmentTranslation(IDisplayElement e) {
        double[] maxScaling = new double[]{this.getActualScaling()[0], e.getMaxScaling()[1], e.getMaxScaling()[2]};
        return e.getAlignmentTranslation(maxScaling, e.getActualScaling());
    }
}

