/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.statements.comparators.providers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.reflect.FieldUtils;
import sonar.logistics.api.core.tiles.displays.info.comparators.IComparableProvider;
import sonar.logistics.api.core.tiles.displays.info.comparators.LogicIdentifier;

public class ComparableObjectHandlers {

    public static class NBTTagCompoundLogic
    implements IComparableProvider<NBTTagCompound> {
        public List<Integer> accepted = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6});

        @Override
        public void getComparableObjects(String parent, NBTTagCompound tag, Map<LogicIdentifier, Object> objects) {
            Map tagMap;
            try {
                tagMap = (Map)FieldUtils.readField((Object)tag, (String)"tagMap", (boolean)true);
            }
            catch (IllegalAccessException e) {
                tagMap = Maps.newHashMap();
            }
            int tagCount = 0;
            for (Map.Entry entry : tagMap.entrySet()) {
                if (!this.accepted.contains(((NBTBase)entry.getValue()).func_74732_a())) continue;
                if (((NBTBase)entry.getValue()).func_74732_a() == 10) {
                    this.getComparableObjects("tag " + ++tagCount, tag, objects);
                    continue;
                }
                try {
                    objects.put(new LogicIdentifier(parent, (String)entry.getKey()), FieldUtils.readField(entry.getValue(), (String)"data", (boolean)true));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class ItemStackLogic
    implements IComparableProvider<ItemStack> {
        @Override
        public void getComparableObjects(String parent, ItemStack obj, Map<LogicIdentifier, Object> objects) {
            objects.put(new LogicIdentifier(parent, "items"), obj.func_77973_b());
            objects.put(new LogicIdentifier(parent, "stackSize"), obj.func_190916_E());
        }
    }
}

