/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import sonar.core.client.gui.SonarButtons;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.core.utils.IWorldPosition;
import sonar.logistics.base.gui.GuiLogistics;
import sonar.logistics.base.gui.PL2Colours;

public abstract class GuiSelectionList<T>
extends GuiLogistics {
    public boolean enableListRendering = true;
    public int size = 11;
    public int listHeight = 12;
    public int listWidth = 226;
    public int start;
    public int finish;
    private GuiButton rselectButton;
    public List<T> infoList = new ArrayList<T>();

    public GuiSelectionList(Container container, IWorldPosition part) {
        super(container, part);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_146999_f = this.xSize();
        this.field_147000_g = this.ySize();
        this.size = this.listSize();
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.scroller = new SonarScroller(this.field_147003_i + this.listWidth + 9, this.field_147009_r + 29, this.size * this.listHeight + 2, 10);
        if (this.enableListRendering) {
            for (int i = 0; i < this.size; ++i) {
                this.field_146292_n.add(new SelectionButton(this, 10 + i, this.field_147003_i + 7, this.field_147009_r + 29 + i * this.listHeight, this.listWidth, this.listHeight));
            }
        }
    }

    public int xSize() {
        return this.field_146999_f;
    }

    public int ySize() {
        return this.field_147000_g;
    }

    public int listSize() {
        return (int)Math.floor((this.ySize() - 29) / this.listHeight);
    }

    public abstract int getColour(int var1, int var2);

    public List<List<Integer>> getListTypes() {
        ArrayList<Integer> categories = new ArrayList<Integer>();
        ArrayList<Integer> data = new ArrayList<Integer>();
        ArrayList<Integer> paired = new ArrayList<Integer>();
        if (this.infoList != null) {
            for (int i = this.start; i < this.finish; ++i) {
                T info = this.infoList.get(i);
                if (info == null) continue;
                if (this.isCategoryHeader(info)) {
                    categories.add(i - this.start);
                }
                if (this.isSelectedInfo(info)) {
                    data.add(i - this.start);
                }
                if (!this.isPairedInfo(info)) continue;
                paired.add(i - this.start);
            }
        }
        return Lists.newArrayList((Object[])new List[]{categories, data, paired});
    }

    public abstract boolean isPairedInfo(T var1);

    public abstract boolean isSelectedInfo(T var1);

    public abstract boolean isCategoryHeader(T var1);

    public void func_146979_b(int x, int y) {
        if (this.enableListRendering) {
            this.setInfo();
            this.start = (int)((float)this.infoSize() * this.scroller.getCurrentScroll());
            this.finish = Math.min(this.start + this.size, this.infoSize());
            GL11.glPushMatrix();
            GL11.glScaled((double)this.listScale(), (double)this.listScale(), (double)this.listScale());
            for (int i = this.start; i < this.finish; ++i) {
                T info = this.infoList.get(i);
                if (info == null) continue;
                int yPos = (int)(1.0 / this.listScale() * (double)(32 + this.listHeight * i - this.listHeight * this.start));
                this.renderInfo(info, yPos);
            }
            GL11.glPopMatrix();
        }
        super.func_146979_b(x, y);
    }

    public double listScale() {
        return 0.75;
    }

    public abstract void renderInfo(T var1, int var2);

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.enableListRendering) {
            this.scroller.handleMouse(this.needsScrollBars(), this.infoSize());
        }
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        if (this.enableListRendering) {
            this.scroller.drawScreen(x, y, this.needsScrollBars());
        }
    }

    public void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        if (this.enableListRendering && button == 1) {
            for (int l = 0; l < this.field_146292_n.size(); ++l) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
                if (!guibutton.func_146116_c(this.field_146297_k, x, y)) continue;
                GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, guibutton, this.field_146292_n);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                this.rselectButton = event.getButton();
                event.getButton().func_146113_a(this.field_146297_k.func_147118_V());
                this.buttonPressed(event.getButton(), 1);
                if (!((Object)((Object)this)).equals(this.field_146297_k.field_71462_r)) continue;
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.getButton(), this.field_146292_n));
            }
        }
    }

    public void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.enableListRendering && this.rselectButton != null && state == 1) {
            this.rselectButton.func_146118_a(mouseX, mouseY);
            this.rselectButton = null;
        }
    }

    public void buttonPressed(GuiButton button, int buttonID) {
        T info;
        int start;
        int network;
        if (this.enableListRendering && button != null && button.field_146127_k >= 10 && (network = (start = (int)((float)this.infoSize() * this.scroller.getCurrentScroll())) + button.field_146127_k - 10) < this.infoSize() && (info = this.infoList.get(network)) != null) {
            this.selectionPressed(button, network, buttonID, info);
        }
    }

    public abstract void selectionPressed(GuiButton var1, int var2, int var3, T var4);

    public void func_146284_a(GuiButton button) {
        if (this.enableListRendering) {
            this.buttonPressed(button, 0);
        }
    }

    @Override
    public void func_146976_a(float var1, int var2, int var3) {
        super.func_146976_a(var1, var2, var3);
        if (this.enableListRendering) {
            int left = this.field_147003_i + 7;
            List<List<Integer>> data = this.getListTypes();
            for (int i = 0; i < this.size; ++i) {
                int top = this.field_147009_r + 29 + this.listHeight * i;
                if (!data.get(2).contains(i)) {
                    this.drawInfoBackground(data, this.listWidth, this.listHeight, left, top, i);
                    continue;
                }
                this.drawSelectedInfoBackground(this.listWidth, this.listHeight, left, top, i);
            }
        }
    }

    public void drawInfoBackground(List<List<Integer>> data, int width, int height, int left, int top, int i) {
        int mainColour = data.get(0).contains(i) ? PL2Colours.category.getRGB() : (data.get(1).contains(i) ? this.getColour(i, 0) : PL2Colours.layers[1].getRGB());
        GuiSelectionList.drawTransparentRect((int)(left + 1), (int)(top + 1), (int)(left - 1 + width), (int)(top - 1 + height), (int)mainColour);
        GuiSelectionList.drawTransparentRect((int)left, (int)top, (int)(left + width), (int)(top + height), (int)PL2Colours.layers[2].getRGB());
    }

    public void drawSelectedInfoBackground(int width, int height, int left, int top, int i) {
        int rgb = this.getColour(i, 1);
        GuiSelectionList.drawTransparentRect((int)left, (int)top, (int)(left + width), (int)(top + height), (int)PL2Colours.layers[2].getRGB());
        GuiSelectionList.drawTransparentRect((int)(left + 1), (int)(top + 1), (int)(left - 1 + width), (int)(top - 1 + height), (int)PL2Colours.grey_base.getRGB());
        this.func_73730_a(left + 1, left - 2 + width, top + 1, rgb);
        this.func_73730_a(left + 1, left - 2 + width, top + this.listHeight - 1, rgb);
        this.func_73728_b(left + 1, top + 1, top + this.listHeight - 1, rgb);
        this.func_73728_b(left - 2 + width, top + 1, top + this.listHeight - 1, rgb);
    }

    public boolean needsScrollBars() {
        return this.infoSize() > this.size;
    }

    public void onSelectionHovered(T info, int x, int y) {
    }

    public void onButtonHovered(SelectionButton button, int x, int y) {
        T info;
        int start;
        int network;
        if (button != null && button.field_146127_k >= 10 && (network = (start = (int)((float)this.infoSize() * this.scroller.getCurrentScroll())) + button.field_146127_k - 10) < this.infoSize() && (info = this.infoList.get(network)) != null) {
            this.onSelectionHovered(info, x, y);
        }
    }

    public int infoSize() {
        return this.infoList == null ? 0 : this.infoList.size();
    }

    public abstract void setInfo();

    @Override
    public ResourceLocation getBackground() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static class SelectionButton
    extends SonarButtons.ImageButton {
        GuiSelectionList list;

        public SelectionButton(GuiSelectionList list, int id, int x, int y, int listWidth, int listHeight) {
            super(id, x, y, null, 0, 224, 225, listHeight - 1);
            this.list = list;
        }

        public void func_191745_a(Minecraft mc, int x, int y, float partialTicks) {
            boolean bl = this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
            if (this.field_146123_n) {
                this.list.onButtonHovered(this, x, y);
            }
        }
    }
}

