/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.core.tiles.displays.info;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.base.tiles.INetworkTile;

@Nonnull
public class InfoUUID
implements INBTSyncable {
    public int identity;
    public int channelID;

    public InfoUUID() {
    }

    public InfoUUID(INetworkTile tile, int channelID) {
        this.identity = tile.getIdentity();
        this.channelID = channelID;
    }

    public InfoUUID(int identity, int channelID) {
        this.identity = identity;
        this.channelID = channelID;
    }

    public static InfoUUID newEmpty() {
        return new InfoUUID(-1, -1);
    }

    public static InfoUUID newInvalid() {
        return new InfoUUID(-2, -2);
    }

    public int getIdentity() {
        return this.identity;
    }

    public int getChannelID() {
        return this.channelID;
    }

    public boolean equals(Object obj) {
        if (obj instanceof InfoUUID) {
            return this.identity == ((InfoUUID)obj).identity && this.channelID == ((InfoUUID)obj).channelID;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.identity, this.channelID});
    }

    public static boolean valid(InfoUUID uuid) {
        return uuid != null && uuid.identity >= 0 && uuid.channelID >= 0;
    }

    public static boolean shouldRender(InfoUUID uuid) {
        return uuid.identity != -2;
    }

    public static InfoUUID getUUID(ByteBuf buf) {
        return new InfoUUID(buf.readInt(), buf.readInt());
    }

    public void writeToBuf(ByteBuf buf) {
        buf.writeInt(this.identity);
        buf.writeInt(this.channelID);
    }

    public String toString() {
        return this.identity + ":" + this.channelID;
    }

    public static InfoUUID fromString(String string) {
        String[] ids = string.split(":");
        return new InfoUUID(Integer.valueOf(ids[0]), (int)Integer.valueOf(ids[1]));
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.identity = nbt.func_74762_e("hash");
        this.channelID = nbt.func_74762_e("pos");
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt.func_74768_a("hash", this.identity);
        nbt.func_74768_a("pos", this.channelID);
        return nbt;
    }

    public static List<InfoUUID> readInfoList(NBTTagCompound nbt, String tagName) {
        ArrayList<InfoUUID> newUUIDs = new ArrayList<InfoUUID>();
        NBTTagList tagList = nbt.func_150295_c(tagName, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            InfoUUID loaded = new InfoUUID();
            loaded.readData(tagList.func_150305_b(i), NBTHelper.SyncType.SAVE);
            newUUIDs.add(loaded);
        }
        return newUUIDs;
    }

    public static NBTTagCompound writeInfoList(NBTTagCompound nbt, List<InfoUUID> uuids, String tagName) {
        NBTTagList tagList = new NBTTagList();
        uuids.forEach(obj -> tagList.func_74742_a((NBTBase)obj.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE)));
        nbt.func_74782_a(tagName, (NBTBase)tagList);
        return nbt;
    }
}

