/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.network;

import epicsquid.mysticalworld.capability.PlayerShoulderCapability;
import epicsquid.mysticalworld.capability.PlayerShoulderCapabilityProvider;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessagePlayerShoulderUpdate
implements IMessage {
    private NBTTagCompound tag = new NBTTagCompound();
    private UUID id;

    public MessagePlayerShoulderUpdate() {
    }

    public MessagePlayerShoulderUpdate(EntityPlayer player, PlayerShoulderCapability cap) {
        this.tag = cap.writeNBT();
        this.id = player.func_110124_au();
    }

    public void fromBytes(ByteBuf buf) {
        long uuid1 = buf.readLong();
        long uuid2 = buf.readLong();
        this.id = new UUID(uuid1, uuid2);
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    public static class MessageHolder
    implements IMessageHandler<MessagePlayerShoulderUpdate, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessagePlayerShoulderUpdate message, MessageContext ctx) {
            EntityPlayerSP player;
            if (message != null && (player = Minecraft.func_71410_x().field_71439_g) != null) {
                EntityPlayerSP target;
                if (player.func_110124_au().equals(message.id)) {
                    target = player;
                } else {
                    EntityPlayer otherPlayer = player.field_70170_p.func_152378_a(message.id);
                    if (otherPlayer != null) {
                        target = otherPlayer;
                    } else {
                        return null;
                    }
                }
                PlayerShoulderCapability cap = (PlayerShoulderCapability)target.getCapability(PlayerShoulderCapabilityProvider.PLAYER_SHOULDER_CAPABILITY, null);
                if (cap != null) {
                    cap.readNBT((NBTBase)message.tag);
                }
            }
            return null;
        }
    }
}

