/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui;

import java.io.IOException;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.WarpMode;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.client.gui.GuiButtonRemoveWaystone;
import net.blay09.mods.waystones.client.gui.GuiButtonSortWaystone;
import net.blay09.mods.waystones.client.gui.GuiButtonWaystoneEntry;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.MessageRemoveWaystone;
import net.blay09.mods.waystones.network.message.MessageSortWaystone;
import net.blay09.mods.waystones.network.message.MessageTeleportToWaystone;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.GL11;

public class GuiWaystoneList
extends GuiScreen {
    private final WarpMode warpMode;
    private final EnumHand hand;
    private final WaystoneEntry fromWaystone;
    private WaystoneEntry[] entries;
    private GuiButton btnPrevPage;
    private GuiButton btnNextPage;
    private int pageOffset;
    private int headerY;
    private boolean isLocationHeaderHovered;
    private int buttonsPerPage;

    public GuiWaystoneList(WaystoneEntry[] entries, WarpMode warpMode, EnumHand hand, @Nullable WaystoneEntry fromWaystone) {
        this.entries = entries;
        this.warpMode = warpMode;
        this.hand = hand;
        this.fromWaystone = fromWaystone;
    }

    public void func_73866_w_() {
        this.btnPrevPage = new GuiButton(0, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 40, 95, 20, I18n.func_135052_a((String)"gui.waystones:warpStone.previousPage", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnPrevPage);
        this.btnNextPage = new GuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m / 2 + 40, 95, 20, I18n.func_135052_a((String)"gui.waystones:warpStone.nextPage", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnNextPage);
        this.updateList();
    }

    public void updateList() {
        int maxContentHeight = (int)((float)this.field_146295_m * 0.8f);
        int headerHeight = 40;
        int footerHeight = 25;
        int entryHeight = 25;
        int maxButtonsPerPage = (maxContentHeight - 40 - 25) / 25;
        this.buttonsPerPage = Math.max(4, Math.min(maxButtonsPerPage, this.entries.length));
        int contentHeight = 40 + this.buttonsPerPage * 25 + 25;
        this.headerY = this.field_146295_m / 2 - contentHeight / 2;
        this.btnPrevPage.field_146124_l = this.pageOffset > 0;
        this.btnNextPage.field_146124_l = this.pageOffset < (this.entries.length - 1) / this.buttonsPerPage;
        this.field_146292_n.removeIf(button -> button instanceof GuiButtonWaystoneEntry || button instanceof GuiButtonSortWaystone || button instanceof GuiButtonRemoveWaystone);
        int id = 2;
        int y = 40;
        for (int i = 0; i < this.buttonsPerPage; ++i) {
            int entryIndex = this.pageOffset * this.buttonsPerPage + i;
            if (entryIndex < 0 || entryIndex >= this.entries.length) continue;
            GuiButtonWaystoneEntry btnWaystone = new GuiButtonWaystoneEntry(id, this.field_146294_l / 2 - 100, this.headerY + y, this.entries[entryIndex], this.warpMode);
            if (this.entries[entryIndex].equals(this.fromWaystone)) {
                btnWaystone.field_146124_l = false;
            }
            this.field_146292_n.add(btnWaystone);
            GuiButtonSortWaystone sortUp = new GuiButtonSortWaystone(++id, this.field_146294_l / 2 + 108, this.headerY + y + 2, btnWaystone, -1);
            if (entryIndex == 0) {
                sortUp.field_146125_m = false;
            }
            this.field_146292_n.add(sortUp);
            GuiButtonSortWaystone sortDown = new GuiButtonSortWaystone(++id, this.field_146294_l / 2 + 108, this.headerY + y + 11, btnWaystone, 1);
            if (entryIndex == this.entries.length - 1) {
                sortDown.field_146125_m = false;
            }
            this.field_146292_n.add(sortDown);
            GuiButtonRemoveWaystone remove = new GuiButtonRemoveWaystone(++id, this.field_146294_l / 2 + 122, this.headerY + y + 4, btnWaystone);
            this.field_146292_n.add(remove);
            ++id;
            y += 22;
        }
        this.btnPrevPage.field_146129_i = this.headerY + 40 + this.buttonsPerPage * 22 + (this.entries.length > 0 ? 10 : 0);
        this.btnNextPage.field_146129_i = this.headerY + 40 + this.buttonsPerPage * 22 + (this.entries.length > 0 ? 10 : 0);
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.btnNextPage) {
            this.pageOffset = GuiScreen.func_146272_n() ? (this.entries.length - 1) / this.buttonsPerPage : this.pageOffset + 1;
            this.updateList();
        } else if (button == this.btnPrevPage) {
            this.pageOffset = GuiScreen.func_146272_n() ? 0 : this.pageOffset - 1;
            this.updateList();
        } else if (button instanceof GuiButtonWaystoneEntry) {
            NetworkHandler.channel.sendToServer((IMessage)new MessageTeleportToWaystone(((GuiButtonWaystoneEntry)button).getWaystone(), this.warpMode, this.hand, this.fromWaystone));
            this.field_146297_k.func_147108_a(null);
        } else if (button instanceof GuiButtonSortWaystone) {
            WaystoneEntry waystoneEntry = ((GuiButtonSortWaystone)button).getWaystone();
            int index = ArrayUtils.indexOf((Object[])this.entries, (Object)waystoneEntry);
            int sortDir = ((GuiButtonSortWaystone)button).getSortDir();
            int otherIndex = index + sortDir;
            if (GuiScreen.func_146272_n()) {
                int n = otherIndex = sortDir == -1 ? 0 : this.entries.length - 1;
            }
            if (index == -1 || otherIndex < 0 || otherIndex >= this.entries.length) {
                return;
            }
            WaystoneEntry swap = this.entries[index];
            this.entries[index] = this.entries[otherIndex];
            this.entries[otherIndex] = swap;
            NetworkHandler.channel.sendToServer((IMessage)new MessageSortWaystone(index, otherIndex));
            this.updateList();
        } else if (button instanceof GuiButtonRemoveWaystone) {
            WaystoneEntry waystoneEntry = ((GuiButtonRemoveWaystone)button).getWaystone();
            int index = ArrayUtils.indexOf((Object[])this.entries, (Object)waystoneEntry);
            this.entries = (WaystoneEntry[])ArrayUtils.remove((Object[])this.entries, (int)index);
            NetworkHandler.channel.sendToServer((IMessage)new MessageRemoveWaystone(index));
            this.updateList();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.isLocationHeaderHovered && this.fromWaystone != null) {
            Waystones.proxy.openWaystoneSettings((EntityPlayer)this.field_146297_k.field_71439_g, this.fromWaystone, true);
            this.mouseHandled = true;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146270_b(0);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.waystones:warpStone.selectDestination", (Object[])new Object[0]), this.field_146294_l / 2, this.headerY + (this.fromWaystone != null ? 20 : 0), 0xFFFFFF);
        if (this.fromWaystone != null) {
            this.drawLocationHeader(this.fromWaystone.getName(), mouseX, mouseY, this.field_146294_l / 2, this.headerY);
        }
        if (this.entries.length == 0) {
            this.func_73732_a(this.field_146289_q, TextFormatting.RED + I18n.func_135052_a((String)"waystones:scrollNotBound", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 20, 0xFFFFFF);
        }
    }

    public void drawLocationHeader(String locationName, int mouseX, int mouseY, int x, int y) {
        int locationWidth;
        String locationPrefix = TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.waystones:current_location", (Object[])new Object[0]) + " ";
        int locationPrefixWidth = this.field_146289_q.func_78256_a(locationPrefix);
        int fullWidth = locationPrefixWidth + (locationWidth = this.field_146289_q.func_78256_a(locationName));
        int startX = x - fullWidth / 2 + locationPrefixWidth;
        this.isLocationHeaderHovered = mouseX >= startX && mouseX < startX + locationWidth + 16 && mouseY >= y && mouseY < y + this.field_146289_q.field_78288_b;
        String fullText = locationPrefix + TextFormatting.WHITE;
        if (this.isLocationHeaderHovered) {
            fullText = fullText + TextFormatting.UNDERLINE;
        }
        fullText = fullText + locationName;
        this.func_73731_b(this.field_146289_q, TextFormatting.UNDERLINE + fullText, x - fullWidth / 2, y, 0xFFFFFF);
        if (this.isLocationHeaderHovered) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(x + fullWidth / 2 + 4), (float)y, (float)0.0f);
            float scale = 0.5f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            this.field_146296_j.func_180450_b(new ItemStack(Items.field_151099_bA), 0, 0);
            GlStateManager.func_179121_F();
        }
    }
}

