/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui.swing;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.ProcessHandlerClient;
import com.brandon3055.brandonscore.handlers.FileHandler;
import com.brandon3055.brandonscore.integration.ModHelperBC;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.projectintelligence.client.DisplayController;
import com.brandon3055.projectintelligence.client.PIGuiHelper;
import com.brandon3055.projectintelligence.client.gui.ContentInfo;
import com.brandon3055.projectintelligence.client.gui.GuiContentSelect;
import com.brandon3055.projectintelligence.client.gui.GuiProjectIntelligence;
import com.brandon3055.projectintelligence.client.gui.PIConfig;
import com.brandon3055.projectintelligence.client.gui.swing.MDReference;
import com.brandon3055.projectintelligence.client.gui.swing.MDTagDialog;
import com.brandon3055.projectintelligence.client.gui.swing.TextLineNumber;
import com.brandon3055.projectintelligence.client.gui.swing.UINewDoc;
import com.brandon3055.projectintelligence.docmanagement.ContentRelation;
import com.brandon3055.projectintelligence.docmanagement.DocumentationManager;
import com.brandon3055.projectintelligence.docmanagement.DocumentationPage;
import com.brandon3055.projectintelligence.docmanagement.LanguageManager;
import com.brandon3055.projectintelligence.docmanagement.ModStructurePage;
import com.brandon3055.projectintelligence.docmanagement.RootPage;
import com.brandon3055.projectintelligence.utils.LogHelper;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class PIEditor
extends JFrame {
    private static String os = System.getProperty("os.name");
    private static Pattern versionValidator = Pattern.compile("^[\\d\\.]+$");
    private String selectedPageURI = "";
    private DefaultTreeModel treeModel;
    private DefaultListModel<ContentInfo> iconListModel = new DefaultListModel();
    private DefaultListModel<ContentRelation> relationListModel = new DefaultListModel();
    private DefaultListModel<String> aliasListModel = new DefaultListModel();
    private boolean reloading = false;
    private UndoManager undo = new UndoManager();
    private static Map<String, Integer> caretPositions = new HashMap<String, Integer>();
    private boolean ignoreWeightChange = false;
    private JList<String> aliasList;
    private JCheckBoxMenuItem alwaysOnTop;
    private JMenuItem changeLangButton;
    private JCheckBox copyDocFromSelected;
    private JButton createFromExistingModButton;
    private JCheckBox cycleIcons;
    private JSpinner enRevField;
    private JList<ContentInfo> iconList;
    private JLabel iconsLabel;
    private JTextField idField;
    private JLabel idLabel;
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton12;
    private JButton jButton13;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton7;
    private JButton jButton8;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JPanel jPanel3;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;
    private JTextArea markdownWindow;
    private JComboBox<String> matchLangBox;
    private JPopupMenu mdContextMenu;
    private JScrollPane mdScrollPane;
    private JTextField modIdField;
    private JTextField modNameField;
    private JPanel modPanel;
    private JComboBox<String> modVersionSelect;
    private JTextField nameField;
    private JLabel nameLabel;
    private JLabel nameLabel1;
    private JLabel nameLabel2;
    private JLabel nameLabel3;
    private JButton newModButton;
    private JButton newPageButton;
    private JPanel pagePanel;
    private JTree pageTree;
    private JList<ContentRelation> relationList;
    private JLabel relationsLabel;
    private JLabel relationsLabel1;
    private JSpinner revisionField;
    private JLabel revisionLabel;
    private JTabbedPane tabbedPain;
    private JLabel targetEnRev;
    private JLabel targetEnRev1;
    private JCheckBox toggleHidden;
    private JPopupMenu treeContextMenu;
    private JButton updateEnRev;
    private JSpinner weightField;
    private JLabel weightLabel;
    private JButton jButton6;

    public PIEditor() {
        URL icon = PIEditor.class.getResource("/assets/projectintelligence/textures/editor_icon.png");
        if (icon != null) {
            this.setIconImage(Toolkit.getDefaultToolkit().createImage(icon));
        }
        this.initComponents();
        this.generateLineNumbers();
        this.pack();
        this.markdownWindow.getDocument().addUndoableEditListener(e -> this.undo.addEdit(e.getEdit()));
        this.markdownWindow.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 90) {
                    if (e.isControlDown() && e.isShiftDown()) {
                        PIEditor.this.redo();
                    } else if (e.isControlDown()) {
                        PIEditor.this.undo();
                    }
                }
            }
        });
        this.markdownWindow.setTabSize(2);
        LanguageManager.ALL_LANGUAGES.forEach(this.matchLangBox::addItem);
        this.matchLangBox.addItem("disabled");
        this.matchLangBox.setSelectedItem("disabled");
        this.iconList.setModel(this.iconListModel);
        this.relationList.setModel(this.relationListModel);
        this.aliasList.setModel(this.aliasListModel);
        DefaultTreeSelectionModel selectModel = new DefaultTreeSelectionModel();
        selectModel.setSelectionMode(1);
        this.pageTree.setSelectionModel(selectModel);
        this.markdownWindow.setWrapStyleWord(true);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Editor Line Wrap");
        item.setSelected(PIConfig.editorLineWrap);
        item.addActionListener(e -> {
            PIConfig.editorLineWrap = item.isSelected();
            this.markdownWindow.setLineWrap(PIConfig.editorLineWrap);
            PIConfig.save();
        });
        this.jMenu3.add(item);
        this.loadLAFOps();
        this.reload();
    }

    private void loadLAFOps() {
        this.loadLAF(PIConfig.editorLAF, false);
        JMenu lafs = new JMenu("Editor Style");
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            JMenuItem item = new JMenuItem(info.getName());
            item.addActionListener(e -> this.loadLAF(info.getClassName(), true));
            lafs.add(item);
        }
        try {
            Class.forName("com.bulenkov.darcula.DarculaLaf");
            JMenuItem item = new JMenuItem("Darcula");
            item.addActionListener(e -> this.loadLAF("com.bulenkov.darcula.DarculaLaf", true));
            lafs.add(item);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.jMenu3.add(lafs);
    }

    private void loadLAF(String lafClass, boolean save) {
        try {
            if (lafClass.isEmpty()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                return;
            }
            UIManager.setLookAndFeel(lafClass);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Throwable e) {
            LogHelper.error("Failed to load look and feel: " + lafClass);
            e.printStackTrace();
            return;
        }
        if (save) {
            PIConfig.editorLAF = lafClass;
            ProcessHandlerClient.syncTask(PIConfig::save);
        }
    }

    private void undo() {
        try {
            if (this.undo.canUndo()) {
                this.undo.undo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    private void redo() {
        try {
            if (this.undo.canRedo()) {
                this.undo.redo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    @Override
    public void toBack() {
        if (os.equals("Linux")) {
            return;
        }
        super.toBack();
    }

    private void generateLineNumbers() {
        this.markdownWindow.setMargin(new Insets(0, 4, 0, 0));
        this.mdScrollPane.setRowHeaderView(new TextLineNumber(this.markdownWindow));
        this.mdScrollPane.setVerticalScrollBarPolicy(22);
    }

    private void initComponents() {
        this.treeContextMenu = new JPopupMenu();
        this.mdContextMenu = new JPopupMenu();
        this.jPanel3 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.newModButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.mdScrollPane = new JScrollPane();
        this.markdownWindow = new JTextArea();
        this.jScrollPane6 = new JScrollPane();
        this.pageTree = new JTree();
        this.newPageButton = new JButton();
        this.jButton5 = new JButton();
        this.jButton2 = new JButton();
        this.jButton4 = new JButton();
        this.jButton11 = new JButton();
        this.jButton3 = new JButton();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.jButton13 = new JButton();
        this.jButton12 = new JButton();
        this.jButton6 = new JButton();
        this.tabbedPain = new JTabbedPane();
        this.modPanel = new JPanel();
        this.nameLabel1 = new JLabel();
        this.modNameField = new JTextField();
        JButton nameHelp1 = new JButton();
        JButton nameHelp2 = new JButton();
        this.modIdField = new JTextField();
        this.nameLabel2 = new JLabel();
        JButton nameHelp3 = new JButton();
        this.nameLabel3 = new JLabel();
        this.modVersionSelect = new JComboBox();
        this.createFromExistingModButton = new JButton();
        this.copyDocFromSelected = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jButton10 = new JButton();
        this.jScrollPane5 = new JScrollPane();
        this.aliasList = new JList();
        JButton relationsHelp1 = new JButton();
        this.relationsLabel1 = new JLabel();
        JButton addRelation1 = new JButton();
        JButton editRelation1 = new JButton();
        JButton removeRelation1 = new JButton();
        this.pagePanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.idLabel = new JLabel();
        this.idField = new JTextField();
        this.weightLabel = new JLabel();
        JButton nameHelp = new JButton();
        JButton idHelp = new JButton();
        JButton weightHelp = new JButton();
        this.revisionLabel = new JLabel();
        JButton revHelp = new JButton();
        this.toggleHidden = new JCheckBox();
        this.jScrollPane3 = new JScrollPane();
        this.iconList = new JList();
        this.iconsLabel = new JLabel();
        JButton iconsHelp = new JButton();
        this.cycleIcons = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.targetEnRev = new JLabel();
        JButton addIcon = new JButton();
        JButton removeIcon = new JButton();
        JButton editIcon = new JButton();
        this.relationsLabel = new JLabel();
        JButton relationsHelp = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.relationList = new JList();
        JButton removeRelation = new JButton();
        JButton editRelation = new JButton();
        JButton addRelation = new JButton();
        this.jSeparator4 = new JSeparator();
        this.weightField = new JSpinner();
        this.updateEnRev = new JButton();
        this.revisionField = new JSpinner();
        this.enRevField = new JSpinner();
        JButton revHelp1 = new JButton();
        this.jButton7 = new JButton();
        this.jButton8 = new JButton();
        this.targetEnRev1 = new JLabel();
        this.matchLangBox = new JComboBox();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu2 = new JMenu();
        this.jMenu3 = new JMenu();
        this.alwaysOnTop = new JCheckBoxMenuItem();
        this.changeLangButton = new JMenuItem();
        this.treeContextMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                PIEditor.this.treeMenuClose(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                PIEditor.this.treeMenuOpen(evt);
            }
        });
        this.mdContextMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                PIEditor.this.mdMenuClose(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                PIEditor.this.treeMenuOpen(evt);
                PIEditor.this.mdMenuOpen(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle("Project Intelligence Editor");
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.newModButton.setText("New Mod");
        this.newModButton.setToolTipText("Add documentation for a new mod.");
        this.newModButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.newModAction(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(200);
        this.mdScrollPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                PIEditor.this.mdScroll(evt);
            }
        });
        this.markdownWindow.setColumns(20);
        this.markdownWindow.setRows(5);
        this.markdownWindow.setComponentPopupMenu(this.mdContextMenu);
        this.markdownWindow.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PIEditor.this.mdTextChange(evt);
            }
        });
        this.mdScrollPane.setViewportView(this.markdownWindow);
        this.jSplitPane1.setRightComponent(this.mdScrollPane);
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("JTree");
        DefaultMutableTreeNode treeNode2 = new DefaultMutableTreeNode("colors");
        DefaultMutableTreeNode treeNode3 = new DefaultMutableTreeNode("blue");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("violet");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("red");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("yellow");
        treeNode2.add(treeNode3);
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("sports");
        treeNode3 = new DefaultMutableTreeNode("basketball");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("soccer");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("football");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("hockey");
        treeNode2.add(treeNode3);
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("food");
        treeNode3 = new DefaultMutableTreeNode("hot dogs");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("pizza");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("ravioli");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("banan");
        treeNode2.add(treeNode3);
        treeNode1.add(treeNode2);
        this.pageTree.setModel(new DefaultTreeModel(treeNode1));
        this.pageTree.setCursor(new Cursor(0));
        this.pageTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PIEditor.this.pageTreeMouseClicked(evt);
            }
        });
        this.pageTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                PIEditor.this.pageSelected(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.pageTree);
        this.jSplitPane1.setLeftComponent(this.jScrollPane6);
        this.newPageButton.setText("New Page");
        this.newPageButton.setToolTipText("Add a new sub page to the selected page.");
        this.newPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.newPageAction(evt);
            }
        });
        this.jButton5.setText("New Local Doc");
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.newLocalDoc(evt);
            }
        });
        this.jButton2.setText("Image");
        this.jButton2.setActionCommand("image");
        this.jButton2.setFocusable(false);
        this.jButton2.setHorizontalTextPosition(0);
        this.jButton2.setVerticalTextPosition(3);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.insertAction(evt);
            }
        });
        this.jButton4.setText("Entity");
        this.jButton4.setActionCommand("entity");
        this.jButton4.setFocusable(false);
        this.jButton4.setHorizontalTextPosition(0);
        this.jButton4.setVerticalTextPosition(3);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.insertAction(evt);
            }
        });
        this.jButton11.setText("Rule");
        this.jButton11.setActionCommand("rule");
        this.jButton11.setFocusable(false);
        this.jButton11.setHorizontalTextPosition(0);
        this.jButton11.setVerticalTextPosition(3);
        this.jButton11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.insertAction(evt);
            }
        });
        this.jButton3.setText("Link");
        this.jButton3.setActionCommand("link");
        this.jButton3.setFocusable(false);
        this.jButton3.setHorizontalTextPosition(0);
        this.jButton3.setVerticalTextPosition(3);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.insertAction(evt);
            }
        });
        this.jButton1.setText("Stack");
        this.jButton1.setActionCommand("stack");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.insertAction(evt);
            }
        });
        this.jLabel1.setText("Insert:");
        this.jButton13.setText("Recipe");
        this.jButton13.setActionCommand("recipe");
        this.jButton13.setFocusable(false);
        this.jButton13.setHorizontalTextPosition(0);
        this.jButton13.setVerticalTextPosition(3);
        this.jButton13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.insertAction(evt);
            }
        });
        this.jButton12.setText("Table");
        this.jButton12.setActionCommand("table");
        this.jButton12.setFocusable(false);
        this.jButton12.setHorizontalTextPosition(0);
        this.jButton12.setVerticalTextPosition(3);
        this.jButton12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.insertAction(evt);
            }
        });
        this.jButton6.setText("Open MD Reference");
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.openMDRef(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.newModButton, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newPageButton, -2, 93, -2).addGap(18, 18, 18).addComponent(this.jButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToolBar1, -2, -1, -2).addGap(41, 41, 41).addComponent(this.jLabel1).addComponent(this.jButton1).addComponent(this.jButton13).addComponent(this.jButton2).addComponent(this.jButton3).addComponent(this.jButton4).addComponent(this.jButton11).addComponent(this.jButton12).addContainerGap()))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newModButton).addComponent(this.newPageButton).addComponent(this.jButton5).addComponent(this.jButton6)).addComponent(this.jToolBar1, -2, 25, -2).addGroup(jPanel3Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jLabel1)).addComponent(this.jButton1, -2, 21, -2).addComponent(this.jButton13, -2, 21, -2).addComponent(this.jButton2, -2, 21, -2).addComponent(this.jButton3, -2, 21, -2).addComponent(this.jButton4, -2, 21, -2).addComponent(this.jButton11, -2, 21, -2).addComponent(this.jButton12, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 417, Short.MAX_VALUE).addContainerGap()));
        this.modPanel.setToolTipText("");
        this.nameLabel1.setText("Mod Name:");
        this.nameLabel1.setToolTipText("");
        this.modNameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PIEditor.this.modNameChange(evt);
            }
        });
        nameHelp1.setText("?");
        nameHelp1.setToolTipText("Click for more info about this field.");
        nameHelp1.setActionCommand("modName");
        nameHelp1.setCursor(new Cursor(0));
        nameHelp1.setMargin(new Insets(0, 4, 0, 4));
        nameHelp1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.helpAction(evt);
            }
        });
        nameHelp2.setText("?");
        nameHelp2.setToolTipText("Click for more info about this field.");
        nameHelp2.setActionCommand("modID");
        nameHelp2.setCursor(new Cursor(0));
        nameHelp2.setMargin(new Insets(0, 4, 0, 4));
        nameHelp2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.helpAction(evt);
            }
        });
        this.modIdField.setEditable(false);
        this.modIdField.setToolTipText("Mod id can not be chnaged. If the mods id has changed then add an alias for the new id.");
        this.nameLabel2.setText("Mod ID:");
        this.nameLabel2.setToolTipText("");
        nameHelp3.setText("?");
        nameHelp3.setToolTipText("Click for more info about the version system.");
        nameHelp3.setActionCommand("versionHelp");
        nameHelp3.setCursor(new Cursor(0));
        nameHelp3.setMargin(new Insets(0, 4, 0, 4));
        nameHelp3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.helpAction(evt);
            }
        });
        this.nameLabel3.setText("Target Min Mod Version:");
        this.nameLabel3.setToolTipText("");
        this.modVersionSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.versionAction(evt);
            }
        });
        this.createFromExistingModButton.setText("Create documentation for new mod version");
        this.createFromExistingModButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.newVersionAction(evt);
            }
        });
        this.copyDocFromSelected.setSelected(true);
        this.copyDocFromSelected.setText("Copy documentation from selected target version");
        this.jSeparator3.setOrientation(1);
        this.jButton10.setForeground(new Color(250, 90, 90));
        this.jButton10.setText("Delete Mod Documentation");
        this.jButton10.setToolTipText("Deletes this mod's documentation. If you are someone updating a mods documentation you should never need to touch this button. ");
        this.jButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.deleteModAction(evt);
            }
        });
        this.aliasList.setSelectionMode(0);
        this.jScrollPane5.setViewportView(this.aliasList);
        relationsHelp1.setText("?");
        relationsHelp1.setToolTipText("Click for more info about this field.");
        relationsHelp1.setActionCommand("aliases");
        relationsHelp1.setCursor(new Cursor(0));
        relationsHelp1.setMargin(new Insets(0, 4, 0, 4));
        relationsHelp1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.helpAction(evt);
            }
        });
        this.relationsLabel1.setText("Mod Aliases");
        addRelation1.setText("+");
        addRelation1.setToolTipText("Add Alias");
        addRelation1.setCursor(new Cursor(0));
        addRelation1.setMargin(new Insets(0, 4, 0, 4));
        addRelation1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.addAlias(evt);
            }
        });
        editRelation1.setText("e");
        editRelation1.setToolTipText("Edit Selected Alias");
        editRelation1.setCursor(new Cursor(0));
        editRelation1.setMargin(new Insets(0, 4, 0, 4));
        editRelation1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.editAlias(evt);
            }
        });
        removeRelation1.setText("x");
        removeRelation1.setToolTipText("Remove Selected Alias");
        removeRelation1.setCursor(new Cursor(0));
        removeRelation1.setMargin(new Insets(0, 4, 0, 4));
        removeRelation1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.removeAlias(evt);
            }
        });
        GroupLayout modPanelLayout = new GroupLayout(this.modPanel);
        this.modPanel.setLayout(modPanelLayout);
        modPanelLayout.setHorizontalGroup(modPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modPanelLayout.createSequentialGroup().addGroup(modPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modPanelLayout.createSequentialGroup().addContainerGap().addGroup(modPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel1).addComponent(this.nameLabel2)).addGap(44, 44, 44).addComponent(this.modNameField, -2, 221, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(nameHelp1)).addGroup(modPanelLayout.createSequentialGroup().addGap(113, 113, 113).addComponent(this.modIdField, -2, 221, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(nameHelp2)).addGroup(modPanelLayout.createSequentialGroup().addContainerGap().addGroup(modPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.createFromExistingModButton, -1, -1, Short.MAX_VALUE).addComponent(this.copyDocFromSelected).addGroup(modPanelLayout.createSequentialGroup().addComponent(this.nameLabel3).addGap(18, 18, 18).addComponent(this.modVersionSelect, -2, 173, -2)).addComponent(this.jSeparator1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(nameHelp3))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(modPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(modPanelLayout.createSequentialGroup().addComponent(addRelation1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(editRelation1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(removeRelation1)).addGroup(GroupLayout.Alignment.LEADING, modPanelLayout.createSequentialGroup().addComponent(this.relationsLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(relationsHelp1)).addComponent(this.jScrollPane5, GroupLayout.Alignment.LEADING, -1, 315, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 292, Short.MAX_VALUE).addComponent(this.jButton10).addContainerGap()));
        modPanelLayout.setVerticalGroup(modPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modPanelLayout.createSequentialGroup().addContainerGap().addGroup(modPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, modPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton10)).addComponent(this.jSeparator3).addGroup(modPanelLayout.createSequentialGroup().addGroup(modPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modPanelLayout.createSequentialGroup().addGroup(modPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.relationsLabel1).addComponent(relationsHelp1, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane5, -2, 114, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(modPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(removeRelation1, -2, 24, -2).addComponent(editRelation1, -2, 24, -2).addComponent(addRelation1, -2, 24, -2))).addGroup(modPanelLayout.createSequentialGroup().addGroup(modPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel1).addComponent(this.modNameField, -2, -1, -2).addComponent(nameHelp1, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(modPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel2).addComponent(this.modIdField, -2, -1, -2).addComponent(nameHelp2, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(modPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modPanelLayout.createSequentialGroup().addGroup(modPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel3).addComponent(this.modVersionSelect, -2, -1, -2)).addGap(1, 1, 1).addComponent(this.jSeparator1, -2, -1, -2).addGap(4, 4, 4).addComponent(this.createFromExistingModButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyDocFromSelected)).addComponent(nameHelp3, -2, 100, -2)))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.tabbedPain.addTab("Mod", this.modPanel);
        this.nameLabel.setText("Name:");
        this.nameLabel.setToolTipText("");
        this.nameField.setToolTipText("The name of the page or the mod if this is the root page");
        this.nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PIEditor.this.nameChange(evt);
            }
        });
        this.idLabel.setText("Page ID:");
        this.idField.setEditable(false);
        this.idField.setToolTipText("This the the unique (within the context of the parant page) id for this page. This should be based on the page content e.g Draconium Ore would use the id draconiumOre");
        this.idField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PIEditor.this.idChange(evt);
            }
        });
        this.weightLabel.setText("Sorting Weight:");
        nameHelp.setText("?");
        nameHelp.setToolTipText("Click for more info about this field.");
        nameHelp.setActionCommand("name");
        nameHelp.setCursor(new Cursor(0));
        nameHelp.setMargin(new Insets(0, 4, 0, 4));
        nameHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.helpAction(evt);
            }
        });
        idHelp.setText("?");
        idHelp.setToolTipText("Click for more info about this field.");
        idHelp.setActionCommand("id");
        idHelp.setCursor(new Cursor(0));
        idHelp.setMargin(new Insets(0, 4, 0, 4));
        idHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.helpAction(evt);
            }
        });
        weightHelp.setText("?");
        weightHelp.setToolTipText("Click for more info about this field.");
        weightHelp.setActionCommand("weight");
        weightHelp.setCursor(new Cursor(0));
        weightHelp.setMargin(new Insets(0, 4, 0, 4));
        weightHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.helpAction(evt);
            }
        });
        this.revisionLabel.setText("Revision:");
        revHelp.setText("?");
        revHelp.setToolTipText("Click for more info about this field.");
        revHelp.setActionCommand("revision");
        revHelp.setCursor(new Cursor(0));
        revHelp.setMargin(new Insets(0, 4, 0, 4));
        revHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.helpAction(evt);
            }
        });
        this.toggleHidden.setText("Hidden");
        this.toggleHidden.setToolTipText("Hidden pages do not show in the page list (Except when in etit mode) but can be accessed via links.");
        this.toggleHidden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.toggleHidden(evt);
            }
        });
        this.iconList.setSelectionMode(0);
        this.jScrollPane3.setViewportView(this.iconList);
        this.iconsLabel.setText("Icon(s):");
        iconsHelp.setText("?");
        iconsHelp.setToolTipText("Click for more info about this field.");
        iconsHelp.setActionCommand("icons");
        iconsHelp.setCursor(new Cursor(0));
        iconsHelp.setMargin(new Insets(0, 4, 0, 4));
        iconsHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.helpAction(evt);
            }
        });
        this.cycleIcons.setText("Cycle Icons");
        this.cycleIcons.setToolTipText("");
        this.cycleIcons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.cycleIcons(evt);
            }
        });
        this.jSeparator2.setOrientation(1);
        this.targetEnRev.setText("Matches Rev:");
        addIcon.setText("+");
        addIcon.setToolTipText("Add icon");
        addIcon.setCursor(new Cursor(0));
        addIcon.setMargin(new Insets(0, 4, 0, 4));
        addIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.addIcon(evt);
            }
        });
        removeIcon.setText("x");
        removeIcon.setToolTipText("Remove Selected Icon");
        removeIcon.setCursor(new Cursor(0));
        removeIcon.setMargin(new Insets(0, 4, 0, 4));
        removeIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.removeIcon(evt);
            }
        });
        editIcon.setText("e");
        editIcon.setToolTipText("Edit Selected Icon");
        editIcon.setCursor(new Cursor(0));
        editIcon.setMargin(new Insets(0, 4, 0, 4));
        editIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.editIcon(evt);
            }
        });
        this.relationsLabel.setText("Content Relations:");
        relationsHelp.setText("?");
        relationsHelp.setToolTipText("Click for more info about this field.");
        relationsHelp.setActionCommand("relations");
        relationsHelp.setCursor(new Cursor(0));
        relationsHelp.setMargin(new Insets(0, 4, 0, 4));
        relationsHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.helpAction(evt);
            }
        });
        this.relationList.setSelectionMode(0);
        this.jScrollPane4.setViewportView(this.relationList);
        removeRelation.setText("x");
        removeRelation.setToolTipText("Remove Selected Relation");
        removeRelation.setCursor(new Cursor(0));
        removeRelation.setMargin(new Insets(0, 4, 0, 4));
        removeRelation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.removeRelation(evt);
            }
        });
        editRelation.setText("e");
        editRelation.setToolTipText("Edit Selected Relation");
        editRelation.setCursor(new Cursor(0));
        editRelation.setMargin(new Insets(0, 4, 0, 4));
        editRelation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.editRelation(evt);
            }
        });
        addRelation.setText("+");
        addRelation.setToolTipText("Add Relation");
        addRelation.setCursor(new Cursor(0));
        addRelation.setMargin(new Insets(0, 4, 0, 4));
        addRelation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.addRelation(evt);
            }
        });
        this.jSeparator4.setOrientation(1);
        this.weightField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PIEditor.this.weightChanged(evt);
            }
        });
        this.updateEnRev.setText("Update to latest");
        this.updateEnRev.setToolTipText("Sets the target English Revision to the current english revision of this page.");
        this.updateEnRev.setActionCommand("revision");
        this.updateEnRev.setCursor(new Cursor(0));
        this.updateEnRev.setMargin(new Insets(0, 4, 0, 4));
        this.updateEnRev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.updateMatchRev(evt);
            }
        });
        this.revisionField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PIEditor.this.revisionChange(evt);
            }
        });
        this.enRevField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PIEditor.this.matchRevChange(evt);
            }
        });
        revHelp1.setText("<html>Lang<br>Help</html>");
        revHelp1.setToolTipText("Click for more info about this field.");
        revHelp1.setActionCommand("matchRev");
        revHelp1.setCursor(new Cursor(0));
        revHelp1.setMargin(new Insets(0, 4, 0, 4));
        revHelp1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.helpAction(evt);
            }
        });
        this.jButton7.setText("Delete Page");
        this.jButton7.setToolTipText("");
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.deletePage(evt);
            }
        });
        this.jButton8.setText("<html>Import page content from alternate language</html>");
        this.jButton8.setToolTipText("");
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.importContentFromLang(evt);
            }
        });
        this.targetEnRev1.setText("Matches Lang:");
        this.matchLangBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.matchLangChange(evt);
            }
        });
        GroupLayout pagePanelLayout = new GroupLayout(this.pagePanel);
        this.pagePanel.setLayout(pagePanelLayout);
        pagePanelLayout.setHorizontalGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pagePanelLayout.createSequentialGroup().addContainerGap().addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pagePanelLayout.createSequentialGroup().addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idLabel).addComponent(this.weightLabel).addComponent(this.nameLabel)).addGap(30, 30, 30)).addGroup(pagePanelLayout.createSequentialGroup().addComponent(this.revisionLabel).addGap(66, 66, 66))).addGroup(pagePanelLayout.createSequentialGroup().addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.targetEnRev).addComponent(this.targetEnRev1)).addGap(36, 36, 36))).addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pagePanelLayout.createSequentialGroup().addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(pagePanelLayout.createSequentialGroup().addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idField, GroupLayout.Alignment.TRAILING, -2, 221, -2).addComponent(this.nameField, -2, 221, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(GroupLayout.Alignment.TRAILING, pagePanelLayout.createSequentialGroup().addComponent(this.weightField, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(weightHelp).addGap(123, 123, 123))).addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(nameHelp).addComponent(idHelp))).addGroup(pagePanelLayout.createSequentialGroup().addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pagePanelLayout.createSequentialGroup().addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.revisionField, GroupLayout.Alignment.TRAILING, -2, 61, -2).addComponent(this.enRevField, -2, 61, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(revHelp).addComponent(this.updateEnRev))).addComponent(this.matchLangBox, -2, 104, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(revHelp1))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 294, Short.MAX_VALUE).addGroup(pagePanelLayout.createSequentialGroup().addComponent(this.cycleIcons).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 78, Short.MAX_VALUE).addComponent(addIcon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(editIcon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(removeIcon)).addGroup(pagePanelLayout.createSequentialGroup().addComponent(this.iconsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(iconsHelp))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pagePanelLayout.createSequentialGroup().addComponent(addRelation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(editRelation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(removeRelation)).addGroup(GroupLayout.Alignment.LEADING, pagePanelLayout.createSequentialGroup().addComponent(this.relationsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(relationsHelp)).addComponent(this.jScrollPane4, GroupLayout.Alignment.LEADING, -1, 317, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton8, -2, 0, Short.MAX_VALUE).addComponent(this.toggleHidden).addComponent(this.jButton7, -1, 140, Short.MAX_VALUE)).addContainerGap()));
        pagePanelLayout.setVerticalGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pagePanelLayout.createSequentialGroup().addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pagePanelLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameField, -2, -1, -2).addComponent(nameHelp, -2, 24, -2).addComponent(iconsHelp, -2, 24, -2).addComponent(this.iconsLabel).addComponent(this.relationsLabel).addComponent(relationsHelp, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pagePanelLayout.createSequentialGroup().addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pagePanelLayout.createSequentialGroup().addComponent(this.jScrollPane3, -2, 114, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cycleIcons).addComponent(removeIcon, -2, 24, -2).addComponent(editIcon, -2, 24, -2).addComponent(addIcon, -2, 24, -2))).addGroup(pagePanelLayout.createSequentialGroup().addComponent(this.jScrollPane4, -2, 114, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(removeRelation, -2, 24, -2).addComponent(editRelation, -2, 24, -2).addComponent(addRelation, -2, 24, -2)))).addGap(0, 0, Short.MAX_VALUE)).addGroup(pagePanelLayout.createSequentialGroup().addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idLabel).addComponent(this.idField, -2, -1, -2).addComponent(idHelp, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.weightLabel).addComponent(weightHelp, -2, 24, -2).addComponent(this.weightField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.revisionLabel).addComponent(revHelp, -2, 24, -2).addComponent(this.revisionField, -2, -1, -2)).addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pagePanelLayout.createSequentialGroup().addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enRevField, -2, -1, -2).addComponent(this.targetEnRev).addComponent(this.updateEnRev, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.matchLangBox, -2, -1, -2).addComponent(this.targetEnRev1))).addGroup(pagePanelLayout.createSequentialGroup().addGap(1, 1, 1).addComponent(revHelp1)))))).addGroup(pagePanelLayout.createSequentialGroup().addContainerGap().addGroup(pagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2).addComponent(this.jSeparator4).addGroup(pagePanelLayout.createSequentialGroup().addComponent(this.toggleHidden).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton7, -2, 24, -2))))).addContainerGap()));
        this.tabbedPain.addTab("Page Properties", this.pagePanel);
        this.jMenu1.setText("File");
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.jMenu2.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                PIEditor.this.editMenuSelect(evt);
            }
        });
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu3.setText("Options");
        this.alwaysOnTop.setSelected(true);
        this.alwaysOnTop.setText("Always on top");
        this.alwaysOnTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.aotAction(evt);
            }
        });
        this.jMenu3.add(this.alwaysOnTop);
        this.changeLangButton.setText("Change Language");
        this.changeLangButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PIEditor.this.changeLangAction(evt);
            }
        });
        this.jMenu3.add(this.changeLangButton);
        this.jMenuBar1.add(this.jMenu3);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.tabbedPain)).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabbedPain, -2, 212, -2).addGap(8, 8, 8)));
        this.setBounds(0, 0, 1222, 755);
    }

    public void reload() {
        SwingUtilities.invokeLater(() -> {
            this.reloading = true;
            this.alwaysOnTop.setSelected(PIConfig.editorAlwaysOnTop);
            this.setAlwaysOnTop(PIConfig.editorAlwaysOnTop);
            this.markdownWindow.setLineWrap(PIConfig.editorLineWrap);
            this.updateTree();
            this.reloading = false;
        });
    }

    private void updateTree() {
        LogHelper.startTimer("expandedList");
        List expanded = PIEditor.streamTree(this.pageTree).filter(this.pageTree::isExpanded).map(this.pageTree::getPathForRow).map(TreePath::getLastPathComponent).map(Object::toString).collect(Collectors.toList());
        LogHelper.stopTimer();
        LogHelper.dev("Expanded: " + expanded);
        DocumentationPage selectedPage = this.getSelected();
        LogHelper.startTimer("modsNode");
        DefaultMutableTreeNode modsNode = new DefaultMutableTreeNode("Root Page (" + LanguageManager.getUserLanguage() + ")");
        this.treeModel = new DefaultTreeModel(modsNode);
        this.pageTree.setModel(this.treeModel);
        this.treeModel.setAsksAllowsChildren(true);
        LogHelper.stopTimer();
        LogHelper.startTimer("structureMap");
        Map<String, ModStructurePage> structureMap = DocumentationManager.getModStructureMap();
        for (String modid : structureMap.keySet()) {
            modsNode.add(this.loadModPages(structureMap.get(modid)));
        }
        LogHelper.stopTimer();
        LogHelper.startTimer("treeModel.reload");
        this.treeModel.reload();
        LogHelper.stopTimer();
        LogHelper.startTimer("Restore Tree");
        boolean keepSelection = false;
        int selectedRow = -1;
        for (int row = 0; row < this.pageTree.getRowCount(); ++row) {
            Object component = this.pageTree.getPathForRow(row).getLastPathComponent();
            String node = component.toString();
            if (expanded.contains(node) || node.equals("Root Page")) {
                this.pageTree.expandRow(row);
            }
            if (!(component instanceof DefaultMutableTreeNode) || !((DefaultMutableTreeNode)component).getUserObject().equals(selectedPage)) continue;
            keepSelection = true;
            this.pageTree.setSelectionRow(selectedRow);
        }
        LogHelper.stopTimer();
        LogHelper.startTimer("setSelectedPage");
        if (selectedPage != null && keepSelection) {
            this.setSelectedPage(selectedPage);
        } else {
            this.setSelectedPage(null);
        }
        LogHelper.stopTimer();
        SwingUtilities.updateComponentTreeUI(this);
    }

    private DefaultMutableTreeNode loadModPages(DocumentationPage page) {
        DefaultMutableTreeNode pageNode = new DefaultMutableTreeNode(new TreePageContainer(page));
        ArrayList<DocumentationPage> pages = new ArrayList<DocumentationPage>(page.getSubPages());
        pages.sort(Comparator.comparingInt(DocumentationPage::getSortingWeight));
        for (DocumentationPage subPage : pages) {
            pageNode.add(this.loadModPages(subPage));
        }
        return pageNode;
    }

    private void modNameChange(KeyEvent evt) {
        ModStructurePage sp;
        DocumentationPage page = this.getSelected();
        if (page != null && (sp = DocumentationManager.getModPage(page.getModid())) != null) {
            LanguageManager.setPageName(sp.getModid(), sp.getPageURI(), this.modNameField.getText(), LanguageManager.getUserLanguage());
            this.pageTree.updateUI();
        }
    }

    private void versionAction(ActionEvent evt) {
        String newVersion = (String)this.modVersionSelect.getSelectedItem();
        if (newVersion == null || this.reloading) {
            return;
        }
        DocumentationPage page = this.getSelected();
        if (page != null) {
            String selected = page.getPageURI();
            if (newVersion.equals("[Default-Best-Match]")) {
                DocumentationManager.setModVersionOverride(page.getModid(), null);
            } else {
                DocumentationManager.setModVersionOverride(page.getModid(), newVersion);
            }
            this.setSelectedPage(DocumentationManager.getPage(selected));
        }
    }

    private void newVersionAction(ActionEvent evt) {
        DocumentationPage page = this.getSelected();
        if (page == null) {
            return;
        }
        String info = "Whenever a mod releases a new version that changes existing content or\nadds new content you must create a set of documentation for the new version.\nThe way this normally works is you create a copy of the existing doc for the new version\nand then just edit/add documentation as needed for the new version.\n\nPlease enter the minimum version that this modified documentation will apply to.\nIf for example you are documentation specific changes to a mod this will be the\nversion in which those changes were first released.\nVersion should only contain numbers and colon's";
        String newVersion = JOptionPane.showInputDialog(this, info, "Select new version", -1);
        if (newVersion == null) {
            return;
        }
        if (!versionValidator.matcher(newVersion).find()) {
            JOptionPane.showMessageDialog(this, "The specified version \"" + newVersion + "\" did not pass validation!\nPI only supports semantic versions (versions comprised of numbers and periods) e.g. 1.0.0\nVersions containing other characters are not supported.", "Error", 0);
            return;
        }
        if (DocumentationManager.sortedModVersionMap.getOrDefault(page.getModid(), new LinkedList()).contains(newVersion)) {
            JOptionPane.showMessageDialog(this, "That version already exists!", "Error", 0);
            return;
        }
        try {
            DocumentationManager.stringToInt(newVersion.split("\\."));
            if (!FileHandler.FILE_NAME_VALIDATOR.test(newVersion)) {
                throw new Exception("");
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "The selected version is invalid! Please check your version and try again!", "Error", 0);
            return;
        }
        try {
            DocumentationManager.addNewDocVersion(page.getModid(), newVersion, this.copyDocFromSelected.isSelected() ? page.getModVersion() : null);
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error occurred while trying to create the new version! " + e.getMessage(), "Error", 0);
        }
    }

    private void addAlias(ActionEvent evt) {
        ModStructurePage modPage;
        DocumentationPage page = this.getSelected();
        if (page == null || (modPage = DocumentationManager.getModPage(page.getModid())) == null) {
            return;
        }
        String newAlias = JOptionPane.showInputDialog(this, "Mod aliases are meant to me used as essentially alternate modid's for a mod.\nThis should only be needed in 1 or 2 situations. Ether a mod changes its id.\nOr your documenting a mod that is split into multiple parts that each have a different id.", "Add Alias", -1);
        if (newAlias == null || newAlias.isEmpty() || modPage.getModAliases().contains(newAlias)) {
            return;
        }
        String selected = this.selectedPageURI;
        modPage.getModAliases().add(newAlias);
        DocumentationManager.saveDocToDisk(modPage);
        DocumentationManager.checkAndReloadDocFiles();
        this.setSelectedPage(DocumentationManager.getPage(selected));
    }

    private void editAlias(ActionEvent evt) {
        ModStructurePage modPage;
        DocumentationPage page = this.getSelected();
        if (page == null || (modPage = DocumentationManager.getModPage(page.getModid())) == null) {
            return;
        }
        String selected = this.aliasList.getSelectedValue();
        if (selected == null) {
            JOptionPane.showMessageDialog(this, "Please select an alias to edit!", "Error", 0);
            return;
        }
        String modified = JOptionPane.showInputDialog(this, "Edit alias", selected);
        if (modified == null || modified.isEmpty()) {
            return;
        }
        modPage.getModAliases().remove(selected);
        modPage.getModAliases().add(modified);
        String s = this.selectedPageURI;
        DocumentationManager.saveDocToDisk(modPage);
        DocumentationManager.checkAndReloadDocFiles();
        this.setSelectedPage(DocumentationManager.getPage(s));
    }

    private void removeAlias(ActionEvent evt) {
        ModStructurePage modPage;
        DocumentationPage page = this.getSelected();
        if (page == null || (modPage = DocumentationManager.getModPage(page.getModid())) == null) {
            return;
        }
        String selected = this.aliasList.getSelectedValue();
        if (selected == null) {
            JOptionPane.showMessageDialog(this, "Please select an alias to edit!", "Error", 0);
            return;
        }
        modPage.getModAliases().remove(selected);
        String s = this.selectedPageURI;
        DocumentationManager.saveDocToDisk(modPage);
        DocumentationManager.checkAndReloadDocFiles();
        this.setSelectedPage(DocumentationManager.getPage(s));
    }

    private void deleteModAction(ActionEvent evt) {
        ModStructurePage modPage;
        DocumentationPage page = this.getSelected();
        if (page == null || (modPage = DocumentationManager.getModPage(page.getModid())) == null) {
            return;
        }
        int confirm = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete " + modPage.getDisplayName() + " (id: " + modPage.getModid() + ") It will be lost forever! (A long time)", "Delete Mod?", 0, 2);
        if (confirm == 1) {
            return;
        }
        confirm = JOptionPane.showConfirmDialog(this, "Seriously though. Are you Really Absolutely Sure you Really Want to Delete This Mod?", "Really Delete Mod?", 0, 2);
        if (confirm == 1) {
            return;
        }
        DocumentationManager.deleteDoc(page);
        DocumentationManager.checkAndReloadDocFiles();
    }

    private void weightChanged(ChangeEvent evt) {
        if (this.ignoreWeightChange) {
            return;
        }
        long t = System.currentTimeMillis();
        DocumentationPage page = this.getSelected();
        if (page != null) {
            int weight = MathHelper.clip((int)((Integer)this.weightField.getValue()), (int)-2048, (int)2048);
            this.weightField.setValue(weight);
            page.setSortingWeight(weight);
            this.updateTree();
            this.setSelectedPage(page);
        }
        LogHelper.dev(System.currentTimeMillis() - t + "ms");
    }

    private void nameChange(KeyEvent evt) {
        DocumentationPage page = this.getSelected();
        if (page != null) {
            LanguageManager.setPageName(page.getModid(), page.getPageURI(), this.nameField.getText(), LanguageManager.getUserLanguage());
            this.pageTree.updateUI();
        }
    }

    private void idChange(KeyEvent evt) {
    }

    private void revisionChange(ChangeEvent evt) {
        DocumentationPage page = this.getSelected();
        if (page != null) {
            page.setRevision((Integer)this.revisionField.getValue());
        }
    }

    private void updateEnRev(ActionEvent evt) {
    }

    private void toggleHidden(ActionEvent evt) {
        DocumentationPage page = this.getSelected();
        if (page != null) {
            page.setHidden(this.toggleHidden.isSelected());
        }
    }

    private void newPageAction(ActionEvent evt) {
        this.addPage(this.getSelected());
    }

    private void addPage(DocumentationPage parentPage) {
        this.addPage(parentPage, null);
    }

    private void addPage(DocumentationPage parentPage, String mdTemplate) {
        if (parentPage == null) {
            return;
        }
        String name = JOptionPane.showInputDialog(this, "Please choose a display name for this page.", "Choose page Name", -1);
        if (name == null) {
            return;
        }
        String id = name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        if ((id = (String)JOptionPane.showInputDialog(this, "Please enter the id for the new page. Id should use \"snake_case\"\nformatting and should be based on the content this page is for.\ne.g. a page for Draconium Ore would use the id draconium_ore\n\nNote: A possible id has been generated from the name you gave.\nChange this if you need to.", "Choose page ID", -1, null, null, id)) == null) {
            return;
        }
        if ((id = id.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_")).isEmpty()) {
            JOptionPane.showMessageDialog(this, "Page id can not be empty!", "Invalid Input", 0);
            return;
        }
        if (DocumentationManager.getPage(parentPage.getPageURI() + (parentPage instanceof ModStructurePage ? "" : "/") + id) != null) {
            JOptionPane.showMessageDialog(this, "The selected page already contains a sub page with this id!\nPlease choose a different id.", "Duplicate ID", 0);
            return;
        }
        DocumentationPage newPage = new DocumentationPage(parentPage, parentPage.getModid(), parentPage.getModVersion(), parentPage.isPackDoc());
        parentPage.getSubPages().add(newPage);
        newPage.setPageId(id);
        newPage.generatePageURIs(parentPage.getPageURI(), new HashMap<String, DocumentationPage>());
        LanguageManager.setPageName(parentPage.getModid(), newPage.getPageURI(), name, LanguageManager.getUserLanguage());
        if (mdTemplate != null) {
            LogHelper.dev("Adding Template:\n" + mdTemplate);
            try {
                newPage.setRawMarkdown(mdTemplate);
            }
            catch (DocumentationPage.MDException e) {
                JOptionPane.showMessageDialog(this, "An error occurred!\n\n" + e.getMessage(), "Error", 0);
            }
        }
        DocumentationManager.checkAndReloadDocFiles();
        this.setSelectedPage(DocumentationManager.getPage(newPage.getPageURI()));
    }

    private void newModAction(ActionEvent evt) {
        UINewDoc ui = new UINewDoc((Frame)this, Maps.filterEntries((Map)ModHelperBC.getModNameMap(), input -> input != null && !PIGuiHelper.getSupportedMods().contains(input.getKey())), false);
        PIGuiHelper.centerWindowOnMC(ui);
        ui.setVisible(true);
        if (!ui.isCanceled()) {
            try {
                DocumentationManager.addMod(ui.getDocID(), ui.getDocName(), ui.getModVersion());
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getMessage(), "An Error Occurred!", 0);
            }
        }
    }

    private void newLocalDoc(ActionEvent evt) {
        UINewDoc ui = new UINewDoc((Frame)this, Collections.emptyMap(), true);
        PIGuiHelper.centerWindowOnMC(ui);
        ui.setVisible(true);
        if (!ui.isCanceled()) {
            try {
                DocumentationManager.addLocalDoc(ui.getDocID(), ui.getDocName());
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getMessage(), "An Error Occurred!", 0);
            }
        }
    }

    private void changeLangAction(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "This button is not implemented yet.\nPlease change language in game ether by changing the game language or by setting a different language in PI itself.", "Info", 1);
    }

    private void updatePageId(ActionEvent evt) {
    }

    private void importContentFromLang(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "This feature is not yet implemented!", "NYI", 0);
    }

    private void cycleIcons(ActionEvent evt) {
        DocumentationPage page = this.getSelected();
        if (page != null) {
            page.setCycle_icons(!page.cycle_icons());
            String sp = this.selectedPageURI;
            DocumentationManager.checkAndReloadDocFiles();
            this.setSelectedPage(DocumentationManager.getPage(sp));
        }
    }

    private void addIcon(ActionEvent evt) {
        final DocumentationPage page = this.getSelected();
        if (page == null) {
            return;
        }
        Consumer<ContentInfo> addIconAction = new Consumer<ContentInfo>(){

            @Override
            public void accept(ContentInfo contentInfo) {
                DocumentationPage iconPage = DocumentationManager.getPage(page.getPageURI());
                if (contentInfo != null && !(iconPage instanceof RootPage)) {
                    iconPage.getIcons().add(contentInfo.getAsIconObj());
                    iconPage.saveToDisk();
                    PIEditor.this.setSelectedPage(DocumentationManager.getPage(PIEditor.this.selectedPageURI));
                }
                SwingUtilities.invokeLater(() -> PIEditor.this.toFront());
            }
        };
        PIGuiHelper.openContentChooser(null, GuiContentSelect.SelectMode.ICON, addIconAction, ContentInfo.ContentType.ITEM_STACK, ContentInfo.ContentType.ENTITY, ContentInfo.ContentType.IMAGE);
        this.toBack();
    }

    private void editIcon(ActionEvent evt) {
        final DocumentationPage page = this.getSelected();
        if (page == null) {
            return;
        }
        ContentInfo selected = this.iconList.getSelectedValue();
        if (selected == null) {
            JOptionPane.showMessageDialog(this, "Please select an icon to edit!", "Error", 0);
            return;
        }
        final JsonObject selectedObj = selected.getAsIconObj();
        Consumer<ContentInfo> editIconAction = new Consumer<ContentInfo>(){

            @Override
            public void accept(ContentInfo contentInfo) {
                DocumentationPage iconPage = DocumentationManager.getPage(page.getPageURI());
                PIEditor.this.toFront();
                if (contentInfo != null && !(iconPage instanceof RootPage)) {
                    iconPage.getIcons().remove(selectedObj);
                    iconPage.getIcons().add(contentInfo.getAsIconObj());
                    iconPage.saveToDisk();
                    PIEditor.this.setSelectedPage(DocumentationManager.getPage(PIEditor.this.selectedPageURI));
                }
            }
        };
        PIGuiHelper.openContentChooser(selected, GuiContentSelect.SelectMode.ICON, editIconAction, ContentInfo.ContentType.ITEM_STACK, ContentInfo.ContentType.ENTITY, ContentInfo.ContentType.IMAGE);
        this.toBack();
    }

    private void removeIcon(ActionEvent evt) {
        DocumentationPage page = this.getSelected();
        if (page == null) {
            return;
        }
        ContentInfo selected = this.iconList.getSelectedValue();
        int selectedIndex = this.iconList.getSelectedIndex();
        if (selected == null) {
            JOptionPane.showMessageDialog(this, "Please select an icon to delete!", "Error", 0);
            return;
        }
        ProcessHandlerClient.syncTask(() -> {
            page.getIcons().remove(selectedIndex);
            page.saveToDisk();
            this.setSelectedPage(DocumentationManager.getPage(this.selectedPageURI));
        });
    }

    private void addRelation(ActionEvent evt) {
        final DocumentationPage page = this.getSelected();
        if (page == null) {
            return;
        }
        Consumer<ContentInfo> addRelationAction = new Consumer<ContentInfo>(){

            @Override
            public void accept(ContentInfo contentInfo) {
                DocumentationPage docPage = DocumentationManager.getPage(page.getPageURI());
                PIEditor.this.toFront();
                if (contentInfo != null && !(docPage instanceof RootPage)) {
                    docPage.getRelations().add(contentInfo.asRelation());
                    docPage.saveToDisk();
                    DocumentationManager.clearRelationCache();
                    PIEditor.this.setSelectedPage(DocumentationManager.getPage(PIEditor.this.selectedPageURI));
                }
            }
        };
        PIGuiHelper.openContentChooser(null, GuiContentSelect.SelectMode.RELATION, addRelationAction, ContentInfo.ContentType.ITEM_STACK, ContentInfo.ContentType.ENTITY, ContentInfo.ContentType.FLUID);
        this.toBack();
    }

    private void editRelation(ActionEvent evt) {
        final DocumentationPage page = this.getSelected();
        if (page == null) {
            return;
        }
        final ContentRelation selected = this.relationList.getSelectedValue();
        if (selected == null) {
            JOptionPane.showMessageDialog(this, "Please select a relation to edit!", "Error", 0);
            return;
        }
        ContentInfo selectedInfo = ContentInfo.fromRelation(selected);
        Consumer<ContentInfo> editRelationAction = new Consumer<ContentInfo>(){

            @Override
            public void accept(ContentInfo contentInfo) {
                DocumentationPage docPage = DocumentationManager.getPage(page.getPageURI());
                PIEditor.this.toFront();
                if (contentInfo != null && !(docPage instanceof RootPage)) {
                    docPage.getRelations().remove(selected);
                    docPage.getRelations().add(contentInfo.asRelation());
                    docPage.saveToDisk();
                    DocumentationManager.clearRelationCache();
                    PIEditor.this.setSelectedPage(DocumentationManager.getPage(PIEditor.this.selectedPageURI));
                }
            }
        };
        PIGuiHelper.openContentChooser(selectedInfo, GuiContentSelect.SelectMode.RELATION, editRelationAction, ContentInfo.ContentType.ITEM_STACK, ContentInfo.ContentType.ENTITY, ContentInfo.ContentType.FLUID);
        this.toBack();
    }

    private void removeRelation(ActionEvent evt) {
        DocumentationPage page = this.getSelected();
        if (page == null) {
            return;
        }
        ContentRelation selected = this.relationList.getSelectedValue();
        if (selected == null) {
            JOptionPane.showMessageDialog(this, "Please select an icon to delete!", "Error", 0);
            return;
        }
        ProcessHandlerClient.syncTask(() -> {
            page.getRelations().remove(selected);
            page.saveToDisk();
            DocumentationManager.clearRelationCache();
            this.setSelectedPage(DocumentationManager.getPage(this.selectedPageURI));
        });
    }

    private void updateMatchRev(ActionEvent evt) {
        DocumentationPage page = this.getSelected();
        if (page == null) {
            return;
        }
        LanguageManager.PageLangData data = LanguageManager.getLangData(page.getPageURI(), LanguageManager.getUserLanguage());
        if (data == null) {
            JOptionPane.showMessageDialog(this, "Please update the page name first.", "Error", 0);
            return;
        }
        Object item = this.matchLangBox.getSelectedItem();
        data.setMatchLang(item == null || item.equals("disabled") ? null : "" + item, (Integer)this.enRevField.getValue());
    }

    private void matchLangChange(ActionEvent evt) {
        String lang;
        DocumentationPage page = this.getSelected();
        if (page == null) {
            return;
        }
        LanguageManager.PageLangData data = LanguageManager.getLangData(page.getPageURI(), LanguageManager.getUserLanguage());
        Object item = this.matchLangBox.getSelectedItem();
        String string = lang = item == null || item.equals("disabled") ? null : "" + item;
        if (data == null) {
            if (lang == null) {
                return;
            }
            JOptionPane.showMessageDialog(this, "Please update the page name first.. ", "Error", 0);
            return;
        }
        data.setMatchLang(lang, (Integer)this.enRevField.getValue());
        this.enRevField.setEnabled(lang != null);
    }

    private void matchRevChange(ChangeEvent evt) {
        DocumentationPage page = this.getSelected();
        if (page == null) {
            return;
        }
        LanguageManager.PageLangData data = LanguageManager.getLangData(page.getPageURI(), LanguageManager.getUserLanguage());
        if (data == null) {
            JOptionPane.showMessageDialog(this, "Please update the page name first...", "Error", 0);
            return;
        }
        Object item = this.matchLangBox.getSelectedItem();
        data.setMatchLang(item == null || item.equals("disabled") ? null : "" + item, (Integer)this.enRevField.getValue());
    }

    private void pageSelected(TreeSelectionEvent evt) {
        Object component = this.pageTree.getLastSelectedPathComponent();
        if (component instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)component).getUserObject() instanceof TreePageContainer) {
            this.setSelectedPage(((TreePageContainer)((DefaultMutableTreeNode)component).getUserObject()).getPage());
        } else {
            this.setSelectedPage(null);
        }
    }

    private void setSelectedPage(@Nullable DocumentationPage page) {
        this.reloading = true;
        if (!this.selectedPageURI.isEmpty()) {
            caretPositions.put(this.selectedPageURI, this.markdownWindow.getCaretPosition());
        }
        this.selectedPageURI = page == null ? "" : page.getPageURI();
        boolean isModPage = page instanceof ModStructurePage;
        boolean pageSelected = page != null;
        this.newPageButton.setEnabled(pageSelected);
        this.nameField.setEnabled(pageSelected && !isModPage);
        this.idField.setEnabled(pageSelected && !isModPage);
        this.weightField.setEnabled(pageSelected && !isModPage);
        this.revisionField.setEnabled(pageSelected);
        this.cycleIcons.setEnabled(pageSelected);
        this.iconList.setEnabled(pageSelected);
        this.relationList.setEnabled(pageSelected && !isModPage);
        this.toggleHidden.setEnabled(pageSelected && !isModPage);
        this.enRevField.setEnabled(false);
        this.updateEnRev.setEnabled(false);
        this.modNameField.setEnabled(pageSelected);
        this.modIdField.setEnabled(pageSelected);
        this.modVersionSelect.setEnabled(pageSelected);
        if (pageSelected) {
            String modid = page.getModid();
            LinkedList<String> versions = DocumentationManager.sortedModVersionMap.get(modid);
            this.modNameField.setText(LanguageManager.getPageLangName(page.getModid() + ":", page.getLocalizationLang()));
            this.modIdField.setText(modid);
            this.modVersionSelect.removeAllItems();
            this.modVersionSelect.addItem("[Default-Best-Match]");
            if (versions != null) {
                versions.forEach(version -> this.modVersionSelect.addItem((String)version));
            }
            this.modVersionSelect.setSelectedItem(page.getModVersion());
            this.nameField.setText(isModPage ? "" : LanguageManager.getPageLangName(page));
            this.idField.setText(isModPage ? "" : page.getPageId());
            this.ignoreWeightChange = true;
            this.weightField.setValue(page.getSortingWeight());
            this.ignoreWeightChange = false;
            this.cycleIcons.setSelected(page.cycle_icons());
            this.toggleHidden.setSelected(page.isHidden());
            this.tabbedPain.setSelectedIndex(page instanceof ModStructurePage ? 0 : 1);
            this.readMDFile(page);
            for (int i = 0; i < this.pageTree.getRowCount(); ++i) {
                TreePageContainer container;
                DefaultMutableTreeNode comp = (DefaultMutableTreeNode)this.pageTree.getPathForRow(i).getLastPathComponent();
                if (comp == null || !(comp.getUserObject() instanceof TreePageContainer) || (container = (TreePageContainer)comp.getUserObject()).getPage() != page) continue;
                if (!this.pageTree.isRowSelected(i)) {
                    this.pageTree.setSelectionRow(i);
                }
                break;
            }
        } else {
            this.markdownWindow.setText("");
        }
        boolean isPackPage = page != null && page.isPackDoc();
        this.modVersionSelect.setEnabled(!isPackPage);
        this.createFromExistingModButton.setEnabled(!isPackPage);
        this.revisionField.setEnabled(!isPackPage);
        this.matchLangBox.setEnabled(!isPackPage);
        this.targetEnRev.setEnabled(!isPackPage);
        this.reloadLists();
        this.reloading = false;
        if (page != null) {
            ProcessHandlerClient.syncTask(() -> DisplayController.MASTER_CONTROLLER.openPage(this.getSelectedPageURI(), false));
        }
    }

    private synchronized String getSelectedPageURI() {
        return this.selectedPageURI;
    }

    private void readMDFile(DocumentationPage page) {
        File mdFile = page.getMarkdownFile();
        boolean set = false;
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(mdFile), StandardCharsets.UTF_8);){
            this.markdownWindow.setText(IOUtils.toString((Reader)reader));
            int pos = caretPositions.getOrDefault(page.getPageURI(), 0);
            this.markdownWindow.setCaretPosition(MathHelper.clip((int)pos, (int)0, (int)(this.markdownWindow.getText().length() - 1)));
            set = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!set) {
            this.markdownWindow.setText("");
        }
    }

    private void reloadLists() {
        DocumentationPage page = this.getSelected();
        this.iconListModel.clear();
        this.relationListModel.clear();
        this.aliasListModel.clear();
        if (page == null) {
            return;
        }
        LanguageManager.PageLangData data = LanguageManager.getLangData(page.getPageURI(), LanguageManager.getUserLanguage());
        if (data != null) {
            if (data.matchLang != null) {
                this.matchLangBox.setSelectedItem(data.matchLang);
                this.enRevField.setValue(data.matchRev);
            } else {
                this.matchLangBox.setSelectedItem("disabled");
            }
            this.revisionField.setValue(data.pageRev);
            this.enRevField.setEnabled(data.matchLang != null);
            if (this.enRevField.isEnabled()) {
                this.revisionField.setValue(data.pageRev);
            }
        } else {
            this.matchLangBox.setSelectedItem("disabled");
            this.enRevField.setEnabled(false);
        }
        page.getIcons().forEach(jsonObject -> this.iconListModel.addElement(ContentInfo.fromIconObj(jsonObject)));
        ModStructurePage sp = DocumentationManager.getModPage(page.getModid());
        if (sp != null) {
            sp.getModAliases().forEach(alias -> this.aliasListModel.addElement((String)alias));
        }
        if (!(page instanceof ModStructurePage)) {
            page.getRelations().forEach(s -> this.relationListModel.addElement((ContentRelation)s));
        }
    }

    private void deletePage(ActionEvent evt) {
        this.deletePage(this.getSelected());
    }

    private void deletePage(DocumentationPage page) {
        if (page != null && !(page instanceof ModStructurePage) && JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this page and its sub pages? \"" + page.getDisplayName() + "\" This can not be undone!", "Confirm Delete", 0) == 0) {
            page.deletePage();
            this.reload();
            GuiProjectIntelligence.requiresEditReload = true;
        }
    }

    private void pageTreeMouseClicked(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            TreePath path = this.pageTree.getPathForLocation(evt.getX(), evt.getY());
            if (path == null) {
                return;
            }
            TreePageContainer container = (TreePageContainer)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            this.generateTreeContext(container).forEach(comp -> this.treeContextMenu.add((Component)comp));
            this.treeContextMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private List<JComponent> generateTreeContext(TreePageContainer container) {
        String clipboard;
        LinkedList<JComponent> menuItems = new LinkedList<JComponent>();
        JLabel label = new JLabel(container.getPage().getDisplayName());
        label.setHorizontalAlignment(0);
        menuItems.add(label);
        menuItems.add(new JPopupMenu.Separator());
        JMenuItem item = new JMenuItem("Copy Page URI");
        item.addActionListener(e -> Utils.setClipboardString((String)container.pageURI));
        menuItems.add(item);
        long t = System.currentTimeMillis();
        if (!(container.getPage() instanceof RootPage)) {
            item = new JMenuItem("New Page");
            item.addActionListener(e -> this.addPage(container.getPage()));
            menuItems.add(item);
        }
        if (!container.isStructPage) {
            item = new JMenuItem("Delete Page");
            item.addActionListener(e -> this.deletePage(container.getPage()));
            menuItems.add(item);
        }
        if (!(container.getPage() instanceof RootPage)) {
            File[] files;
            menuItems.add(new JPopupMenu.Separator());
            JMenu menu = new JMenu("Load Page Template");
            File templatesDir = new File(DocumentationManager.getDocDirectory().getParent(), "PageTemplates");
            if (templatesDir.exists() && (files = templatesDir.listFiles((dir, name) -> name.endsWith(".template"))) != null) {
                for (File file : files) {
                    JMenuItem tempItem = new JMenuItem(file.getName().replace(".template", ""));
                    tempItem.addActionListener(e -> {
                        try {
                            this.addPage(container.getPage(), FileUtils.readFileToString((File)file, (Charset)Charsets.UTF_8));
                        }
                        catch (IOException e1) {
                            JOptionPane.showMessageDialog(this, "An error occurred!\n\n" + e1.getMessage(), "Error", 0);
                        }
                    });
                    menu.add(tempItem);
                }
            }
            menuItems.add(menu);
        }
        if (!(clipboard = Utils.getClipboardString()).isEmpty()) {
            item = new JMenuItem("Add page to templates");
            item.addActionListener(e -> {
                File templatesDir = new File(DocumentationManager.getDocDirectory().getParent(), "PageTemplates");
                String name = JOptionPane.showInputDialog("Please specify a name for the template.\nPlease note that currently the only way to remove a template is to manually delete it from disk.\nTemplates are stored in: " + templatesDir.getAbsolutePath());
                if (name != null) {
                    int response;
                    File file = new File(templatesDir, name + ".template");
                    if (file.exists() && (response = JOptionPane.showConfirmDialog(this, "There is already a template with that name. Do you wish to replace it?", "Replace", 0)) == 1) {
                        return;
                    }
                    try {
                        FileUtils.copyFile((File)container.getPage().getMarkdownFile(), (File)file);
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(this, "An error occurred!\n\n" + e1.getMessage(), "Error", 0);
                    }
                }
            });
            menuItems.add(item);
        }
        if (!(container.getPage() instanceof RootPage)) {
            File file = container.getPage().getMarkdownFile();
            String path = file.getAbsolutePath();
            item = new JMenuItem("Open File: " + path.substring(path.indexOf("ModDocs") + 8));
            item.addActionListener(e -> {
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            });
            menuItems.add(item);
        }
        return menuItems;
    }

    private void treeMenuOpen(PopupMenuEvent evt) {
    }

    private void treeMenuClose(PopupMenuEvent evt) {
        this.treeContextMenu.removeAll();
    }

    private void mdTextChange(KeyEvent evt) {
        this.markdownWindow.setLineWrap(true);
        this.markdownWindow.setTabSize(2);
        this.markdownWindow.setWrapStyleWord(true);
        DocumentationPage page = this.getSelected();
        if (page == null) {
            this.markdownWindow.setText("");
        } else {
            ProcessHandlerClient.syncTask(() -> {
                try {
                    page.setRawMarkdown(this.markdownWindow.getText());
                }
                catch (DocumentationPage.MDException e) {
                    JOptionPane.showMessageDialog(this, "An error occurred!\n\n" + e.getMessage(), "Error", 0);
                }
            });
        }
    }

    private void insertAction(ActionEvent evt) {
        String action = evt.getActionCommand();
        Consumer<ContentInfo> applyContentTag = contentInfo -> {
            if (contentInfo != null) {
                String tag = contentInfo.toMDTag();
                this.markdownWindow.insert(tag + " ", this.markdownWindow.getCaretPosition());
                this.markdownWindow.moveCaretPosition(this.markdownWindow.getCaretPosition() + tag.length());
                this.mdTextChange(null);
            }
            this.toFront();
        };
        switch (action) {
            case "stack": {
                this.toBack();
                PIGuiHelper.openContentChooser(null, GuiContentSelect.SelectMode.MD_CONTENT, applyContentTag, ContentInfo.ContentType.ITEM_STACK);
                break;
            }
            case "recipe": {
                this.toBack();
                PIGuiHelper.openContentChooser(null, GuiContentSelect.SelectMode.PICK_STACK, contentInfo -> SwingUtilities.invokeLater(() -> {
                    this.toFront();
                    if (contentInfo == null) {
                        return;
                    }
                    MDTagDialog tagD = new MDTagDialog((Frame)this, MDTagDialog.TagType.RECIPE);
                    tagD.setStack(contentInfo.stack.toString());
                    tagD.setVisible(true);
                    this.markdownWindow.insert(tagD.getTag(), this.markdownWindow.getCaretPosition());
                    this.mdTextChange(null);
                }), ContentInfo.ContentType.ITEM_STACK);
                break;
            }
            case "image": {
                this.toBack();
                PIGuiHelper.openContentChooser(null, GuiContentSelect.SelectMode.MD_CONTENT, applyContentTag, ContentInfo.ContentType.IMAGE);
                break;
            }
            case "link": {
                MDTagDialog tagD = new MDTagDialog((Frame)this, MDTagDialog.TagType.LINK);
                tagD.setVisible(true);
                this.markdownWindow.insert(tagD.getTag(), this.markdownWindow.getCaretPosition());
                break;
            }
            case "entity": {
                this.toBack();
                PIGuiHelper.openContentChooser(null, GuiContentSelect.SelectMode.MD_CONTENT, applyContentTag, ContentInfo.ContentType.ENTITY);
                break;
            }
            case "rule": {
                MDTagDialog tagD = new MDTagDialog((Frame)this, MDTagDialog.TagType.RULE);
                tagD.setVisible(true);
                this.markdownWindow.insert(tagD.getTag(), this.markdownWindow.getCaretPosition());
                break;
            }
            case "table": {
                MDTagDialog tagD = new MDTagDialog((Frame)this, MDTagDialog.TagType.TABLE);
                tagD.setVisible(true);
                this.markdownWindow.insert(tagD.getTag(), this.markdownWindow.getCaretPosition());
                break;
            }
        }
        this.mdTextChange(null);
    }

    private void insertFormat(TextFormatting format) {
        int start = this.markdownWindow.getSelectionStart();
        String selection = this.markdownWindow.getSelectedText();
        String fs = format.toString();
        if (selection != null) {
            selection = fs + selection + fs;
            selection = selection.replace("\n", fs + "\n" + fs);
            this.markdownWindow.replaceSelection(selection);
        } else {
            this.markdownWindow.insert(fs, start);
        }
        this.mdTextChange(null);
    }

    private void mdMenuOpen(PopupMenuEvent evt) {
        this.generateMDContext().forEach(comp -> this.mdContextMenu.add((Component)comp));
    }

    private void mdMenuClose(PopupMenuEvent evt) {
        this.mdContextMenu.removeAll();
    }

    private List<JComponent> generateMDContext() {
        String clipboard;
        JMenuItem item;
        LinkedList<JComponent> menuItems = new LinkedList<JComponent>();
        String selected = this.markdownWindow.getSelectedText();
        boolean hasEdit = false;
        if (selected != null && !selected.isEmpty()) {
            item = new JMenuItem("Copy");
            item.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            item.addActionListener(e -> this.markdownWindow.copy());
            menuItems.add(item);
        }
        if (!(clipboard = Utils.getClipboardString()).isEmpty()) {
            item = new JMenuItem("Paste");
            item.setAccelerator(KeyStroke.getKeyStroke(86, 2));
            item.addActionListener(e -> this.markdownWindow.paste());
            menuItems.add(item);
            hasEdit = true;
        }
        if (this.undo.canUndo()) {
            item = new JMenuItem("Undo");
            item.setAccelerator(KeyStroke.getKeyStroke(90, 2));
            item.addActionListener(e -> this.undo());
            menuItems.add(item);
            hasEdit = true;
        }
        if (this.undo.canRedo()) {
            item = new JMenuItem("Redo");
            item.setAccelerator(KeyStroke.getKeyStroke(90, 3));
            item.addActionListener(e -> this.redo());
            menuItems.add(item);
            hasEdit = true;
        }
        if (hasEdit) {
            menuItems.add(new JPopupMenu.Separator());
        }
        JMenu formatMenu = new JMenu("Apply Format");
        menuItems.add(formatMenu);
        for (TextFormatting format : TextFormatting.values()) {
            item = new JMenuItem(format.func_96297_d());
            item.addActionListener(e -> this.insertFormat(format));
            item.setFont(item.getFont().deriveFont(4));
            if (format.func_96302_c()) {
                item.setBackground(new Color(DataUtils.formatColour((TextFormatting)format)));
            } else {
                switch (format) {
                    case BOLD: {
                        item.setText("<html><b>" + format.func_96297_d() + "</html>");
                        break;
                    }
                    case STRIKETHROUGH: {
                        item.setText("<html><s>" + format.func_96297_d() + "</html>");
                        break;
                    }
                    case UNDERLINE: {
                        item.setText("<html><u>" + format.func_96297_d() + "</u></html>");
                        break;
                    }
                    case ITALIC: {
                        item.setText("<html><i>" + format.func_96297_d() + "</html>");
                    }
                }
            }
            formatMenu.add(item);
        }
        JMenu pFormatMenu = new JMenu("Paragraph Format");
        menuItems.add(pFormatMenu);
        item = new JMenuItem("Align Left");
        pFormatMenu.add(item);
        item.addActionListener(e -> this.insertParagraphTag("\u00a7align:left"));
        item = new JMenuItem("Align Center");
        pFormatMenu.add(item);
        item.addActionListener(e -> this.insertParagraphTag("\u00a7align:center"));
        item = new JMenuItem("Align Right");
        pFormatMenu.add(item);
        item.addActionListener(e -> this.insertParagraphTag("\u00a7align:right"));
        item = new JMenuItem("Shadow");
        pFormatMenu.add(item);
        item.addActionListener(e -> this.insertParagraphTag("\u00a7shadow"));
        item = new JMenuItem("Colour");
        pFormatMenu.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JColorChooser chooser = new JColorChooser(Color.WHITE);
                JLabel previewLabel = new JLabel("Colour Preview", 0){

                    @Override
                    public void paint(Graphics g) {
                        super.paint(g);
                        g.setColor(new Color(this.getForeground().getRGB()));
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                };
                previewLabel.setFont(new Font("Serif", 3, 48));
                previewLabel.setSize(previewLabel.getPreferredSize());
                previewLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
                chooser.setPreviewPanel(previewLabel);
                JColorChooser.createDialog(PIEditor.this, "Select Colour", true, chooser, e1 -> PIEditor.this.insertParagraphTag("\u00a7colour[0x" + Integer.toHexString(chooser.getColor().getRGB()).substring(2) + "]"), null).setVisible(true);
            }
        });
        if (this.markdownWindow.getText().replaceAll(" ", "").replaceAll("\n", "").isEmpty()) {
            File[] files;
            menuItems.add(new JPopupMenu.Separator());
            JMenu menu = new JMenu("Load Template");
            File templatesDir = new File(DocumentationManager.getDocDirectory().getParent(), "PageTemplates");
            if (templatesDir.exists() && (files = templatesDir.listFiles((dir, name) -> name.endsWith(".template"))) != null) {
                for (File file : files) {
                    JMenuItem tempItem = new JMenuItem(file.getName().replace(".template", ""));
                    tempItem.addActionListener(e -> {
                        try {
                            this.markdownWindow.setText(FileUtils.readFileToString((File)file, (Charset)Charsets.UTF_8));
                            this.mdTextChange(null);
                        }
                        catch (IOException e1) {
                            JOptionPane.showMessageDialog(this, "An error occurred!\n\n" + e1.getMessage(), "Error", 0);
                        }
                    });
                    menu.add(tempItem);
                }
            }
            menuItems.add(menu);
        }
        return menuItems;
    }

    private void insertParagraphTag(String tag) {
        int start = this.markdownWindow.getSelectionStart();
        String text = this.markdownWindow.getText();
        if (!(start > 0 && text.charAt(start - 1) != '\n' || start + 1 < text.length() && text.charAt(start) != '\n')) {
            this.markdownWindow.insert("\n" + tag, start);
        } else {
            this.markdownWindow.insert("\n" + tag + "\n", start);
        }
        this.mdTextChange(null);
    }

    private void editMenuSelect(MenuEvent evt) {
        this.jMenu2.removeAll();
        this.generateMDContext().forEach(jComponent -> this.jMenu2.add((Component)jComponent));
    }

    private String getHelpInfo(String topic) {
        switch (topic) {
            case "modName": {
                return "This is the display name for the mod. e.g. Draconic Evolution or Thermal Expansion. This name supports translation.";
            }
            case "modID": {
                return "This is the mod id as specified by the mod itself.";
            }
            case "versionHelp": {
                return "Ok so read carefully this can be confusing. This sets the minimum version of the mod to which this documentation applies.\nSo if you want this to apply to all versions ever set this to 0.0.0 and if this is the only documentation version written for\nthis mod then this will apply to all versions of the mod.\n\nNow say the mod releases a new version that changes a bunch of things. Do NOT change the existing documentation!\nThis would make it incompatible with the previous version of the mod. Instead you must create a copy of the documentation with\nthe minimum mod version set to match the new mod version. You can then make the required changes to the copy.\n\nSo what this does is creates two completely separate sets of documentation. One with its min version set to 0.0.0 and the other\nset to say, 1.0.0 for example. Now if the installed mod version is less then 1.0.0 it will use the documentation targeting 0.0.0\notherwise it will use the documentation for 1.0.0. Do not be afraid to create a new doc version when something changes! All files are indexed\nby their hashes on the server so it does not matter if you copy the entire documentation for a mod only to change one page. The server\nwill only need to store that one extra page.";
            }
            case "aliases": {
                return "Aliases are to be used in the event that a mod changes its mod id or has multiple id's such a mod like Project Red that is split into modules.\nThough in the case of a mod like Project red it should be sufficient to just use the ID for the core main mod that all of the other modules depend on.\nAlternatively it may make more sense to have separate documentation for each module.\n\nBut back to the point there are times where mods have to or just decide to change their name such as when forge started enforcing lowercase id's.\nThis forced DraconicEvolution to change to draconicevolution. In the case of DE if doc had already been created for the uppercase ID then the lowercase\nID would be added as an alias.";
            }
            case "name": {
                return "This is the name of the page. This name supports localization.\nFor help with adding translations see \"Lang Help\"";
            }
            case "id": {
                return "This is the unique id for this page. This should be unique within the context of the parent page. Meaning a page can not have two sub pages with the same id.\nThe id should be lowercase camel_case, Any uppercase characters will be automatically converted to lowercase and spaces will be replaced with underscores _.\n\nThe id should be indicative of the page content so a page about Draconium Ore should use the id draconium_ore.";
            }
            case "weight": {
                return "Page weight is used to determine the order in which pages are displayed in the page list.\nPages with a higher weight will sink down and be displayed bellow pages with a lower weight.\nPages with the same weight should be displayed in the order they were added but this is not guaranteed.";
            }
            case "revision": {
                return "This is the page revision. Whenever a page is updated the revision should be incremented. This is can be used to link translated pages to the default language.\nE.g. say you write a page in english and it has a revision number of 1. That page is then translated to chinese. The translated page would be set to match\nrevision 1 of the english translation. Now if something on in the english translation changes its revision will increment and as a result the chinese translation\nwill be automatically marked as potentially outdated because its still targeting revision 1 of the english translation.";
            }
            case "matchRev": {
                return "As mentioned in the help info for the revision field (which you should read first) this can be used to match a page translation to the default translation revision\n(usually english). That way when the targeted page updates this page will automatically be marked as potentially outdated.";
            }
            case "icons": {
                return "This is where you can add icons to be displayed to the left of the page name in the page list. An icon can be ether an item stack, entity or correctly sized image.\nBy default if you add more than one icon the first will be displayed and the others will be used as fallback icons. This means if your documentation spans multiple\nmod versions and the id for an item changes you can add all of its id's and it will use whatever one is avalible for the icon.\nYou also have the option to check the \"Cycle Icons\" box. When option is enabled and you have multiple icons it will cycle between the listed icons.";
            }
            case "relations": {
                return "Relations allow you to link pages directly to in game contend. For example the page for Draconium Ore could be\nlinked to the Draconium Ore item. Then there would be an option in game perhaps via a key bind while you have your mouse over draconium ore in your inventory to go\ndirectly to the documentation page linked to that item. This may also be applied to mobs and blocks in world.";
            }
        }
        return "[Error]: This help button has no bound help info!\n" + topic;
    }

    private void helpAction(ActionEvent evt) {
        String helpText = this.getHelpInfo(evt.getActionCommand());
        JOptionPane.showMessageDialog(this, helpText, "Help Info", 1);
    }

    private void mdScroll(MouseWheelEvent evt) {
    }

    private void openMDRef(ActionEvent evt) {
        MDReference frame = new MDReference();
        frame.setVisible(true);
        frame.setAlwaysOnTop(this.alwaysOnTop.isSelected());
        frame.jCheckBox1.setSelected(this.alwaysOnTop.isSelected());
        PIGuiHelper.centerWindowOn(frame, this);
    }

    public DocumentationPage getSelected() {
        return DocumentationManager.getPage(this.selectedPageURI);
    }

    private void aotAction(ActionEvent evt) {
        PIConfig.editorAlwaysOnTop = this.alwaysOnTop.isSelected();
        PIConfig.save();
        this.setAlwaysOnTop(PIConfig.editorAlwaysOnTop);
    }

    public static Stream<Integer> streamTree(JTree tree) {
        return StreamSupport.stream(new TreeIterator(tree).spliterator(), false);
    }

    public static Stream<Integer> streamTree(JTree tree, boolean backwards) {
        return StreamSupport.stream(new TreeIterator(tree, backwards).spliterator(), false);
    }

    public static class TreePageContainer {
        private String pageURI;
        public boolean isStructPage;
        public boolean isPackDoc;

        public TreePageContainer(DocumentationPage page) {
            this.pageURI = page.getPageURI();
            this.isStructPage = page instanceof ModStructurePage;
            this.isPackDoc = page.isPackDoc();
        }

        private String getSelectedVersionRange() {
            DocumentationPage page = this.getPage();
            if (page == null) {
                return "[Invalid-Entry]";
            }
            if (this.isPackDoc) {
                return "Local pack doc";
            }
            LinkedList<String> versions = DocumentationManager.sortedModVersionMap.get(page.getModid());
            if (versions == null) {
                return "[Version-Error]";
            }
            int index = versions.indexOf(page.getModVersion());
            if (index == -1 || index + 1 >= versions.size()) {
                return page.getModVersion() + "+";
            }
            return page.getModVersion() + " ->" + versions.get(index + 1);
        }

        public String toString() {
            DocumentationPage page = this.getPage();
            if (page == null) {
                return "[Invalid-Entry]";
            }
            String name = this.pageURI;
            if (LanguageManager.isPageLocalized(this.pageURI, LanguageManager.getUserLanguage())) {
                name = page.toString();
            }
            if (this.isStructPage) {
                name = name + " (" + this.getSelectedVersionRange() + ")";
            }
            return name;
        }

        public DocumentationPage getPage() {
            return DocumentationManager.getPage(this.pageURI);
        }

        public boolean equals(Object obj) {
            return super.equals(obj) || obj instanceof DocumentationPage && ((DocumentationPage)obj).getPageURI().equals(this.pageURI);
        }
    }

    public static class TreeIterator
    implements Iterator<Integer>,
    Iterable<Integer> {
        private int row;
        private boolean backwards;
        private JTree tree;

        public TreeIterator(JTree tree) {
            this.row = 0;
            this.tree = tree;
            this.backwards = false;
        }

        public TreeIterator(JTree tree, boolean backwards) {
            this.row = tree.getRowCount() - 1;
            this.backwards = backwards;
            this.tree = tree;
        }

        @Override
        public Iterator<Integer> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.backwards ? this.row > 0 : this.row < this.tree.getRowCount();
        }

        @Override
        public Integer next() {
            int n;
            if (this.backwards) {
                int n2 = this.row;
                n = n2;
                this.row = n2 - 1;
            } else {
                int n3 = this.row;
                n = n3;
                this.row = n3 + 1;
            }
            return n;
        }
    }

    public static class Singleton<E> {
        private E e;

        public Singleton(E e) {
            this.e = e;
        }

        public E get() {
            return this.e;
        }

        public void set(E e) {
            this.e = e;
        }
    }
}

