/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui.guielements;

import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiSelectDialog;
import com.brandon3055.projectintelligence.client.PITextures;
import com.brandon3055.projectintelligence.client.StyleHandler;
import com.brandon3055.projectintelligence.client.gui.guielements.StyledGuiButton;
import com.brandon3055.projectintelligence.docmanagement.LanguageManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class StyledSelectDialog<T>
extends GuiSelectDialog<T> {
    private String prop;
    private final String heading;
    private String selected = "";

    public StyledSelectDialog(MGuiElementBase parent, String prop, String heading) {
        super(parent);
        this.prop = prop;
        this.heading = heading;
        this.setSize(180, 250);
        this.setInsets(14, 2, 2, 2);
        this.setDragBar(13);
        this.setRendererBuilder(t -> {
            StyledGuiButton button = new StyledGuiButton(prop + "." + StyleHandler.StyleType.BUTTON_STYLE.getName());
            if (LanguageManager.LANG_NAME_MAP.containsKey(String.valueOf(t))) {
                String langCode = String.valueOf(t);
                button.setText(LanguageManager.LANG_NAME_MAP.get(langCode) + " [" + langCode + "]");
            } else {
                button.setText(String.valueOf(t));
            }
            if (t.equals(this.selected)) {
                button.setToggleMode(true).setToggleState(true);
            }
            ((GuiButton)button.setInsets(0, 2, 1, 2)).setWrap(true).setShadow(false).setTextColGetter((hovering, disabled) -> hovering ? 255 : 0);
            button.setYSizeMod((guiLabel, integer) -> guiLabel.fontRenderer.func_78267_b(button.getDisplayString(), Math.max(10, guiLabel.xSize() - button.getInsets().left - button.getInsets().right)) + 6);
            return button;
        });
    }

    public void reloadElement() {
        this.getScrollElement().setListSpacing(1);
        super.reloadElement();
    }

    public StyledSelectDialog<T> setSelected(String selected) {
        this.selected = selected;
        return this;
    }

    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        boolean thickBorders = StyleHandler.getBoolean(this.prop + "." + StyleHandler.StyleType.THICK_BORDERS.getName());
        int border = StyleHandler.getInt(this.prop + "." + StyleHandler.StyleType.BORDER.getName());
        if (StyleHandler.getBoolean(this.prop + "." + StyleHandler.StyleType.VANILLA_TEXTURE.getName())) {
            StyleHandler.getColour(this.prop + "." + StyleHandler.StyleType.COLOUR.getName()).glColour();
            ResourceHelperBC.bindTexture((ResourceLocation)PITextures.VANILLA_GUI);
            this.drawTiledTextureRectWithTrim(this.xPos(), this.yPos(), this.xSize(), this.ySize(), 4, 4, 4, 4, 0, thickBorders ? 0 : 128, 256, 128);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawBorderedRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), 1.0, 0, border);
        } else {
            int fill = StyleHandler.getInt(this.prop + "." + StyleHandler.StyleType.COLOUR.getName());
            this.drawBorderedRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), thickBorders ? 3.0 : 1.0, fill, border);
        }
        this.drawCenteredString(this.fontRenderer, this.heading, (float)this.xPos() + (float)this.xSize() / 2.0f, this.yPos() + 4, StyleHandler.getInt(this.prop + "." + StyleHandler.StyleType.TEXT_COLOUR.getName()), false);
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }
}

