/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketCoordTrackUpdate
extends LocationIntPacket<PacketCoordTrackUpdate> {
    private int dimensionID;

    public PacketCoordTrackUpdate() {
    }

    public PacketCoordTrackUpdate(World world, BlockPos pos) {
        super(pos);
        this.dimensionID = world.field_73011_w.getDimension();
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.dimensionID);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.dimensionID = buffer.readInt();
    }

    @Override
    public void handleClientSide(PacketCoordTrackUpdate message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketCoordTrackUpdate message, EntityPlayer player) {
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.HEAD);
        if (!stack.func_190926_b()) {
            ItemPneumaticArmor.setCoordTrackerPos(stack, message.dimensionID, message.pos);
        }
    }
}

