/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.api.tileentity.IPneumaticMachine;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemManometer
extends ItemPressurizable {
    public ItemManometer() {
        super("manometer", 30000, 3000);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        ItemStack iStack = player.func_184586_b(hand);
        if (((IPressurizable)iStack.func_77973_b()).getPressure(iStack) > 0.0f) {
            TileEntity te = world.func_175625_s(pos);
            IPneumaticMachine machine = IPneumaticMachine.getMachine(te);
            ArrayList<TextComponentTranslation> curInfo = new ArrayList<TextComponentTranslation>();
            ArrayList<String> info = new ArrayList<String>();
            if (machine != null && machine.getAirHandler(side) != null) {
                machine.getAirHandler(side).printManometerMessage(player, info);
            }
            if (te instanceof IManoMeasurable) {
                ((IManoMeasurable)te).printManometerMessage(player, info);
            }
            for (String string : info) {
                curInfo.add(new TextComponentTranslation(string, new Object[0]));
            }
            if (te instanceof IHeatExchanger) {
                IHeatExchangerLogic exchanger = ((IHeatExchanger)te).getHeatExchangerLogic(side);
                if (exchanger != null) {
                    curInfo.add(new TextComponentTranslation("waila.temperature", new Object[]{(int)exchanger.getTemperature() - 273}));
                } else {
                    for (EnumFacing d : EnumFacing.field_82609_l) {
                        exchanger = ((IHeatExchanger)te).getHeatExchangerLogic(d);
                        if (exchanger == null) continue;
                        curInfo.add(new TextComponentTranslation("waila.temperature." + d.toString().toLowerCase(), new Object[]{(int)exchanger.getTemperature() - 273}));
                    }
                }
            }
            if (curInfo.size() > 0) {
                ((IPressurizable)iStack.func_77973_b()).addAir(iStack, -30);
                for (ITextComponent iTextComponent : curInfo) {
                    player.func_146105_b(iTextComponent, false);
                }
                return EnumActionResult.SUCCESS;
            }
        } else {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "The Manometer doesn't have any charge!"), false);
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    public boolean func_111207_a(ItemStack iStack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K && entity instanceof IManoMeasurable) {
            if (((IPressurizable)iStack.func_77973_b()).getPressure(iStack) > 0.0f) {
                ArrayList<String> curInfo = new ArrayList<String>();
                ((IManoMeasurable)entity).printManometerMessage(player, curInfo);
                if (curInfo.size() > 0) {
                    ((IPressurizable)iStack.func_77973_b()).addAir(iStack, -30);
                    for (String s : curInfo) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation(s, new Object[0]), false);
                    }
                    return true;
                }
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "The Manometer doesn't have any charge!", new Object[0]), false);
            }
        }
        return false;
    }
}

