/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.common.DroneRegistry;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.config.AmadronOfferSettings;
import me.desht.pneumaticcraft.common.config.AmadronOfferStaticConfig;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticBase;
import me.desht.pneumaticcraft.common.inventory.SlotUntouchable;
import me.desht.pneumaticcraft.common.item.ItemAmadronTablet;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeRemoved;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.recipes.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.AmadronOfferCustom;
import me.desht.pneumaticcraft.common.recipes.AmadronOfferManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.server.permission.PermissionAPI;

public class ContainerAmadron
extends ContainerPneumaticBase {
    public static final int ROWS = 4;
    public static final int OFFERS_PER_PAGE = 8;
    public static boolean mayAddPeriodicOffers = true;
    public static boolean mayAddStaticOffers = true;
    public final List<AmadronOffer> offers = new ArrayList<AmadronOffer>(AmadronOfferManager.getInstance().getAllOffers());
    private final ItemStackHandler inv = new ItemStackHandler(16);
    @GuiSynced
    private final int[] shoppingItems = new int[8];
    @GuiSynced
    private final int[] shoppingAmounts = new int[8];
    @GuiSynced
    public final boolean[] buyableOffers = new boolean[this.offers.size()];
    @GuiSynced
    public EnumProblemState problemState = EnumProblemState.NO_PROBLEMS;
    @GuiSynced
    public int maxOffers = 0;
    @GuiSynced
    public int currentOffers = 0;
    @GuiSynced
    private boolean basketEmpty = true;

    public ContainerAmadron(EntityPlayer player) {
        super(null);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 2; ++x) {
                this.func_75146_a((Slot)new SlotUntouchable((IItemHandler)this.inv, y * 4 + x * 2, x * 73 + 12, y * 35 + 70));
                this.func_75146_a((Slot)new SlotUntouchable((IItemHandler)this.inv, y * 4 + x * 2 + 1, x * 73 + 57, y * 35 + 70));
            }
        }
        this.addSyncedFields(this);
        Arrays.fill(this.shoppingItems, -1);
        if (!player.field_70170_p.field_72995_K) {
            IItemHandler itemHandler = ItemAmadronTablet.getItemProvider(player.func_184614_ca());
            IFluidHandler fluidHandler = ItemAmadronTablet.getLiquidProvider(player.func_184614_ca());
            for (int i = 0; i < this.offers.size(); ++i) {
                int amount = ContainerAmadron.capShoppingAmount(this.offers.get(i), 1, itemHandler, fluidHandler, this);
                this.buyableOffers[i] = amount > 0;
            }
            this.problemState = EnumProblemState.NO_PROBLEMS;
            Map<AmadronOffer, Integer> shoppingCart = ItemAmadronTablet.getShoppingCart(player.func_184614_ca());
            for (Map.Entry<AmadronOffer, Integer> cartItem : shoppingCart.entrySet()) {
                int index;
                int offerId = this.offers.indexOf(cartItem.getKey());
                if (offerId < 0 || (index = this.getCartSlot(offerId)) < 0) continue;
                this.shoppingItems[index] = offerId;
                this.shoppingAmounts[index] = cartItem.getValue();
            }
            this.basketEmpty = Arrays.stream(this.shoppingAmounts).noneMatch(shoppingAmount -> shoppingAmount > 0);
            this.currentOffers = AmadronOfferManager.getInstance().countOffers(player.func_146103_bH().getId().toString());
            this.maxOffers = PneumaticCraftUtils.isPlayerOp(player) ? Integer.MAX_VALUE : AmadronOfferSettings.maxTradesPerPlayer;
        }
    }

    public boolean isBasketEmpty() {
        return this.basketEmpty;
    }

    public void func_75141_a(int slot, @Nonnull ItemStack stack) {
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        if (player.func_184614_ca().func_77973_b() == Itemss.AMADRON_TABLET) {
            IPressurizable pressurizable = (IPressurizable)Itemss.AMADRON_TABLET;
            pressurizable.addAir(player.func_184614_ca(), -1);
            if (pressurizable.getPressure(player.func_184614_ca()) > 0.0f) {
                return true;
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("gui.tab.problems.notEnoughPressure", new Object[0]), false);
        }
        return false;
    }

    public void clearStacks() {
        for (int i = 0; i < this.inv.getSlots(); ++i) {
            this.inv.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public void setStack(int index, ItemStack stack) {
        this.inv.setStackInSlot(index, stack);
    }

    @Override
    @Nonnull
    public ItemStack func_82846_b(EntityPlayer p_82846_1_, int p_82846_2_) {
        return ItemStack.field_190927_a;
    }

    public void clickOffer(int offerId, int mouseButton, boolean sneaking, EntityPlayer player) {
        this.problemState = EnumProblemState.NO_PROBLEMS;
        int cartSlot = this.getCartSlot(offerId);
        if (cartSlot >= 0) {
            if (mouseButton == 2) {
                this.shoppingAmounts[cartSlot] = 0;
            } else if (sneaking) {
                if (mouseButton == 0) {
                    int n = cartSlot;
                    this.shoppingAmounts[n] = this.shoppingAmounts[n] / 2;
                } else {
                    AmadronOffer offer = this.offers.get(offerId);
                    if (offer instanceof AmadronOfferCustom) {
                        this.removeCustomOffer(player, (AmadronOfferCustom)offer);
                    } else {
                        int n = cartSlot;
                        this.shoppingAmounts[n] = this.shoppingAmounts[n] * 2;
                        if (this.shoppingAmounts[cartSlot] == 0) {
                            this.shoppingAmounts[cartSlot] = 1;
                        }
                    }
                }
            } else if (mouseButton == 0) {
                int n = cartSlot;
                this.shoppingAmounts[n] = this.shoppingAmounts[n] - 1;
            } else {
                int n = cartSlot;
                this.shoppingAmounts[n] = this.shoppingAmounts[n] + 1;
            }
            if (this.shoppingAmounts[cartSlot] <= 0) {
                this.shoppingAmounts[cartSlot] = 0;
                this.shoppingItems[cartSlot] = -1;
            } else {
                this.shoppingAmounts[cartSlot] = this.capShoppingAmount(offerId, this.shoppingAmounts[cartSlot], player);
                this.shoppingItems[cartSlot] = this.shoppingAmounts[cartSlot] > 0 ? offerId : -1;
            }
        }
        this.basketEmpty = Arrays.stream(this.shoppingAmounts).noneMatch(shoppingAmount -> shoppingAmount > 0);
    }

    private void removeCustomOffer(EntityPlayer player, AmadronOfferCustom offer) {
        if (offer.getPlayerId().equals(player.func_146103_bH().getId().toString()) && AmadronOfferManager.getInstance().removeStaticOffer(offer)) {
            if (AmadronOfferSettings.notifyOfTradeRemoval) {
                NetworkHandler.sendToAll(new PacketAmadronTradeRemoved(offer));
            }
            offer.returnStock();
            try {
                AmadronOfferStaticConfig.INSTANCE.writeToFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            player.func_71053_j();
        }
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
        super.handleGUIButtonPress(guiID, player);
        if (guiID == 1) {
            boolean placed = false;
            for (int i = 0; i < this.shoppingItems.length; ++i) {
                if (this.shoppingItems[i] >= 0) {
                    EntityDrone drone;
                    WorldServer itemWorld;
                    AmadronOffer offer = this.offers.get(this.shoppingItems[i]);
                    BlockPos itemPos = ItemAmadronTablet.getItemProvidingLocation(player.func_184614_ca());
                    if (itemPos == null) {
                        itemPos = new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                        itemWorld = player.field_70170_p;
                    } else {
                        itemWorld = DimensionManager.getWorld((int)ItemAmadronTablet.getItemProvidingDimension(player.func_184614_ca()));
                    }
                    BlockPos liquidPos = ItemAmadronTablet.getLiquidProvidingLocation(player.func_184614_ca());
                    WorldServer liquidWorld = null;
                    if (liquidPos != null) {
                        liquidWorld = DimensionManager.getWorld((int)ItemAmadronTablet.getLiquidProvidingDimension(player.func_184614_ca()));
                    }
                    if ((drone = ContainerAmadron.retrieveOrderItems(offer, this.shoppingAmounts[i], (World)itemWorld, itemPos, (World)liquidWorld, liquidPos)) != null) {
                        drone.setHandlingOffer(offer, this.shoppingAmounts[i], player.func_184614_ca(), player.func_70005_c_());
                        placed = true;
                    }
                }
                if (!placed || !(player instanceof EntityPlayerMP)) continue;
                NetworkHandler.sendTo(new PacketPlaySound(Sounds.CHIRP, SoundCategory.PLAYERS, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.2f, 1.0f, false), (EntityPlayerMP)player);
            }
            Arrays.fill(this.shoppingAmounts, 0);
            Arrays.fill(this.shoppingItems, -1);
            this.basketEmpty = true;
        } else if (guiID == 2) {
            player.openGui((Object)PneumaticCraftRepressurized.instance, GuiHandler.EnumGuiId.AMADRON_ADD_PLAYER_TRADE.ordinal(), player.field_70170_p, 0, 0, 0);
        } else if (guiID == 3 && PermissionAPI.hasPermission((EntityPlayer)player, (String)"pneumaticcraft.amadron.addPeriodicTrade")) {
            player.openGui((Object)PneumaticCraftRepressurized.instance, GuiHandler.EnumGuiId.AMADRON_ADD_PERIODIC_TRADE.ordinal(), player.field_70170_p, 0, 0, 0);
        } else if (guiID == 4 && PermissionAPI.hasPermission((EntityPlayer)player, (String)"pneumaticcraft.amadron.addStaticTrade")) {
            player.openGui((Object)PneumaticCraftRepressurized.instance, GuiHandler.EnumGuiId.AMADRON_ADD_STATIC_TRADE.ordinal(), player.field_70170_p, 0, 0, 0);
        }
    }

    public static EntityDrone retrieveOrderItems(AmadronOffer offer, int times, World itemWorld, BlockPos itemPos, World liquidWorld, BlockPos liquidPos) {
        if (offer.getInput() instanceof ItemStack) {
            ItemStack stack;
            if (itemWorld == null || itemPos == null) {
                return null;
            }
            ItemStack queryingItems = (ItemStack)offer.getInput();
            NonNullList stacks = NonNullList.func_191196_a();
            for (int amount = queryingItems.func_190916_E() * times; amount > 0; amount -= stack.func_190916_E()) {
                stack = queryingItems.func_77946_l();
                stack.func_190920_e(Math.min(amount, stack.func_77976_d()));
                stacks.add((Object)stack);
            }
            if (stacks.isEmpty()) {
                Log.error(String.format("retrieveOrderItems: got empty itemstack list for offer %d x %s @ %s", times, queryingItems.toString(), itemPos.toString()));
                return null;
            }
            return (EntityDrone)DroneRegistry.getInstance().retrieveItemsAmazonStyle(itemWorld, itemPos, (ItemStack[])stacks.toArray((Object[])new ItemStack[0]));
        }
        if (liquidWorld == null || liquidPos == null) {
            return null;
        }
        FluidStack queryingFluid = ((FluidStack)offer.getInput()).copy();
        queryingFluid.amount *= times;
        return (EntityDrone)DroneRegistry.getInstance().retrieveFluidAmazonStyle(liquidWorld, liquidPos, queryingFluid);
    }

    private int capShoppingAmount(int offerId, int wantedAmount, EntityPlayer player) {
        IItemHandler inv = ItemAmadronTablet.getItemProvider(player.func_184614_ca());
        IFluidHandler fluidHandler = ItemAmadronTablet.getLiquidProvider(player.func_184614_ca());
        return ContainerAmadron.capShoppingAmount(this.offers.get(offerId), wantedAmount, inv, fluidHandler, this);
    }

    private static int capShoppingAmount(AmadronOffer offer, int wantedAmount, IItemHandler inv, IFluidHandler fluidHandler, ContainerAmadron container) {
        return ContainerAmadron.capShoppingAmount(offer, wantedAmount, inv, inv, fluidHandler, fluidHandler, container);
    }

    public static int capShoppingAmount(AmadronOffer offer, int wantedAmount, IItemHandler inputInv, IItemHandler outputInv, IFluidHandler inputFluidHandler, IFluidHandler outputFluidHandler, ContainerAmadron container) {
        int maxAmount;
        if (container != null && offer.getStock() >= 0 && wantedAmount > offer.getStock()) {
            wantedAmount = offer.getStock();
            container.problemState = EnumProblemState.OUT_OF_STOCK;
        }
        if (offer.getInput() instanceof ItemStack) {
            if (inputInv != null) {
                ItemStack searchingItem = (ItemStack)offer.getInput();
                int count = 0;
                for (int i = 0; i < inputInv.getSlots(); ++i) {
                    if (!inputInv.getStackInSlot(i).func_77969_a(searchingItem) || !ItemStack.func_77970_a((ItemStack)inputInv.getStackInSlot(i), (ItemStack)searchingItem)) continue;
                    count += inputInv.getStackInSlot(i).func_190916_E();
                }
                maxAmount = count / ((ItemStack)offer.getInput()).func_190916_E();
                if (wantedAmount > maxAmount) {
                    if (container != null) {
                        container.problemState = EnumProblemState.NOT_ENOUGH_ITEMS;
                    }
                    wantedAmount = maxAmount;
                }
            } else if (outputInv == null) {
                wantedAmount = 0;
                if (container != null) {
                    container.problemState = EnumProblemState.NO_ITEM_PROVIDER;
                }
            }
        } else if (inputFluidHandler != null) {
            FluidStack searchingFluid = ((FluidStack)offer.getInput()).copy();
            searchingFluid.amount = Integer.MAX_VALUE;
            FluidStack extracted = inputFluidHandler.drain(searchingFluid, false);
            maxAmount = 0;
            if (extracted != null) {
                maxAmount = extracted.amount / ((FluidStack)offer.getInput()).amount;
            }
            if (wantedAmount > maxAmount) {
                if (container != null) {
                    container.problemState = EnumProblemState.NOT_ENOUGH_FLUID;
                }
                wantedAmount = maxAmount;
            }
        } else if (outputFluidHandler == null) {
            wantedAmount = 0;
            if (container != null) {
                container.problemState = EnumProblemState.NO_FLUID_PROVIDER;
            }
        }
        if (offer.getOutput() instanceof ItemStack) {
            if (outputInv != null) {
                ItemStack providingItem = ((ItemStack)offer.getOutput()).func_77946_l();
                providingItem.func_190920_e(providingItem.func_190916_E() * wantedAmount);
                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)outputInv, (ItemStack)providingItem.func_77946_l(), (boolean)true);
                if (!remainder.func_190926_b() && wantedAmount > (maxAmount = (providingItem.func_190916_E() - remainder.func_190916_E()) / ((ItemStack)offer.getOutput()).func_190916_E())) {
                    wantedAmount = maxAmount;
                    if (container != null) {
                        container.problemState = EnumProblemState.NOT_ENOUGH_ITEM_SPACE;
                    }
                }
            } else if (inputInv == null) {
                wantedAmount = 0;
                if (container != null) {
                    container.problemState = EnumProblemState.NO_ITEM_PROVIDER;
                }
            }
        } else if (outputFluidHandler != null) {
            FluidStack providingFluid = ((FluidStack)offer.getOutput()).copy();
            providingFluid.amount *= wantedAmount;
            int amountFilled = outputFluidHandler.fill(providingFluid, false);
            maxAmount = amountFilled / ((FluidStack)offer.getOutput()).amount;
            if (wantedAmount > maxAmount) {
                wantedAmount = maxAmount;
                if (container != null) {
                    container.problemState = EnumProblemState.NOT_ENOUGH_FLUID_SPACE;
                }
            }
        } else if (inputFluidHandler == null) {
            wantedAmount = 0;
            if (container != null) {
                container.problemState = EnumProblemState.NO_FLUID_PROVIDER;
            }
        }
        return wantedAmount;
    }

    private int getCartSlot(int offerId) {
        int freeSlot = -1;
        for (int i = 0; i < this.shoppingItems.length; ++i) {
            if (this.shoppingItems[i] == offerId) {
                return i;
            }
            if (freeSlot != -1 || this.shoppingItems[i] != -1) continue;
            freeSlot = i;
        }
        return freeSlot;
    }

    public int getShoppingCartAmount(AmadronOffer offer) {
        int offerId = this.offers.indexOf(offer);
        for (int i = 0; i < this.shoppingItems.length; ++i) {
            if (this.shoppingItems[i] != offerId) continue;
            return this.shoppingAmounts[i];
        }
        return 0;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K && player.func_184614_ca().func_77973_b() == Itemss.AMADRON_TABLET) {
            HashMap<AmadronOffer, Integer> shoppingCart = new HashMap<AmadronOffer, Integer>();
            for (int i = 0; i < this.shoppingItems.length; ++i) {
                if (this.shoppingItems[i] < 0) continue;
                shoppingCart.put(this.offers.get(this.shoppingItems[i]), this.shoppingAmounts[i]);
            }
            ItemAmadronTablet.setShoppingCart(player.func_184614_ca(), shoppingCart);
        }
    }

    public static enum EnumProblemState {
        NO_PROBLEMS("noProblems"),
        NO_ITEM_PROVIDER("noItemProvider"),
        NO_FLUID_PROVIDER("noFluidProvider"),
        NOT_ENOUGH_ITEM_SPACE("notEnoughItemSpace"),
        NOT_ENOUGH_FLUID_SPACE("notEnoughFluidSpace"),
        NOT_ENOUGH_ITEMS("notEnoughItems"),
        NOT_ENOUGH_FLUID("notEnoughFluid"),
        OUT_OF_STOCK("outOfStock");

        private final String locKey;

        private EnumProblemState(String locKey) {
            this.locKey = locKey;
        }

        public String getLocalizationKey() {
            return "gui.tab.problems.amadron." + this.locKey;
        }
    }
}

