/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.recipe;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.Validate;

public class ItemIngredient {
    private final ItemStack stack;
    private final String oredictKey;
    private final int amount;
    private String tooltipKey;

    public ItemIngredient(ItemStack stack) {
        this.stack = stack;
        this.oredictKey = null;
        this.amount = 0;
    }

    public ItemIngredient(Item item, int amount, int meta) {
        this(new ItemStack(item, amount, meta));
    }

    public ItemIngredient(String oredictKey, int amount) {
        Validate.isTrue((boolean)OreDictionary.doesOreNameExist((String)oredictKey), (String)("invalid oredict key '" + oredictKey + "'"), (Object[])new Object[0]);
        this.oredictKey = oredictKey;
        this.amount = amount;
        this.stack = ItemStack.field_190927_a;
    }

    public ItemStack getSingleStack() {
        return this.oredictKey != null ? ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)OreDictionary.getOres((String)this.oredictKey).get(0)), (int)this.amount) : this.stack;
    }

    public NonNullList<ItemStack> getStacks() {
        NonNullList res;
        NonNullList nonNullList = res = this.oredictKey != null ? OreDictionary.getOres((String)this.oredictKey) : NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{this.stack});
        if (this.oredictKey != null) {
            res.forEach(stack -> stack.func_190920_e(this.amount));
        }
        return res;
    }

    public int getItemAmount() {
        return this.oredictKey != null ? this.amount : this.stack.func_190916_E();
    }

    public boolean isItemEqual(ItemStack stack) {
        if (this.oredictKey != null) {
            for (ItemStack s : OreDictionary.getOres((String)this.oredictKey)) {
                if (!OreDictionary.itemMatches((ItemStack)s, (ItemStack)stack, (boolean)false)) continue;
                return true;
            }
            return false;
        }
        return OreDictionary.itemMatches((ItemStack)this.stack, (ItemStack)stack, (boolean)false);
    }

    public ItemIngredient setTooltip(String key) {
        this.tooltipKey = key;
        return this;
    }

    public String getTooltipKey() {
        return this.tooltipKey;
    }
}

