/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe.handlers;

import com.google.common.collect.ImmutableMap;
import gregtech.api.GTValues;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.AssemblerRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.WireProperties;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTUtility;
import gregtech.common.items.MetaItems;
import java.util.Map;

public class WireRecipeHandler {
    private static final Map<OrePrefix, Integer> INSULATION_AMOUNT = ImmutableMap.of((Object)OrePrefix.cableGtSingle, (Object)1, (Object)OrePrefix.cableGtDouble, (Object)1, (Object)OrePrefix.cableGtQuadruple, (Object)2, (Object)OrePrefix.cableGtOctal, (Object)3, (Object)OrePrefix.cableGtHex, (Object)5);
    private static final OrePrefix[] wireSizes = new OrePrefix[]{OrePrefix.wireGtDouble, OrePrefix.wireGtQuadruple, OrePrefix.wireGtOctal, OrePrefix.wireGtHex};

    public static void register() {
        OrePrefix.wireGtSingle.addProcessingHandler(PropertyKey.WIRE, WireRecipeHandler::processWireSingle);
        OrePrefix.wireGtSingle.addProcessingHandler(PropertyKey.WIRE, WireRecipeHandler::generateCableCovering);
        OrePrefix.wireGtDouble.addProcessingHandler(PropertyKey.WIRE, WireRecipeHandler::generateCableCovering);
        OrePrefix.wireGtQuadruple.addProcessingHandler(PropertyKey.WIRE, WireRecipeHandler::generateCableCovering);
        OrePrefix.wireGtOctal.addProcessingHandler(PropertyKey.WIRE, WireRecipeHandler::generateCableCovering);
        OrePrefix.wireGtHex.addProcessingHandler(PropertyKey.WIRE, WireRecipeHandler::generateCableCovering);
    }

    public static void processWireSingle(OrePrefix wirePrefix, Material material, WireProperties property) {
        OrePrefix prefix = material.hasProperty(PropertyKey.INGOT) ? OrePrefix.ingot : (material.hasProperty(PropertyKey.GEM) ? OrePrefix.gem : OrePrefix.dust);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(prefix, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_WIRE)).output(OrePrefix.wireGtSingle, material, 2)).duration((int)material.getMass() * 2)).EUt(6 * WireRecipeHandler.getVoltageMultiplier(material))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.WIREMILL_RECIPES.recipeBuilder().input(prefix, material)).circuitMeta(1)).output(OrePrefix.wireGtSingle, material, 2)).duration((int)material.getMass())).EUt(WireRecipeHandler.getVoltageMultiplier(material))).buildAndRegister();
        for (OrePrefix wireSize : wireSizes) {
            int multiplier = (int)(wireSize.getMaterialAmount(material) / 3628800L);
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.WIREMILL_RECIPES.recipeBuilder().input(prefix, material, multiplier)).circuitMeta(multiplier * 2)).output(wireSize, material)).duration((int)(material.getMass() * (long)multiplier))).EUt(WireRecipeHandler.getVoltageMultiplier(material))).buildAndRegister();
        }
        if (!material.hasFlag(MaterialFlags.NO_WORKING) && material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            ModHandler.addShapedRecipe(String.format("%s_wire_single", material), OreDictUnifier.get(OrePrefix.wireGtSingle, material), "Xx", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, material));
        }
    }

    public static void generateCableCovering(OrePrefix wirePrefix, Material material, WireProperties property) {
        AssemblerRecipeBuilder builder;
        if (property.isSuperconductor()) {
            return;
        }
        int cableAmount = (int)(wirePrefix.getMaterialAmount(material) * 2L / 3628800L);
        OrePrefix cablePrefix = OrePrefix.getPrefix("cable" + wirePrefix.name().substring(4));
        byte voltageTier = GTUtility.getTierByVoltage(property.getVoltage());
        int insulationAmount = INSULATION_AMOUNT.get(cablePrefix);
        if (voltageTier <= 1) {
            WireRecipeHandler.generateManualRecipe(wirePrefix, material, cablePrefix, cableAmount);
        }
        if (voltageTier <= 4) {
            builder = (AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[0])).duration(100)).input(wirePrefix, material)).output(cablePrefix, material)).fluidInputs(Materials.Rubber.getFluid(144 * insulationAmount));
            if (voltageTier == 4) {
                builder.input(OrePrefix.foil, Materials.PolyvinylChloride, insulationAmount);
            }
            builder.buildAndRegister();
        }
        builder = (AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[0])).duration(100)).input(wirePrefix, material)).output(cablePrefix, material);
        if (voltageTier >= 6) {
            builder.input(OrePrefix.foil, Materials.PolyphenyleneSulfide, insulationAmount);
        }
        if (voltageTier >= 4) {
            builder.input(OrePrefix.foil, Materials.PolyvinylChloride, insulationAmount);
        }
        ((AssemblerRecipeBuilder)builder.fluidInputs(Materials.SiliconeRubber.getFluid(144 * insulationAmount / 2))).buildAndRegister();
        builder = (AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(GTValues.VA[0])).duration(100)).input(wirePrefix, material)).output(cablePrefix, material);
        if (voltageTier >= 6) {
            builder.input(OrePrefix.foil, Materials.PolyphenyleneSulfide, insulationAmount);
        }
        if (voltageTier >= 4) {
            builder.input(OrePrefix.foil, Materials.PolyvinylChloride, insulationAmount);
        }
        ((AssemblerRecipeBuilder)builder.fluidInputs(Materials.StyreneButadieneRubber.getFluid(144 * insulationAmount / 4))).buildAndRegister();
    }

    private static void generateManualRecipe(OrePrefix wirePrefix, Material material, OrePrefix cablePrefix, int cableAmount) {
        int insulationAmount = INSULATION_AMOUNT.get(cablePrefix);
        Object[] ingredients = new Object[insulationAmount + 1];
        ingredients[0] = new UnificationEntry(wirePrefix, material);
        for (int i = 1; i <= insulationAmount; ++i) {
            ingredients[i] = OreDictUnifier.get(OrePrefix.plate, Materials.Rubber);
        }
        ModHandler.addShapelessRecipe(String.format("%s_cable_%d", material, cableAmount), OreDictUnifier.get(cablePrefix, material), ingredients);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().input(wirePrefix, material)).input(OrePrefix.plate, Materials.Rubber, insulationAmount)).output(cablePrefix, material)).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
    }

    private static int getVoltageMultiplier(Material material) {
        return material.getBlastTemperature() >= 2800 ? GTValues.VA[1] : GTValues.VA[0];
    }
}

