/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe.handlers;

import gregtech.api.GTValues;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.IngotProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import net.minecraft.item.ItemStack;

public class PolarizingRecipeHandler {
    private static final OrePrefix[] POLARIZING_PREFIXES = new OrePrefix[]{OrePrefix.stick, OrePrefix.stickLong, OrePrefix.plate, OrePrefix.ingot, OrePrefix.plateDense, OrePrefix.rotor, OrePrefix.bolt, OrePrefix.screw, OrePrefix.wireFine, OrePrefix.foil, OrePrefix.ring};

    public static void register() {
        for (OrePrefix orePrefix : POLARIZING_PREFIXES) {
            orePrefix.addProcessingHandler(PropertyKey.INGOT, PolarizingRecipeHandler::processPolarizing);
        }
    }

    public static void processPolarizing(OrePrefix polarizingPrefix, Material material, IngotProperty property) {
        Material magneticMaterial = property.getMagneticMaterial();
        if (magneticMaterial != null && polarizingPrefix.doGenerateItem(magneticMaterial)) {
            ItemStack magneticStack = OreDictUnifier.get(polarizingPrefix, magneticMaterial);
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.POLARIZER_RECIPES.recipeBuilder().input(polarizingPrefix, material)).outputs(magneticStack)).duration((int)((long)((int)material.getMass()) * polarizingPrefix.getMaterialAmount(material) / 3628800L))).EUt(PolarizingRecipeHandler.getVoltageMultiplier(material))).buildAndRegister();
            ModHandler.addSmeltingRecipe(new UnificationEntry(polarizingPrefix, magneticMaterial), OreDictUnifier.get(polarizingPrefix, material));
        }
    }

    private static int getVoltageMultiplier(Material material) {
        if (material == Materials.Iron || material == Materials.Steel) {
            return GTValues.VH[1];
        }
        if (material == Materials.Neodymium) {
            return GTValues.VH[3];
        }
        if (material == Materials.Samarium) {
            return GTValues.VH[5];
        }
        return material.getBlastTemperature() >= 1200 ? GTValues.VA[1] : 2;
    }
}

