/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders;

import com.google.common.base.Preconditions;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WoodTypeEntry {
    @NotNull
    public final String modid;
    @NotNull
    public final String woodName;
    @NotNull
    public final ItemStack log;
    public final boolean removeCharcoalRecipe;
    public final boolean addCharcoalRecipe;
    @NotNull
    public final ItemStack planks;
    @Nullable
    public final String planksRecipeName;
    @NotNull
    public final ItemStack door;
    @Nullable
    public final String doorRecipeName;
    @NotNull
    public final ItemStack slab;
    @Nullable
    public final String slabRecipeName;
    public final boolean addSlabCraftingRecipe;
    public final ItemStack fence;
    @Nullable
    public final String fenceRecipeName;
    @NotNull
    public final ItemStack fenceGate;
    @Nullable
    public final String fenceGateRecipeName;
    @NotNull
    public final ItemStack stairs;
    public final boolean addStairsCraftingRecipe;
    @NotNull
    public final ItemStack boat;
    @Nullable
    public final String boatRecipeName;
    public final Material material;
    public final boolean addLogOreDict;
    public final boolean addPlanksOreDict;
    public final boolean addDoorsOreDict;
    public final boolean addSlabsOreDict;
    public final boolean addFencesOreDict;
    public final boolean addFenceGatesOreDict;
    public final boolean addStairsOreDict;
    public final boolean addPlanksUnificationInfo;
    public final boolean addDoorsUnificationInfo;
    public final boolean addSlabsUnificationInfo;
    public final boolean addFencesUnificationInfo;
    public final boolean addFenceGatesUnificationInfo;
    public final boolean addStairsUnificationInfo;
    public final boolean addBoatsUnificationInfo;

    private WoodTypeEntry(@NotNull String modid, @NotNull String woodName, @NotNull ItemStack log, boolean removeCharcoalRecipe, boolean addCharcoalRecipe, @NotNull ItemStack planks, @Nullable String planksRecipeName, @NotNull ItemStack door, @Nullable String doorRecipeName, @NotNull ItemStack slab, @Nullable String slabRecipeName, boolean addSlabCraftingRecipe, @NotNull ItemStack fence, @Nullable String fenceRecipeName, @NotNull ItemStack fenceGate, @Nullable String fenceGateRecipeName, @NotNull ItemStack stairs, boolean addStairsCraftingRecipe, @NotNull ItemStack boat, @Nullable String boatRecipeName, @Nullable Material material, boolean addLogOreDict, boolean addPlanksOreDict, boolean addDoorsOreDict, boolean addSlabsOreDict, boolean addFencesOreDict, boolean addFenceGatesOreDict, boolean addStairsOreDict, boolean addPlanksUnificationInfo, boolean addDoorsUnificationInfo, boolean addSlabsUnificationInfo, boolean addFencesUnificationInfo, boolean addFenceGatesUnificationInfo, boolean addStairsUnificationInfo, boolean addBoatsUnificationInfo) {
        this.modid = modid;
        this.woodName = woodName;
        this.log = log;
        this.removeCharcoalRecipe = removeCharcoalRecipe;
        this.addCharcoalRecipe = addCharcoalRecipe;
        this.planks = planks;
        this.planksRecipeName = planksRecipeName;
        this.door = door;
        this.doorRecipeName = doorRecipeName;
        this.slab = slab;
        this.slabRecipeName = slabRecipeName;
        this.addSlabCraftingRecipe = addSlabCraftingRecipe;
        this.fence = fence;
        this.fenceRecipeName = fenceRecipeName;
        this.fenceGate = fenceGate;
        this.fenceGateRecipeName = fenceGateRecipeName;
        this.stairs = stairs;
        this.addStairsCraftingRecipe = addStairsCraftingRecipe;
        this.boat = boat;
        this.boatRecipeName = boatRecipeName;
        this.material = material != null ? material : Materials.Wood;
        this.addLogOreDict = addLogOreDict;
        this.addPlanksOreDict = addPlanksOreDict;
        this.addDoorsOreDict = addDoorsOreDict;
        this.addSlabsOreDict = addSlabsOreDict;
        this.addFencesOreDict = addFencesOreDict;
        this.addFenceGatesOreDict = addFenceGatesOreDict;
        this.addStairsOreDict = addStairsOreDict;
        this.addPlanksUnificationInfo = addPlanksUnificationInfo;
        this.addDoorsUnificationInfo = addDoorsUnificationInfo;
        this.addSlabsUnificationInfo = addSlabsUnificationInfo;
        this.addFencesUnificationInfo = addFencesUnificationInfo;
        this.addFenceGatesUnificationInfo = addFenceGatesUnificationInfo;
        this.addStairsUnificationInfo = addStairsUnificationInfo;
        this.addBoatsUnificationInfo = addBoatsUnificationInfo;
    }

    @NotNull
    public UnificationEntry getStick() {
        return new UnificationEntry(OrePrefix.stick, this.material);
    }

    public static class Builder {
        private final String modid;
        private final String woodName;
        private ItemStack log = ItemStack.field_190927_a;
        private boolean removeCharcoalRecipe;
        private boolean addCharcoalRecipe;
        private ItemStack planks = ItemStack.field_190927_a;
        private String planksRecipeName;
        private ItemStack door = ItemStack.field_190927_a;
        private String doorRecipeName;
        private ItemStack slab = ItemStack.field_190927_a;
        private String slabRecipeName;
        private boolean addSlabsCraftingRecipe;
        private ItemStack fence = ItemStack.field_190927_a;
        private String fenceRecipeName;
        private ItemStack fenceGate = ItemStack.field_190927_a;
        private String fenceGateRecipeName;
        private ItemStack stairs = ItemStack.field_190927_a;
        private boolean addStairsCraftingRecipe;
        private ItemStack boat = ItemStack.field_190927_a;
        private String boatRecipeName;
        @Nullable
        private Material material = null;
        private boolean addLogOreDict;
        private boolean addPlanksOreDict;
        private boolean addDoorsOreDict;
        private boolean addSlabsOreDict;
        private boolean addFencesOreDict;
        private boolean addFenceGatesOreDict;
        private boolean addStairsOreDict;
        private boolean addPlanksUnificationInfo;
        private boolean addDoorsUnificationInfo;
        private boolean addSlabsUnificationInfo;
        private boolean addFencesUnificationInfo;
        private boolean addFenceGatesUnificationInfo;
        private boolean addStairsUnificationInfo;
        private boolean addBoatsUnificationInfo;

        public Builder(@NotNull String modid, @NotNull String woodName) {
            Preconditions.checkArgument((!modid.isEmpty() ? 1 : 0) != 0, (Object)"Modid cannot be empty.");
            Preconditions.checkArgument((!woodName.isEmpty() ? 1 : 0) != 0, (Object)"Wood name cannot be empty.");
            this.modid = modid;
            this.woodName = woodName;
        }

        public Builder log(@NotNull ItemStack log) {
            this.log = log;
            return this;
        }

        public Builder removeCharcoalRecipe() {
            this.removeCharcoalRecipe = true;
            return this;
        }

        public Builder addCharcoalRecipe() {
            this.addCharcoalRecipe = true;
            return this;
        }

        public Builder planks(@NotNull ItemStack planks, @Nullable String planksRecipeName) {
            this.planks = planks;
            this.planksRecipeName = planksRecipeName;
            return this;
        }

        public Builder door(@NotNull ItemStack door, @Nullable String doorRecipeName) {
            this.door = door;
            this.doorRecipeName = doorRecipeName;
            return this;
        }

        public Builder slab(@NotNull ItemStack slab, @Nullable String slabRecipeName) {
            this.slab = slab;
            this.slabRecipeName = slabRecipeName;
            return this;
        }

        public Builder addSlabRecipe() {
            this.addSlabsCraftingRecipe = true;
            return this;
        }

        public Builder fence(@NotNull ItemStack fence, @Nullable String fenceRecipeName) {
            this.fence = fence;
            this.fenceRecipeName = fenceRecipeName;
            return this;
        }

        public Builder fenceGate(@NotNull ItemStack fenceGate, @Nullable String fenceGateRecipeName) {
            this.fenceGate = fenceGate;
            this.fenceGateRecipeName = fenceGateRecipeName;
            return this;
        }

        public Builder stairs(@NotNull ItemStack stairs) {
            this.stairs = stairs;
            return this;
        }

        public Builder addStairsRecipe() {
            this.addStairsCraftingRecipe = true;
            return this;
        }

        public Builder boat(@NotNull ItemStack boat, @Nullable String boatRecipeName) {
            this.boat = boat;
            this.boatRecipeName = boatRecipeName;
            return this;
        }

        public Builder material(@NotNull Material material) {
            this.material = material;
            return this;
        }

        public Builder registerAllOres() {
            return this.registerOre(true, true, true, true, true, true, true);
        }

        public Builder registerAllUnificationInfo() {
            return this.registerUnificationInfo(true, true, true, true, true, true, true);
        }

        public Builder registerOre(boolean log, boolean planks, boolean door, boolean slab, boolean fence, boolean fenceGate, boolean stairs) {
            this.addLogOreDict = log;
            this.addPlanksOreDict = planks;
            this.addDoorsOreDict = door;
            this.addSlabsOreDict = slab;
            this.addFencesOreDict = fence;
            this.addFenceGatesOreDict = fenceGate;
            this.addStairsOreDict = stairs;
            return this;
        }

        public Builder registerUnificationInfo(boolean planks, boolean door, boolean slab, boolean fence, boolean fenceGate, boolean stairs, boolean boat) {
            this.addPlanksUnificationInfo = planks;
            this.addDoorsUnificationInfo = door;
            this.addSlabsUnificationInfo = slab;
            this.addFencesUnificationInfo = fence;
            this.addFenceGatesUnificationInfo = fenceGate;
            this.addStairsUnificationInfo = stairs;
            this.addBoatsUnificationInfo = boat;
            return this;
        }

        @NotNull
        public WoodTypeEntry build() {
            Preconditions.checkArgument((!this.planks.func_190926_b() ? 1 : 0) != 0, (Object)"Planks cannot be empty.");
            return new WoodTypeEntry(this.modid, this.woodName, this.log, this.removeCharcoalRecipe, this.addCharcoalRecipe, this.planks, this.planksRecipeName, this.door, this.doorRecipeName, this.slab, this.slabRecipeName, this.addSlabsCraftingRecipe, this.fence, this.fenceRecipeName, this.fenceGate, this.fenceGateRecipeName, this.stairs, this.addStairsCraftingRecipe, this.boat, this.boatRecipeName, this.material, this.addLogOreDict, this.addPlanksOreDict, this.addDoorsOreDict, this.addSlabsOreDict, this.addFencesOreDict, this.addFenceGatesOreDict, this.addStairsOreDict, this.addPlanksUnificationInfo, this.addDoorsUnificationInfo, this.addSlabsUnificationInfo, this.addFencesUnificationInfo, this.addFenceGatesUnificationInfo, this.addStairsUnificationInfo, this.addBoatsUnificationInfo);
        }
    }
}

